/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.FooterKey;
import org.eclipse.jgit.revwalk.FooterLine;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevCommit
extends RevObject {
    private static final int STACK_DEPTH = 500;
    static final RevCommit[] NO_PARENTS = new RevCommit[0];
    private RevTree tree;
    RevCommit[] parents;
    int commitTime;
    int inDegree;
    private byte[] buffer;

    public static RevCommit parse(byte[] raw2) {
        try {
            return RevCommit.parse(new RevWalk((ObjectReader)null), raw2);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static RevCommit parse(RevWalk rw, byte[] raw2) throws IOException {
        ObjectInserter.Formatter fmt = new ObjectInserter.Formatter();
        boolean retain2 = rw.isRetainBody();
        rw.setRetainBody(true);
        RevCommit r = rw.lookupCommit(fmt.idFor(1, raw2));
        r.parseCanonical(rw, raw2);
        rw.setRetainBody(retain2);
        return r;
    }

    protected RevCommit(AnyObjectId id2) {
        super(id2);
    }

    @Override
    void parseHeaders(RevWalk walk2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.parseCanonical(walk2, walk2.getCachedBytes(this));
    }

    @Override
    void parseBody(RevWalk walk2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (this.buffer == null) {
            this.buffer = walk2.getCachedBytes(this);
            if ((this.flags & 1) == 0) {
                this.parseCanonical(walk2, this.buffer);
            }
        }
    }

    void parseCanonical(RevWalk walk2, byte[] raw2) throws IOException {
        if (!walk2.shallowCommitsInitialized) {
            walk2.initializeShallowCommits();
        }
        MutableObjectId idBuffer = walk2.idBuffer;
        idBuffer.fromString(raw2, 5);
        this.tree = walk2.lookupTree(idBuffer);
        int ptr = 46;
        if (this.parents == null) {
            RevCommit[] pList = new RevCommit[1];
            int nParents = 0;
            while (raw2[ptr] == 112) {
                idBuffer.fromString(raw2, ptr + 7);
                RevCommit p = walk2.lookupCommit(idBuffer);
                if (nParents == 0) {
                    pList[nParents++] = p;
                } else if (nParents == 1) {
                    pList = new RevCommit[]{pList[0], p};
                    nParents = 2;
                } else {
                    if (pList.length <= nParents) {
                        RevCommit[] old = pList;
                        pList = new RevCommit[pList.length + 32];
                        System.arraycopy(old, 0, pList, 0, nParents);
                    }
                    pList[nParents++] = p;
                }
                ptr += 48;
            }
            if (nParents != pList.length) {
                RevCommit[] old = pList;
                pList = new RevCommit[nParents];
                System.arraycopy(old, 0, pList, 0, nParents);
            }
            this.parents = pList;
        }
        if ((ptr = RawParseUtils.committer(raw2, ptr)) > 0) {
            ptr = RawParseUtils.nextLF(raw2, ptr, '>');
            this.commitTime = RawParseUtils.parseBase10(raw2, ptr, null);
        }
        if (walk2.isRetainBody()) {
            this.buffer = raw2;
        }
        this.flags |= 1;
    }

    @Override
    public final int getType() {
        return 1;
    }

    static void carryFlags(RevCommit c, int carry) {
        FIFORevQueue q = RevCommit.carryFlags1(c, carry, 0);
        if (q != null) {
            RevCommit.slowCarryFlags(q, carry);
        }
    }

    private static FIFORevQueue carryFlags1(RevCommit c, int carry, int depth) {
        RevCommit[] pList;
        while ((pList = c.parents) != null && pList.length != 0) {
            if (pList.length != 1) {
                if (depth == 500) {
                    return RevCommit.defer(c);
                }
                for (int i = 1; i < pList.length; ++i) {
                    RevCommit p = pList[i];
                    if ((p.flags & carry) == carry) continue;
                    p.flags |= carry;
                    FIFORevQueue q = RevCommit.carryFlags1(c, carry, depth + 1);
                    if (q == null) continue;
                    return RevCommit.defer(q, carry, pList, i + 1);
                }
            }
            c = pList[0];
            if ((c.flags & carry) == carry) {
                return null;
            }
            c.flags |= carry;
        }
        return null;
    }

    private static FIFORevQueue defer(RevCommit c) {
        FIFORevQueue q = new FIFORevQueue();
        q.add(c);
        return q;
    }

    private static FIFORevQueue defer(FIFORevQueue q, int carry, RevCommit[] pList, int i) {
        RevCommit.carryOneStep(q, carry, pList[0]);
        while (i < pList.length) {
            RevCommit.carryOneStep(q, carry, pList[i]);
            ++i;
        }
        return q;
    }

    private static void slowCarryFlags(FIFORevQueue q, int carry) {
        RevCommit c;
        while ((c = q.next()) != null) {
            for (RevCommit p : c.parents) {
                RevCommit.carryOneStep(q, carry, p);
            }
        }
    }

    private static void carryOneStep(FIFORevQueue q, int carry, RevCommit c) {
        if ((c.flags & carry) != carry) {
            c.flags |= carry;
            if (c.parents != null) {
                q.add(c);
            }
        }
    }

    public void carry(RevFlag flag) {
        int carry = this.flags & flag.mask;
        if (carry != 0) {
            RevCommit.carryFlags(this, carry);
        }
    }

    public final int getCommitTime() {
        return this.commitTime;
    }

    public final RevTree getTree() {
        return this.tree;
    }

    public final int getParentCount() {
        return this.parents.length;
    }

    public final RevCommit getParent(int nth) {
        return this.parents[nth];
    }

    public final RevCommit[] getParents() {
        return this.parents;
    }

    public final byte[] getRawBuffer() {
        return this.buffer;
    }

    public final PersonIdent getAuthorIdent() {
        byte[] raw2 = this.buffer;
        int nameB = RawParseUtils.author(raw2, 0);
        if (nameB < 0) {
            return null;
        }
        return RawParseUtils.parsePersonIdent(raw2, nameB);
    }

    public final PersonIdent getCommitterIdent() {
        byte[] raw2 = this.buffer;
        int nameB = RawParseUtils.committer(raw2, 0);
        if (nameB < 0) {
            return null;
        }
        return RawParseUtils.parsePersonIdent(raw2, nameB);
    }

    public final String getFullMessage() {
        byte[] raw2 = this.buffer;
        int msgB = RawParseUtils.commitMessage(raw2, 0);
        if (msgB < 0) {
            return "";
        }
        Charset enc = RawParseUtils.parseEncoding(raw2);
        return RawParseUtils.decode(enc, raw2, msgB, raw2.length);
    }

    public final String getShortMessage() {
        byte[] raw2 = this.buffer;
        int msgB = RawParseUtils.commitMessage(raw2, 0);
        if (msgB < 0) {
            return "";
        }
        Charset enc = RawParseUtils.parseEncoding(raw2);
        int msgE = RawParseUtils.endOfParagraph(raw2, msgB);
        String str = RawParseUtils.decode(enc, raw2, msgB, msgE);
        if (RevCommit.hasLF(raw2, msgB, msgE)) {
            str = StringUtils.replaceLineBreaksWithSpace(str);
        }
        return str;
    }

    static boolean hasLF(byte[] r, int b, int e) {
        while (b < e) {
            if (r[b++] != 10) continue;
            return true;
        }
        return false;
    }

    public final Charset getEncoding() {
        return RawParseUtils.parseEncoding(this.buffer);
    }

    public final List<FooterLine> getFooterLines() {
        int keyStart;
        byte[] raw2 = this.buffer;
        int ptr = raw2.length - 1;
        while (raw2[ptr] == 10) {
            --ptr;
        }
        int msgB = RawParseUtils.commitMessage(raw2, 0);
        ArrayList<FooterLine> r = new ArrayList<FooterLine>(4);
        Charset enc = this.getEncoding();
        while ((ptr = RawParseUtils.prevLF(raw2, ptr)) > msgB && raw2[keyStart = ptr + 2] != 10) {
            int valStart;
            int keyEnd = RawParseUtils.endOfFooterLineKey(raw2, keyStart);
            if (keyEnd < 0) continue;
            for (valStart = keyEnd + 1; valStart < raw2.length && raw2[valStart] == 32; ++valStart) {
            }
            int valEnd = RawParseUtils.nextLF(raw2, valStart);
            if (raw2[valEnd - 1] == 10) {
                --valEnd;
            }
            r.add(new FooterLine(raw2, enc, keyStart, keyEnd, valStart, valEnd));
        }
        Collections.reverse(r);
        return r;
    }

    public final List<String> getFooterLines(String keyName) {
        return this.getFooterLines(new FooterKey(keyName));
    }

    public final List<String> getFooterLines(FooterKey keyName) {
        List<FooterLine> src = this.getFooterLines();
        if (src.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> r = new ArrayList<String>(src.size());
        for (FooterLine f2 : src) {
            if (!f2.matches(keyName)) continue;
            r.add(f2.getValue());
        }
        return r;
    }

    public void reset() {
        this.inDegree = 0;
    }

    final void disposeBody() {
        this.buffer = null;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append(Constants.typeString(this.getType()));
        s2.append(' ');
        s2.append(this.name());
        s2.append(' ');
        s2.append(this.commitTime);
        s2.append(' ');
        this.appendCoreFlags(s2);
        return s2.toString();
    }
}

