/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.AsyncRevObjectQueue;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.GitProtocolConstants;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.PreUploadHook;
import org.eclipse.jgit.transport.RefAdvertiser;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.transport.RequestNotYetReadException;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.SideBandOutputStream;
import org.eclipse.jgit.transport.SideBandProgressMonitor;
import org.eclipse.jgit.transport.TransferConfig;
import org.eclipse.jgit.transport.UploadPackInternalServerErrorException;
import org.eclipse.jgit.transport.UploadPackLogger;
import org.eclipse.jgit.util.io.InterruptTimer;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.eclipse.jgit.util.io.TimeoutInputStream;
import org.eclipse.jgit.util.io.TimeoutOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadPack {
    private final Repository db;
    private final RevWalk walk;
    private PackConfig packConfig;
    private TransferConfig transferConfig;
    private int timeout;
    private boolean biDirectionalPipe = true;
    private InterruptTimer timer;
    private InputStream rawIn;
    private OutputStream rawOut;
    private PacketLineIn pckIn;
    private PacketLineOut pckOut;
    private OutputStream msgOut = NullOutputStream.INSTANCE;
    private Map<String, Ref> refs;
    private AdvertiseRefsHook advertiseRefsHook = AdvertiseRefsHook.DEFAULT;
    private RefFilter refFilter = RefFilter.DEFAULT;
    private PreUploadHook preUploadHook = PreUploadHook.NULL;
    private Set<String> options;
    private final Set<ObjectId> wantIds = new HashSet<ObjectId>();
    private final Set<RevObject> wantAll = new HashSet<RevObject>();
    private final Set<RevObject> commonBase = new HashSet<RevObject>();
    private final Set<ObjectId> clientShallowCommits = new HashSet<ObjectId>();
    private final List<ObjectId> unshallowCommits = new ArrayList<ObjectId>();
    private int depth;
    private int oldestTime;
    private Boolean okToGiveUp;
    private boolean sentReady;
    private Set<ObjectId> advertised;
    private final RevFlag WANT;
    private final RevFlag PEER_HAS;
    private final RevFlag COMMON;
    private final RevFlag SATISFIED;
    private final RevFlagSet SAVE;
    private RequestValidator requestValidator = new AdvertisedRequestValidator();
    private GitProtocolConstants.MultiAck multiAck = GitProtocolConstants.MultiAck.OFF;
    private boolean noDone;
    private PackWriter.Statistics statistics;
    private UploadPackLogger logger = UploadPackLogger.NULL;

    public UploadPack(Repository copyFrom) {
        this.db = copyFrom;
        this.walk = new RevWalk(this.db);
        this.walk.setRetainBody(false);
        this.WANT = this.walk.newFlag("WANT");
        this.PEER_HAS = this.walk.newFlag("PEER_HAS");
        this.COMMON = this.walk.newFlag("COMMON");
        this.SATISFIED = this.walk.newFlag("SATISFIED");
        this.walk.carry(this.PEER_HAS);
        this.SAVE = new RevFlagSet();
        this.SAVE.add(this.WANT);
        this.SAVE.add(this.PEER_HAS);
        this.SAVE.add(this.COMMON);
        this.SAVE.add(this.SATISFIED);
        this.setTransferConfig(null);
    }

    public final Repository getRepository() {
        return this.db;
    }

    public final RevWalk getRevWalk() {
        return this.walk;
    }

    public final Map<String, Ref> getAdvertisedRefs() {
        return this.refs;
    }

    public void setAdvertisedRefs(Map<String, Ref> allRefs) {
        this.refs = allRefs != null ? allRefs : this.db.getAllRefs();
        this.refs = this.refFilter == RefFilter.DEFAULT ? this.transferConfig.getRefFilter().filter(this.refs) : this.refFilter.filter(this.refs);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public boolean isBiDirectionalPipe() {
        return this.biDirectionalPipe;
    }

    public void setBiDirectionalPipe(boolean twoWay) {
        this.biDirectionalPipe = twoWay;
    }

    public RequestPolicy getRequestPolicy() {
        if (this.requestValidator instanceof AdvertisedRequestValidator) {
            return RequestPolicy.ADVERTISED;
        }
        if (this.requestValidator instanceof ReachableCommitRequestValidator) {
            return RequestPolicy.REACHABLE_COMMIT;
        }
        if (this.requestValidator instanceof TipRequestValidator) {
            return RequestPolicy.TIP;
        }
        if (this.requestValidator instanceof ReachableCommitTipRequestValidator) {
            return RequestPolicy.REACHABLE_COMMIT_TIP;
        }
        if (this.requestValidator instanceof AnyRequestValidator) {
            return RequestPolicy.ANY;
        }
        return null;
    }

    public void setRequestPolicy(RequestPolicy policy) {
        switch (policy) {
            default: {
                this.requestValidator = new AdvertisedRequestValidator();
                break;
            }
            case REACHABLE_COMMIT: {
                this.requestValidator = new ReachableCommitRequestValidator();
                break;
            }
            case TIP: {
                this.requestValidator = new TipRequestValidator();
                break;
            }
            case REACHABLE_COMMIT_TIP: {
                this.requestValidator = new ReachableCommitTipRequestValidator();
                break;
            }
            case ANY: {
                this.requestValidator = new AnyRequestValidator();
            }
        }
    }

    public void setRequestValidator(RequestValidator validator) {
        this.requestValidator = validator != null ? validator : new AdvertisedRequestValidator();
    }

    public AdvertiseRefsHook getAdvertiseRefsHook() {
        return this.advertiseRefsHook;
    }

    public RefFilter getRefFilter() {
        return this.refFilter;
    }

    public void setAdvertiseRefsHook(AdvertiseRefsHook advertiseRefsHook) {
        this.advertiseRefsHook = advertiseRefsHook != null ? advertiseRefsHook : AdvertiseRefsHook.DEFAULT;
    }

    public void setRefFilter(RefFilter refFilter) {
        this.refFilter = refFilter != null ? refFilter : RefFilter.DEFAULT;
    }

    public PreUploadHook getPreUploadHook() {
        return this.preUploadHook;
    }

    public void setPreUploadHook(PreUploadHook hook) {
        this.preUploadHook = hook != null ? hook : PreUploadHook.NULL;
    }

    public void setPackConfig(PackConfig pc) {
        this.packConfig = pc;
    }

    public void setTransferConfig(TransferConfig tc) {
        this.transferConfig = tc != null ? tc : new TransferConfig(this.db);
        this.setRequestPolicy(this.transferConfig.isAllowTipSha1InWant() ? RequestPolicy.TIP : RequestPolicy.ADVERTISED);
    }

    public UploadPackLogger getLogger() {
        return this.logger;
    }

    public void setLogger(UploadPackLogger logger2) {
        this.logger = logger2;
    }

    public boolean isSideBand() throws RequestNotYetReadException {
        if (this.options == null) {
            throw new RequestNotYetReadException();
        }
        return this.options.contains("side-band") || this.options.contains("side-band-64k");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void upload(InputStream input2, OutputStream output2, OutputStream messages2) throws IOException {
        try {
            this.rawIn = input2;
            this.rawOut = output2;
            if (messages2 != null) {
                this.msgOut = messages2;
            }
            if (this.timeout > 0) {
                Thread caller = Thread.currentThread();
                this.timer = new InterruptTimer(caller.getName() + "-Timer");
                TimeoutInputStream i = new TimeoutInputStream(this.rawIn, this.timer);
                TimeoutOutputStream o = new TimeoutOutputStream(this.rawOut, this.timer);
                i.setTimeout(this.timeout * 1000);
                o.setTimeout(this.timeout * 1000);
                this.rawIn = i;
                this.rawOut = o;
            }
            this.pckIn = new PacketLineIn(this.rawIn);
            this.pckOut = new PacketLineOut(this.rawOut);
            this.service();
            Object var8_7 = null;
            this.msgOut = NullOutputStream.INSTANCE;
            this.walk.release();
            if (this.timer == null) return;
        }
        catch (Throwable throwable2) {
            Object var8_8 = null;
            this.msgOut = NullOutputStream.INSTANCE;
            this.walk.release();
            if (this.timer == null) throw throwable2;
            try {
                this.timer.terminate();
                Object var10_11 = null;
                this.timer = null;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                Object var10_12 = null;
                this.timer = null;
                throw throwable3;
            }
        }
        try {
            this.timer.terminate();
            Object var10_9 = null;
            this.timer = null;
            return;
        }
        catch (Throwable throwable4) {
            Object var10_10 = null;
            this.timer = null;
            throw throwable4;
        }
    }

    public PackWriter.Statistics getPackStatistics() {
        return this.statistics;
    }

    private Map<String, Ref> getAdvertisedOrDefaultRefs() {
        if (this.refs == null) {
            this.setAdvertisedRefs(null);
        }
        return this.refs;
    }

    private void service() throws IOException {
        boolean sendPack;
        if (this.biDirectionalPipe) {
            this.sendAdvertisedRefs(new RefAdvertiser.PacketLineOutRefAdvertiser(this.pckOut));
        } else {
            this.advertised = this.requestValidator instanceof AnyRequestValidator ? Collections.emptySet() : UploadPack.refIdSet(this.getAdvertisedOrDefaultRefs().values());
        }
        try {
            this.recvWants();
            if (this.wantIds.isEmpty()) {
                this.preUploadHook.onBeginNegotiateRound(this, this.wantIds, 0);
                this.preUploadHook.onEndNegotiateRound(this, this.wantIds, 0, 0, false);
                return;
            }
            if (this.options.contains("multi_ack_detailed")) {
                this.multiAck = GitProtocolConstants.MultiAck.DETAILED;
                this.noDone = this.options.contains("no-done");
            } else {
                this.multiAck = this.options.contains("multi_ack") ? GitProtocolConstants.MultiAck.CONTINUE : GitProtocolConstants.MultiAck.OFF;
            }
            if (this.depth != 0) {
                this.processShallow();
            }
            if (!this.clientShallowCommits.isEmpty()) {
                this.walk.assumeShallow(this.clientShallowCommits);
            }
            sendPack = this.negotiate();
        }
        catch (PackProtocolException err2) {
            this.reportErrorDuringNegotiate(err2.getMessage());
            throw err2;
        }
        catch (ServiceMayNotContinueException err3) {
            if (!err3.isOutput() && err3.getMessage() != null) {
                try {
                    this.pckOut.writeString("ERR " + err3.getMessage() + "\n");
                    err3.setOutput();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            throw err3;
        }
        catch (IOException err4) {
            this.reportErrorDuringNegotiate(JGitText.get().internalServerError);
            throw err4;
        }
        catch (RuntimeException err5) {
            this.reportErrorDuringNegotiate(JGitText.get().internalServerError);
            throw err5;
        }
        catch (Error err6) {
            this.reportErrorDuringNegotiate(JGitText.get().internalServerError);
            throw err6;
        }
        if (sendPack) {
            this.sendPack();
        }
    }

    private static Set<ObjectId> refIdSet(Collection<Ref> refs) {
        HashSet<ObjectId> ids = new HashSet<ObjectId>(refs.size());
        for (Ref ref2 : refs) {
            if (ref2.getObjectId() == null) continue;
            ids.add(ref2.getObjectId());
        }
        return ids;
    }

    private void reportErrorDuringNegotiate(String msg) {
        try {
            this.pckOut.writeString("ERR " + msg + "\n");
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    private void processShallow() throws IOException {
        RevCommit o;
        DepthWalk.RevWalk depthWalk = new DepthWalk.RevWalk(this.walk.getObjectReader(), this.depth);
        for (ObjectId o2 : this.wantIds) {
            try {
                depthWalk.markRoot(depthWalk.parseCommit(o2));
            }
            catch (IncorrectObjectTypeException notCommit) {}
        }
        while ((o = depthWalk.next()) != null) {
            DepthWalk.Commit c = (DepthWalk.Commit)o;
            if (c.getDepth() == this.depth && !this.clientShallowCommits.contains(c)) {
                this.pckOut.writeString("shallow " + o.name());
            }
            if (c.getDepth() >= this.depth || !this.clientShallowCommits.remove(c)) continue;
            this.unshallowCommits.add(c.copy());
            this.pckOut.writeString("unshallow " + c.name());
        }
        this.pckOut.end();
    }

    public void sendAdvertisedRefs(RefAdvertiser adv) throws IOException, ServiceMayNotContinueException {
        RequestPolicy policy;
        try {
            this.advertiseRefsHook.advertiseRefs(this);
        }
        catch (ServiceMayNotContinueException fail2) {
            if (fail2.getMessage() != null) {
                adv.writeOne("ERR " + fail2.getMessage());
                fail2.setOutput();
            }
            throw fail2;
        }
        adv.init(this.db);
        adv.advertiseCapability("include-tag");
        adv.advertiseCapability("multi_ack_detailed");
        adv.advertiseCapability("multi_ack");
        adv.advertiseCapability("ofs-delta");
        adv.advertiseCapability("side-band");
        adv.advertiseCapability("side-band-64k");
        adv.advertiseCapability("thin-pack");
        adv.advertiseCapability("no-progress");
        adv.advertiseCapability("shallow");
        if (!this.biDirectionalPipe) {
            adv.advertiseCapability("no-done");
        }
        if ((policy = this.getRequestPolicy()) == RequestPolicy.TIP || policy == RequestPolicy.REACHABLE_COMMIT_TIP || policy == null) {
            adv.advertiseCapability("allow-tip-sha1-in-want");
        }
        adv.setDerefTags(true);
        Map<String, Ref> refs = this.getAdvertisedOrDefaultRefs();
        this.findSymrefs(adv, refs);
        this.advertised = adv.send(refs);
        if (adv.isEmpty()) {
            adv.advertiseId(ObjectId.zeroId(), "capabilities^{}");
        }
        adv.end();
    }

    public void sendMessage(String what) {
        try {
            this.msgOut.write(Constants.encode(what + "\n"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public OutputStream getMessageOutputStream() {
        return this.msgOut;
    }

    private void recvWants() throws IOException {
        boolean isFirst = true;
        while (true) {
            String line;
            try {
                line = this.pckIn.readString();
            }
            catch (EOFException eof) {
                if (isFirst) break;
                throw eof;
            }
            if (line == PacketLineIn.END) break;
            if (line.startsWith("deepen ")) {
                this.depth = Integer.parseInt(line.substring(7));
                continue;
            }
            if (line.startsWith("shallow ")) {
                this.clientShallowCommits.add(ObjectId.fromString(line.substring(8)));
                continue;
            }
            if (!line.startsWith("want ") || line.length() < 45) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "want", line));
            }
            if (isFirst) {
                if (line.length() > 45) {
                    FirstLine firstLine = new FirstLine(line);
                    this.options = firstLine.getOptions();
                    line = firstLine.getLine();
                } else {
                    this.options = Collections.emptySet();
                }
            }
            this.wantIds.add(ObjectId.fromString(line.substring(5)));
            isFirst = false;
        }
    }

    private boolean negotiate() throws IOException {
        String line;
        this.okToGiveUp = Boolean.FALSE;
        ObjectId last2 = ObjectId.zeroId();
        ArrayList<ObjectId> peerHas = new ArrayList<ObjectId>(64);
        while (true) {
            try {
                line = this.pckIn.readString();
            }
            catch (EOFException eof) {
                if (!this.biDirectionalPipe && this.depth > 0) {
                    return false;
                }
                throw eof;
            }
            if (line == PacketLineIn.END) {
                last2 = this.processHaveLines(peerHas, last2);
                if (this.commonBase.isEmpty() || this.multiAck != GitProtocolConstants.MultiAck.OFF) {
                    this.pckOut.writeString("NAK\n");
                }
                if (this.noDone && this.sentReady) {
                    this.pckOut.writeString("ACK " + last2.name() + "\n");
                    return true;
                }
                if (!this.biDirectionalPipe) {
                    return false;
                }
                this.pckOut.flush();
                continue;
            }
            if (!line.startsWith("have ") || line.length() != 45) break;
            peerHas.add(ObjectId.fromString(line.substring(5)));
        }
        if (line.equals("done")) {
            last2 = this.processHaveLines(peerHas, last2);
            if (this.commonBase.isEmpty()) {
                this.pckOut.writeString("NAK\n");
            } else if (this.multiAck != GitProtocolConstants.MultiAck.OFF) {
                this.pckOut.writeString("ACK " + last2.name() + "\n");
            }
            return true;
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "have", line));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectId processHaveLines(List<ObjectId> peerHas, ObjectId last2) throws IOException {
        this.preUploadHook.onBeginNegotiateRound(this, this.wantIds, peerHas.size());
        if (this.wantAll.isEmpty() && !this.wantIds.isEmpty()) {
            this.parseWants();
        }
        if (peerHas.isEmpty()) {
            return last2;
        }
        this.sentReady = false;
        int haveCnt = 0;
        this.walk.getObjectReader().setAvoidUnreachableObjects(true);
        AsyncRevObjectQueue q = this.walk.parseAny(peerHas, false);
        try {
            while (true) {
                RevObject obj2;
                try {
                    obj2 = q.next();
                }
                catch (MissingObjectException notFound) {
                    continue;
                }
                if (obj2 == null) break;
                last2 = obj2;
                ++haveCnt;
                if (obj2 instanceof RevCommit) {
                    RevCommit c = (RevCommit)obj2;
                    if (this.oldestTime == 0 || c.getCommitTime() < this.oldestTime) {
                        this.oldestTime = c.getCommitTime();
                    }
                }
                if (obj2.has(this.PEER_HAS)) continue;
                obj2.add(this.PEER_HAS);
                if (obj2 instanceof RevCommit) {
                    ((RevCommit)obj2).carry(this.PEER_HAS);
                }
                this.addCommonBase(obj2);
                switch (this.multiAck) {
                    case OFF: {
                        if (this.commonBase.size() != 1) break;
                        this.pckOut.writeString("ACK " + obj2.name() + "\n");
                        break;
                    }
                    case CONTINUE: {
                        this.pckOut.writeString("ACK " + obj2.name() + " continue\n");
                        break;
                    }
                    case DETAILED: {
                        this.pckOut.writeString("ACK " + obj2.name() + " common\n");
                    }
                }
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable2) {
            Object var8_11 = null;
            q.release();
            this.walk.getObjectReader().setAvoidUnreachableObjects(false);
            throw throwable2;
        }
        q.release();
        this.walk.getObjectReader().setAvoidUnreachableObjects(false);
        int missCnt = peerHas.size() - haveCnt;
        boolean didOkToGiveUp = false;
        if (0 < missCnt) {
            for (int i = peerHas.size() - 1; i >= 0; --i) {
                ObjectId id2 = peerHas.get(i);
                if (this.walk.lookupOrNull(id2) != null) continue;
                didOkToGiveUp = true;
                if (!this.okToGiveUp()) break;
                switch (this.multiAck) {
                    case OFF: {
                        break;
                    }
                    case CONTINUE: {
                        this.pckOut.writeString("ACK " + id2.name() + " continue\n");
                        break;
                    }
                    case DETAILED: {
                        this.pckOut.writeString("ACK " + id2.name() + " ready\n");
                        this.sentReady = true;
                    }
                }
                break;
            }
        }
        if (this.multiAck == GitProtocolConstants.MultiAck.DETAILED && !didOkToGiveUp && this.okToGiveUp()) {
            ObjectId id3 = peerHas.get(peerHas.size() - 1);
            this.sentReady = true;
            this.pckOut.writeString("ACK " + id3.name() + " ready\n");
            this.sentReady = true;
        }
        this.preUploadHook.onEndNegotiateRound(this, this.wantAll, haveCnt, missCnt, this.sentReady);
        peerHas.clear();
        return last2;
    }

    private void parseWants() throws IOException {
        ArrayList<ObjectId> notAdvertisedWants = null;
        for (ObjectId obj2 : this.wantIds) {
            if (this.advertised.contains(obj2)) continue;
            if (notAdvertisedWants == null) {
                notAdvertisedWants = new ArrayList<ObjectId>();
            }
            notAdvertisedWants.add(obj2);
        }
        if (notAdvertisedWants != null) {
            this.requestValidator.checkWants(this, notAdvertisedWants);
        }
        AsyncRevObjectQueue q = this.walk.parseAny(this.wantIds, true);
        try {
            try {
                ObjectId obj2;
                while ((obj2 = q.next()) != null) {
                    this.want((RevObject)obj2);
                    if (!(obj2 instanceof RevCommit)) {
                        ((RevObject)obj2).add(this.SATISFIED);
                    }
                    if (!(obj2 instanceof RevTag) || !((obj2 = this.walk.peel((RevObject)obj2)) instanceof RevCommit)) continue;
                    this.want((RevObject)obj2);
                }
                this.wantIds.clear();
            }
            catch (MissingObjectException notFound) {
                ObjectId id2 = notFound.getObjectId();
                throw new PackProtocolException(MessageFormat.format(JGitText.get().wantNotValid, id2.name()), notFound);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable2) {
            Object var6_6 = null;
            q.release();
            throw throwable2;
        }
        q.release();
    }

    private void want(RevObject obj2) {
        if (!obj2.has(this.WANT)) {
            obj2.add(this.WANT);
            this.wantAll.add(obj2);
        }
    }

    private static void checkNotAdvertisedWants(RevWalk walk2, List<ObjectId> notAdvertisedWants, Set<ObjectId> reachableFrom) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        AsyncRevObjectQueue q = walk2.parseAny(notAdvertisedWants, true);
        try {
            try {
                RevObject obj2;
                while ((obj2 = q.next()) != null) {
                    if (!(obj2 instanceof RevCommit)) {
                        throw new PackProtocolException(MessageFormat.format(JGitText.get().wantNotValid, obj2.name()));
                    }
                    walk2.markStart((RevCommit)obj2);
                }
                Object var7_6 = null;
            }
            catch (MissingObjectException notFound) {
                ObjectId id2 = notFound.getObjectId();
                throw new PackProtocolException(MessageFormat.format(JGitText.get().wantNotValid, id2.name()), notFound);
            }
        }
        catch (Throwable throwable2) {
            Object var7_7 = null;
            q.release();
            throw throwable2;
        }
        q.release();
        for (ObjectId id3 : reachableFrom) {
            try {
                walk2.markUninteresting(walk2.parseCommit(id3));
            }
            catch (IncorrectObjectTypeException notCommit) {}
        }
        RevCommit bad = walk2.next();
        if (bad != null) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().wantNotValid, bad.name()));
        }
        walk2.reset();
    }

    private void addCommonBase(RevObject o) {
        if (!o.has(this.COMMON)) {
            o.add(this.COMMON);
            this.commonBase.add(o);
            this.okToGiveUp = null;
        }
    }

    private boolean okToGiveUp() throws PackProtocolException {
        if (this.okToGiveUp == null) {
            this.okToGiveUp = this.okToGiveUpImp();
        }
        return this.okToGiveUp;
    }

    private boolean okToGiveUpImp() throws PackProtocolException {
        if (this.commonBase.isEmpty()) {
            return false;
        }
        try {
            for (RevObject obj2 : this.wantAll) {
                if (this.wantSatisfied(obj2)) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new PackProtocolException(JGitText.get().internalRevisionError, e);
        }
    }

    private boolean wantSatisfied(RevObject want) throws IOException {
        RevCommit c;
        if (want.has(this.SATISFIED)) {
            return true;
        }
        this.walk.resetRetain(this.SAVE);
        this.walk.markStart((RevCommit)want);
        if (this.oldestTime != 0) {
            this.walk.setRevFilter(CommitTimeRevFilter.after((long)this.oldestTime * 1000L));
        }
        while ((c = this.walk.next()) != null) {
            if (!c.has(this.PEER_HAS)) continue;
            this.addCommonBase(c);
            want.add(this.SATISFIED);
            return true;
        }
        return false;
    }

    private void sendPack() throws IOException {
        int eof;
        boolean sideband;
        boolean bl = sideband = this.options.contains("side-band") || this.options.contains("side-band-64k");
        if (!this.biDirectionalPipe && 0 <= (eof = this.rawIn.read())) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().expectedEOFReceived, "\\x" + Integer.toHexString(eof)));
        }
        if (sideband) {
            try {
                this.sendPack(true);
            }
            catch (ServiceMayNotContinueException noPack) {
                throw noPack;
            }
            catch (IOException err2) {
                if (this.reportInternalServerErrorOverSideband()) {
                    throw new UploadPackInternalServerErrorException(err2);
                }
                throw err2;
            }
            catch (RuntimeException err3) {
                if (this.reportInternalServerErrorOverSideband()) {
                    throw new UploadPackInternalServerErrorException(err3);
                }
                throw err3;
            }
            catch (Error err4) {
                if (this.reportInternalServerErrorOverSideband()) {
                    throw new UploadPackInternalServerErrorException(err4);
                }
                throw err4;
            }
        } else {
            this.sendPack(false);
        }
    }

    private boolean reportInternalServerErrorOverSideband() {
        try {
            SideBandOutputStream err2 = new SideBandOutputStream(3, 1000, this.rawOut);
            err2.write(Constants.encode(JGitText.get().internalServerError));
            err2.flush();
            return true;
        }
        catch (Throwable cannotReport) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPack(boolean sideband) throws IOException {
        ProgressMonitor pm = NullProgressMonitor.INSTANCE;
        OutputStream packOut = this.rawOut;
        if (sideband) {
            int bufsz = 1000;
            if (this.options.contains("side-band-64k")) {
                bufsz = 65520;
            }
            packOut = new SideBandOutputStream(1, bufsz, this.rawOut);
            if (!this.options.contains("no-progress")) {
                this.msgOut = new SideBandOutputStream(2, bufsz, this.rawOut);
                pm = new SideBandProgressMonitor(this.msgOut);
            }
        }
        try {
            if (this.wantAll.isEmpty()) {
                this.preUploadHook.onSendPack(this, this.wantIds, this.commonBase);
            } else {
                this.preUploadHook.onSendPack(this, this.wantAll, this.commonBase);
            }
            this.msgOut.flush();
        }
        catch (ServiceMayNotContinueException noPack) {
            if (sideband && noPack.getMessage() != null) {
                noPack.setOutput();
                SideBandOutputStream err2 = new SideBandOutputStream(3, 1000, this.rawOut);
                err2.write(Constants.encode(noPack.getMessage()));
                err2.flush();
            }
            throw noPack;
        }
        PackConfig cfg = this.packConfig;
        if (cfg == null) {
            cfg = new PackConfig(this.db);
        }
        PackWriter pw = new PackWriter(cfg, this.walk.getObjectReader());
        try {
            pw.setIndexDisabled(true);
            pw.setUseCachedPacks(true);
            pw.setUseBitmaps(this.depth == 0 && this.clientShallowCommits.isEmpty());
            pw.setReuseDeltaCommits(true);
            pw.setDeltaBaseAsOffset(this.options.contains("ofs-delta"));
            pw.setThin(this.options.contains("thin-pack"));
            pw.setReuseValidatingObjects(false);
            if (this.commonBase.isEmpty() && this.refs != null) {
                HashSet<ObjectId> tagTargets = new HashSet<ObjectId>();
                for (Ref ref2 : this.refs.values()) {
                    if (ref2.getPeeledObjectId() != null) {
                        tagTargets.add(ref2.getPeeledObjectId());
                        continue;
                    }
                    if (ref2.getObjectId() == null || !ref2.getName().startsWith("refs/heads/")) continue;
                    tagTargets.add(ref2.getObjectId());
                }
                pw.setTagTargets(tagTargets);
            }
            if (this.depth > 0) {
                pw.setShallowPack(this.depth, this.unshallowCommits);
            }
            RevWalk rw = this.walk;
            if (this.wantAll.isEmpty()) {
                pw.preparePack(pm, this.wantIds, this.commonBase);
            } else {
                this.walk.reset();
                ObjectWalk ow = this.walk.toObjectWalkWithSameObjects();
                pw.preparePack(pm, ow, this.wantAll, this.commonBase);
                rw = ow;
            }
            if (this.options.contains("include-tag") && this.refs != null) {
                for (Ref ref2 : this.refs.values()) {
                    ObjectId peeledId;
                    RevObject obj2;
                    ObjectId objectId = ref2.getObjectId();
                    if (!this.wantAll.isEmpty() ? (obj2 = rw.lookupOrNull(objectId)) != null && obj2.has(this.WANT) : this.wantIds.contains(objectId)) continue;
                    if (!ref2.isPeeled()) {
                        ref2 = this.db.peel(ref2);
                    }
                    if ((peeledId = ref2.getPeeledObjectId()) == null) continue;
                    objectId = ref2.getObjectId();
                    if (!pw.willInclude(peeledId) || pw.willInclude(objectId)) continue;
                    pw.addObject(rw.parseAny(objectId));
                }
            }
            pw.writePack(pm, NullProgressMonitor.INSTANCE, packOut);
            if (this.msgOut != NullOutputStream.INSTANCE) {
                String msg = pw.getStatistics().getMessage() + '\n';
                this.msgOut.write(Constants.encode(msg));
                this.msgOut.flush();
            }
            Object var12_14 = null;
            this.statistics = pw.getStatistics();
            if (this.statistics != null) {
                this.logger.onPackStatistics(this.statistics);
            }
            pw.release();
        }
        catch (Throwable throwable2) {
            Object var12_15 = null;
            this.statistics = pw.getStatistics();
            if (this.statistics != null) {
                this.logger.onPackStatistics(this.statistics);
            }
            pw.release();
            throw throwable2;
        }
        if (sideband) {
            this.pckOut.end();
        }
    }

    private void findSymrefs(RefAdvertiser adv, Map<String, Ref> refs) {
        Ref head2 = refs.get("HEAD");
        if (head2 != null && head2.isSymbolic()) {
            adv.addSymref("HEAD", head2.getLeaf().getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AdvertisedRequestValidator
    implements RequestValidator {
        @Override
        public void checkWants(UploadPack up2, List<ObjectId> wants) throws PackProtocolException, IOException {
            if (!up2.isBiDirectionalPipe()) {
                new ReachableCommitRequestValidator().checkWants(up2, wants);
            } else if (!wants.isEmpty()) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().wantNotValid, wants.iterator().next().name()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AnyRequestValidator
    implements RequestValidator {
        @Override
        public void checkWants(UploadPack up2, List<ObjectId> wants) throws PackProtocolException, IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FirstLine {
        private final String line;
        private final Set<String> options;

        public FirstLine(String line) {
            if (line.length() > 45) {
                HashSet<String> opts = new HashSet<String>();
                String opt2 = line.substring(45);
                if (opt2.startsWith(" ")) {
                    opt2 = opt2.substring(1);
                }
                for (String c : opt2.split(" ")) {
                    opts.add(c);
                }
                this.line = line.substring(0, 45);
                this.options = Collections.unmodifiableSet(opts);
            } else {
                this.line = line;
                this.options = Collections.emptySet();
            }
        }

        public String getLine() {
            return this.line;
        }

        public Set<String> getOptions() {
            return this.options;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ReachableCommitRequestValidator
    implements RequestValidator {
        @Override
        public void checkWants(UploadPack up2, List<ObjectId> wants) throws PackProtocolException, IOException {
            UploadPack.checkNotAdvertisedWants(up2.getRevWalk(), wants, UploadPack.refIdSet(up2.getAdvertisedRefs().values()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ReachableCommitTipRequestValidator
    implements RequestValidator {
        @Override
        public void checkWants(UploadPack up2, List<ObjectId> wants) throws PackProtocolException, IOException {
            UploadPack.checkNotAdvertisedWants(up2.getRevWalk(), wants, UploadPack.refIdSet(up2.getRepository().getRefDatabase().getRefs("").values()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestPolicy {
        ADVERTISED,
        REACHABLE_COMMIT,
        TIP,
        REACHABLE_COMMIT_TIP,
        ANY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RequestValidator {
        public void checkWants(UploadPack var1, List<ObjectId> var2) throws PackProtocolException, IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TipRequestValidator
    implements RequestValidator {
        @Override
        public void checkWants(UploadPack up2, List<ObjectId> wants) throws PackProtocolException, IOException {
            if (!up2.isBiDirectionalPipe()) {
                new ReachableCommitTipRequestValidator().checkWants(up2, wants);
            } else if (!wants.isEmpty()) {
                Set refIds = UploadPack.refIdSet(up2.getRepository().getRefDatabase().getRefs("").values());
                for (ObjectId obj2 : wants) {
                    if (refIds.contains(obj2)) continue;
                    throw new PackProtocolException(MessageFormat.format(JGitText.get().wantNotValid, obj2.name()));
                }
            }
        }
    }
}

