/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class TreeFilterMarker {
    private final TreeFilter[] filters;

    public TreeFilterMarker(TreeFilter[] markTreeFilters) {
        if (markTreeFilters.length > 32) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().treeFilterMarkerTooManyFilters, 32, markTreeFilters.length));
        }
        this.filters = new TreeFilter[markTreeFilters.length];
        System.arraycopy(markTreeFilters, 0, this.filters, 0, markTreeFilters.length);
    }

    public int getMarks(TreeWalk walk2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        int marks = 0;
        for (int index2 = 0; index2 < this.filters.length; ++index2) {
            TreeFilter filter2 = this.filters[index2];
            if (filter2 == null) continue;
            try {
                boolean marked = filter2.include(walk2);
                if (!marked) continue;
                marks = (int)((long)marks | 1L << index2);
                continue;
            }
            catch (StopWalkException e) {
                this.filters[index2] = null;
            }
        }
        return marks;
    }
}

