/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.io.InterruptTimer;

public class TimeoutInputStream
extends FilterInputStream {
    private final InterruptTimer myTimer;
    private int timeout;

    public TimeoutInputStream(InputStream src, InterruptTimer timer) {
        super(src);
        this.myTimer = timer;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int millis) {
        if (millis < 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeout, millis));
        }
        this.timeout = millis;
    }

    public int read() throws IOException {
        try {
            this.beginRead();
            int n = super.read();
            Object var3_3 = null;
            this.endRead();
            return n;
        }
        catch (InterruptedIOException e) {
            try {
                throw this.readTimedOut();
            }
            catch (Throwable throwable2) {
                Object var3_4 = null;
                this.endRead();
                throw throwable2;
            }
        }
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int off, int cnt) throws IOException {
        try {
            this.beginRead();
            int n = super.read(buf, off, cnt);
            Object var6_6 = null;
            this.endRead();
            return n;
        }
        catch (InterruptedIOException e) {
            try {
                throw this.readTimedOut();
            }
            catch (Throwable throwable2) {
                Object var6_7 = null;
                this.endRead();
                throw throwable2;
            }
        }
    }

    public long skip(long cnt) throws IOException {
        try {
            this.beginRead();
            long l = super.skip(cnt);
            Object var6_4 = null;
            this.endRead();
            return l;
        }
        catch (InterruptedIOException e) {
            try {
                throw this.readTimedOut();
            }
            catch (Throwable throwable2) {
                Object var6_5 = null;
                this.endRead();
                throw throwable2;
            }
        }
    }

    private void beginRead() {
        this.myTimer.begin(this.timeout);
    }

    private void endRead() {
        this.myTimer.end();
    }

    private InterruptedIOException readTimedOut() {
        return new InterruptedIOException(MessageFormat.format(JGitText.get().readTimedOut, this.timeout));
    }
}

