/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.util.Annotations;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;

public final class ManagedReferenceProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final String _referenceName;
    protected final boolean _isContainer;
    protected final SettableBeanProperty _managedProperty;
    protected final SettableBeanProperty _backProperty;

    public ManagedReferenceProperty(SettableBeanProperty forward, String refName, SettableBeanProperty backward, Annotations contextAnnotations, boolean isContainer) {
        super(forward.getFullName(), forward.getType(), forward.getWrapperName(), forward.getValueTypeDeserializer(), contextAnnotations, forward.getMetadata());
        this._referenceName = refName;
        this._managedProperty = forward;
        this._backProperty = backward;
        this._isContainer = isContainer;
    }

    protected ManagedReferenceProperty(ManagedReferenceProperty src, JsonDeserializer<?> deser) {
        super((SettableBeanProperty)src, deser);
        this._referenceName = src._referenceName;
        this._isContainer = src._isContainer;
        this._managedProperty = src._managedProperty;
        this._backProperty = src._backProperty;
    }

    protected ManagedReferenceProperty(ManagedReferenceProperty src, PropertyName newName) {
        super((SettableBeanProperty)src, newName);
        this._referenceName = src._referenceName;
        this._isContainer = src._isContainer;
        this._managedProperty = src._managedProperty;
        this._backProperty = src._backProperty;
    }

    @Override
    public ManagedReferenceProperty withName(PropertyName newName) {
        return new ManagedReferenceProperty(this, newName);
    }

    @Override
    public ManagedReferenceProperty withValueDeserializer(JsonDeserializer<?> deser) {
        if (this._valueDeserializer == deser) {
            return this;
        }
        return new ManagedReferenceProperty(this, deser);
    }

    @Override
    public void fixAccess(DeserializationConfig config) {
        this._managedProperty.fixAccess(config);
        this._backProperty.fixAccess(config);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._managedProperty.getAnnotation(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._managedProperty.getMember();
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance2) throws IOException {
        this.set(instance2, this._managedProperty.deserialize(p, ctxt));
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance2) throws IOException {
        return this.setAndReturn(instance2, this.deserialize(p, ctxt));
    }

    @Override
    public final void set(Object instance2, Object value2) throws IOException {
        this.setAndReturn(instance2, value2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object setAndReturn(Object instance2, Object value2) throws IOException {
        if (value2 == null) return this._managedProperty.setAndReturn(instance2, value2);
        if (this._isContainer) {
            if (value2 instanceof Object[]) {
                for (Object ob : (Object[])value2) {
                    if (ob == null) continue;
                    this._backProperty.set(ob, instance2);
                }
                return this._managedProperty.setAndReturn(instance2, value2);
            } else if (value2 instanceof Collection) {
                for (Object ob : (Collection)value2) {
                    if (ob == null) continue;
                    this._backProperty.set(ob, instance2);
                }
                return this._managedProperty.setAndReturn(instance2, value2);
            } else {
                if (!(value2 instanceof Map)) throw new IllegalStateException("Unsupported container type (" + value2.getClass().getName() + ") when resolving reference '" + this._referenceName + "'");
                for (Object ob : ((Map)value2).values()) {
                    if (ob == null) continue;
                    this._backProperty.set(ob, instance2);
                }
            }
            return this._managedProperty.setAndReturn(instance2, value2);
        } else {
            this._backProperty.set(value2, instance2);
        }
        return this._managedProperty.setAndReturn(instance2, value2);
    }
}

