/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeSerializerBase;
import java.io.IOException;

public class AsArrayTypeSerializer
extends TypeSerializerBase {
    public AsArrayTypeSerializer(TypeIdResolver idRes, BeanProperty property) {
        super(idRes, property);
    }

    @Override
    public AsArrayTypeSerializer forProperty(BeanProperty prop) {
        return this._property == prop ? this : new AsArrayTypeSerializer(this._idResolver, prop);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.WRAPPER_ARRAY;
    }

    @Override
    public void writeTypePrefixForObject(Object value2, JsonGenerator g2) throws IOException {
        String typeId = this.idFromValue(value2);
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
        } else {
            g2.writeStartArray();
            g2.writeString(typeId);
        }
        g2.writeStartObject();
    }

    @Override
    public void writeTypePrefixForObject(Object value2, JsonGenerator g2, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value2, type);
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
        } else {
            g2.writeStartArray();
            g2.writeString(typeId);
        }
        g2.writeStartObject();
    }

    @Override
    public void writeTypePrefixForArray(Object value2, JsonGenerator g2) throws IOException {
        String typeId = this.idFromValue(value2);
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
        } else {
            g2.writeStartArray();
            g2.writeString(typeId);
        }
        g2.writeStartArray();
    }

    @Override
    public void writeTypePrefixForArray(Object value2, JsonGenerator g2, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value2, type);
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
        } else {
            g2.writeStartArray();
            g2.writeString(typeId);
        }
        g2.writeStartArray();
    }

    @Override
    public void writeTypePrefixForScalar(Object value2, JsonGenerator g2) throws IOException {
        String typeId = this.idFromValue(value2);
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
        } else {
            g2.writeStartArray();
            g2.writeString(typeId);
        }
    }

    @Override
    public void writeTypePrefixForScalar(Object value2, JsonGenerator g2, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value2, type);
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
        } else {
            g2.writeStartArray();
            g2.writeString(typeId);
        }
    }

    @Override
    public void writeTypeSuffixForObject(Object value2, JsonGenerator g2) throws IOException {
        g2.writeEndObject();
        if (!g2.canWriteTypeId()) {
            g2.writeEndArray();
        }
    }

    @Override
    public void writeTypeSuffixForArray(Object value2, JsonGenerator g2) throws IOException {
        g2.writeEndArray();
        if (!g2.canWriteTypeId()) {
            g2.writeEndArray();
        }
    }

    @Override
    public void writeTypeSuffixForScalar(Object value2, JsonGenerator g2) throws IOException {
        if (!g2.canWriteTypeId()) {
            g2.writeEndArray();
        }
    }

    @Override
    public void writeCustomTypePrefixForObject(Object value2, JsonGenerator g2, String typeId) throws IOException {
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
        } else {
            g2.writeStartArray();
            g2.writeString(typeId);
        }
        g2.writeStartObject();
    }

    @Override
    public void writeCustomTypePrefixForArray(Object value2, JsonGenerator g2, String typeId) throws IOException {
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
        } else {
            g2.writeStartArray();
            g2.writeString(typeId);
        }
        g2.writeStartArray();
    }

    @Override
    public void writeCustomTypePrefixForScalar(Object value2, JsonGenerator g2, String typeId) throws IOException {
        if (g2.canWriteTypeId()) {
            if (typeId != null) {
                g2.writeTypeId(typeId);
            }
        } else {
            g2.writeStartArray();
            g2.writeString(typeId);
        }
    }

    @Override
    public void writeCustomTypeSuffixForObject(Object value2, JsonGenerator g2, String typeId) throws IOException {
        if (!g2.canWriteTypeId()) {
            this.writeTypeSuffixForObject(value2, g2);
        }
    }

    @Override
    public void writeCustomTypeSuffixForArray(Object value2, JsonGenerator g2, String typeId) throws IOException {
        if (!g2.canWriteTypeId()) {
            this.writeTypeSuffixForArray(value2, g2);
        }
    }

    @Override
    public void writeCustomTypeSuffixForScalar(Object value2, JsonGenerator g2, String typeId) throws IOException {
        if (!g2.canWriteTypeId()) {
            this.writeTypeSuffixForScalar(value2, g2);
        }
    }
}

