/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeSerializerBase;
import java.io.IOException;

public class AsExternalTypeSerializer
extends TypeSerializerBase {
    protected final String _typePropertyName;

    public AsExternalTypeSerializer(TypeIdResolver idRes, BeanProperty property, String propName) {
        super(idRes, property);
        this._typePropertyName = propName;
    }

    @Override
    public AsExternalTypeSerializer forProperty(BeanProperty prop) {
        return this._property == prop ? this : new AsExternalTypeSerializer(this._idResolver, prop, this._typePropertyName);
    }

    @Override
    public String getPropertyName() {
        return this._typePropertyName;
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.EXTERNAL_PROPERTY;
    }

    @Override
    public void writeTypePrefixForObject(Object value2, JsonGenerator gen) throws IOException {
        this._writeObjectPrefix(value2, gen);
    }

    @Override
    public void writeTypePrefixForObject(Object value2, JsonGenerator gen, Class<?> type) throws IOException {
        this._writeObjectPrefix(value2, gen);
    }

    @Override
    public void writeTypePrefixForArray(Object value2, JsonGenerator gen) throws IOException {
        this._writeArrayPrefix(value2, gen);
    }

    @Override
    public void writeTypePrefixForArray(Object value2, JsonGenerator gen, Class<?> type) throws IOException {
        this._writeArrayPrefix(value2, gen);
    }

    @Override
    public void writeTypePrefixForScalar(Object value2, JsonGenerator gen) throws IOException {
        this._writeScalarPrefix(value2, gen);
    }

    @Override
    public void writeTypePrefixForScalar(Object value2, JsonGenerator gen, Class<?> type) throws IOException {
        this._writeScalarPrefix(value2, gen);
    }

    @Override
    public void writeTypeSuffixForObject(Object value2, JsonGenerator gen) throws IOException {
        this._writeObjectSuffix(value2, gen, this.idFromValue(value2));
    }

    @Override
    public void writeTypeSuffixForArray(Object value2, JsonGenerator gen) throws IOException {
        this._writeArraySuffix(value2, gen, this.idFromValue(value2));
    }

    @Override
    public void writeTypeSuffixForScalar(Object value2, JsonGenerator gen) throws IOException {
        this._writeScalarSuffix(value2, gen, this.idFromValue(value2));
    }

    @Override
    public void writeCustomTypePrefixForScalar(Object value2, JsonGenerator gen, String typeId) throws IOException {
        this._writeScalarPrefix(value2, gen);
    }

    @Override
    public void writeCustomTypePrefixForObject(Object value2, JsonGenerator gen, String typeId) throws IOException {
        this._writeObjectPrefix(value2, gen);
    }

    @Override
    public void writeCustomTypePrefixForArray(Object value2, JsonGenerator gen, String typeId) throws IOException {
        this._writeArrayPrefix(value2, gen);
    }

    @Override
    public void writeCustomTypeSuffixForScalar(Object value2, JsonGenerator gen, String typeId) throws IOException {
        this._writeScalarSuffix(value2, gen, typeId);
    }

    @Override
    public void writeCustomTypeSuffixForObject(Object value2, JsonGenerator gen, String typeId) throws IOException {
        this._writeObjectSuffix(value2, gen, typeId);
    }

    @Override
    public void writeCustomTypeSuffixForArray(Object value2, JsonGenerator gen, String typeId) throws IOException {
        this._writeArraySuffix(value2, gen, typeId);
    }

    protected final void _writeScalarPrefix(Object value2, JsonGenerator gen) throws IOException {
    }

    protected final void _writeObjectPrefix(Object value2, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
    }

    protected final void _writeArrayPrefix(Object value2, JsonGenerator gen) throws IOException {
        gen.writeStartArray();
    }

    protected final void _writeScalarSuffix(Object value2, JsonGenerator gen, String typeId) throws IOException {
        if (typeId != null) {
            gen.writeStringField(this._typePropertyName, typeId);
        }
    }

    protected final void _writeObjectSuffix(Object value2, JsonGenerator gen, String typeId) throws IOException {
        gen.writeEndObject();
        if (typeId != null) {
            gen.writeStringField(this._typePropertyName, typeId);
        }
    }

    protected final void _writeArraySuffix(Object value2, JsonGenerator gen, String typeId) throws IOException {
        gen.writeEndArray();
        if (typeId != null) {
            gen.writeStringField(this._typePropertyName, typeId);
        }
    }
}

