/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;

public class ClassNameIdResolver
extends TypeIdResolverBase {
    private static final String JAVA_UTIL_PKG = "java.util.";

    public ClassNameIdResolver(JavaType baseType, TypeFactory typeFactory) {
        super(baseType, typeFactory);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CLASS;
    }

    public void registerSubtype(Class<?> type, String name) {
    }

    @Override
    public String idFromValue(Object value2) {
        return this._idFrom(value2, value2.getClass(), this._typeFactory);
    }

    @Override
    public String idFromValueAndType(Object value2, Class<?> type) {
        return this._idFrom(value2, type, this._typeFactory);
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id2) throws IOException {
        return this._typeFromId(id2, context);
    }

    protected JavaType _typeFromId(String id2, DatabindContext ctxt) throws IOException {
        Class<?> cls;
        TypeFactory tf = ctxt.getTypeFactory();
        if (id2.indexOf(60) > 0) {
            JavaType t = tf.constructFromCanonical(id2);
            if (!t.isTypeOrSubTypeOf(this._baseType.getRawClass())) {
                throw new IllegalArgumentException(String.format("Class %s not subtype of %s", t.getRawClass().getName(), this._baseType));
            }
            return t;
        }
        try {
            cls = tf.findClass(id2);
        }
        catch (ClassNotFoundException e) {
            if (ctxt instanceof DeserializationContext) {
                DeserializationContext dctxt = (DeserializationContext)ctxt;
                return dctxt.handleUnknownTypeId(this._baseType, id2, this, "no such class found");
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid type id '" + id2 + "' (for id type 'Id.class'): " + e.getMessage(), e);
        }
        return tf.constructSpecializedType(this._baseType, cls);
    }

    protected String _idFrom(Object value2, Class<?> cls, TypeFactory typeFactory) {
        Class<?> staticType;
        Class<?> outer;
        String str;
        if (Enum.class.isAssignableFrom(cls) && !cls.isEnum()) {
            cls = cls.getSuperclass();
        }
        if ((str = cls.getName()).startsWith(JAVA_UTIL_PKG)) {
            if (value2 instanceof EnumSet) {
                Class<? extends Enum<?>> enumClass = ClassUtil.findEnumType((EnumSet)value2);
                str = typeFactory.constructCollectionType(EnumSet.class, enumClass).toCanonical();
            } else if (value2 instanceof EnumMap) {
                Class<? extends Enum<?>> enumClass = ClassUtil.findEnumType((EnumMap)value2);
                Class<Object> valueClass = Object.class;
                str = typeFactory.constructMapType(EnumMap.class, enumClass, valueClass).toCanonical();
            } else {
                String suffix = str.substring(JAVA_UTIL_PKG.length());
                if (ClassNameIdResolver.isJavaUtilCollectionClass(suffix, "List")) {
                    str = ArrayList.class.getName();
                } else if (ClassNameIdResolver.isJavaUtilCollectionClass(suffix, "Map")) {
                    str = HashMap.class.getName();
                } else if (ClassNameIdResolver.isJavaUtilCollectionClass(suffix, "Set")) {
                    str = HashSet.class.getName();
                }
            }
        } else if (str.indexOf(36) >= 0 && (outer = ClassUtil.getOuterClass(cls)) != null && ClassUtil.getOuterClass(staticType = this._baseType.getRawClass()) == null) {
            cls = this._baseType.getRawClass();
            str = cls.getName();
        }
        return str;
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "class name used as type id";
    }

    private static boolean isJavaUtilCollectionClass(String clz, String type) {
        if (clz.startsWith("Collections$")) {
            return clz.indexOf(type) > 0 && !clz.contains("Unmodifiable");
        }
        if (clz.startsWith("Arrays$")) {
            return clz.indexOf(type) > 0;
        }
        return false;
    }
}

