/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

@JacksonStdImpl
public class NumberSerializer
extends StdScalarSerializer<Number> {
    public static final NumberSerializer instance = new NumberSerializer((Class<? extends Number>)Number.class);
    protected final boolean _isInt;

    public NumberSerializer(Class<? extends Number> rawType) {
        super(rawType, false);
        this._isInt = rawType == BigInteger.class;
    }

    @Override
    public void serialize(Number value2, JsonGenerator g2, SerializerProvider provider) throws IOException {
        if (value2 instanceof BigDecimal) {
            g2.writeNumber((BigDecimal)value2);
        } else if (value2 instanceof BigInteger) {
            g2.writeNumber((BigInteger)value2);
        } else if (value2 instanceof Long) {
            g2.writeNumber(value2.longValue());
        } else if (value2 instanceof Double) {
            g2.writeNumber(value2.doubleValue());
        } else if (value2 instanceof Float) {
            g2.writeNumber(value2.floatValue());
        } else if (value2 instanceof Integer || value2 instanceof Byte || value2 instanceof Short) {
            g2.writeNumber(value2.intValue());
        } else {
            g2.writeNumber(value2.toString());
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(this._isInt ? "integer" : "number", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (this._isInt) {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.BIG_INTEGER);
        } else {
            Class h = this.handledType();
            if (h == BigDecimal.class) {
                this.visitFloatFormat(visitor, typeHint, JsonParser.NumberType.BIG_DECIMAL);
            } else {
                visitor.expectNumberFormat(typeHint);
            }
        }
    }
}

