/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jdk8;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jdk8.DoubleStreamSerializer;
import com.fasterxml.jackson.datatype.jdk8.IntStreamSerializer;
import com.fasterxml.jackson.datatype.jdk8.LongStreamSerializer;
import com.fasterxml.jackson.datatype.jdk8.OptionalDoubleSerializer;
import com.fasterxml.jackson.datatype.jdk8.OptionalIntSerializer;
import com.fasterxml.jackson.datatype.jdk8.OptionalLongSerializer;
import com.fasterxml.jackson.datatype.jdk8.OptionalSerializer;
import com.fasterxml.jackson.datatype.jdk8.StreamSerializer;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class Jdk8Serializers
extends Serializers.Base {
    @Override
    public JsonSerializer<?> findReferenceSerializer(SerializationConfig config, ReferenceType refType, BeanDescription beanDesc, TypeSerializer contentTypeSerializer, JsonSerializer<Object> contentValueSerializer) {
        Class<?> raw2 = refType.getRawClass();
        if (Optional.class.isAssignableFrom(raw2)) {
            return new OptionalSerializer(refType, contentTypeSerializer, contentValueSerializer);
        }
        if (OptionalInt.class.isAssignableFrom(raw2)) {
            return OptionalIntSerializer.INSTANCE;
        }
        if (OptionalLong.class.isAssignableFrom(raw2)) {
            return OptionalLongSerializer.INSTANCE;
        }
        if (OptionalDouble.class.isAssignableFrom(raw2)) {
            return OptionalDoubleSerializer.INSTANCE;
        }
        return null;
    }

    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class<?> raw2 = type.getRawClass();
        if (LongStream.class.isAssignableFrom(raw2)) {
            return LongStreamSerializer.INSTANCE;
        }
        if (IntStream.class.isAssignableFrom(raw2)) {
            return IntStreamSerializer.INSTANCE;
        }
        if (DoubleStream.class.isAssignableFrom(raw2)) {
            return DoubleStreamSerializer.INSTANCE;
        }
        if (Stream.class.isAssignableFrom(raw2)) {
            JavaType[] params2 = config.getTypeFactory().findTypeParameters(type, Stream.class);
            JavaType vt = params2 == null || params2.length != 1 ? TypeFactory.unknownType() : params2[0];
            return new StreamSerializer(config.getTypeFactory().constructParametrizedType(Stream.class, Stream.class, vt), vt);
        }
        return null;
    }
}

