/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.Buffer32;
import com.googlecode.javaewah32.BufferedRunningLengthWord32;
import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.EWAHIterator32;
import com.googlecode.javaewah32.IteratingRLW32;

public final class IteratingBufferedRunningLengthWord32
implements IteratingRLW32,
Cloneable {
    private BufferedRunningLengthWord32 brlw;
    private final Buffer32 buffer;
    private int literalWordStartPosition;
    private EWAHIterator32 iterator;

    public IteratingBufferedRunningLengthWord32(EWAHIterator32 iterator2) {
        this.iterator = iterator2;
        this.brlw = new BufferedRunningLengthWord32(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords() + this.brlw.literalWordOffset;
        this.buffer = this.iterator.buffer();
    }

    public IteratingBufferedRunningLengthWord32(EWAHCompressedBitmap32 bitmap) {
        this(EWAHIterator32.getEWAHIterator(bitmap));
    }

    @Override
    public void discardFirstWords(int x) {
        while (x > 0) {
            if (this.brlw.RunningLength > x) {
                this.brlw.RunningLength -= x;
                return;
            }
            this.brlw.RunningLength = 0;
            int toDiscard = (x -= this.brlw.RunningLength) > this.brlw.NumberOfLiteralWords ? this.brlw.NumberOfLiteralWords : x;
            this.literalWordStartPosition += toDiscard;
            this.brlw.NumberOfLiteralWords -= toDiscard;
            if ((x -= toDiscard) <= 0 && this.brlw.size() != 0) continue;
            if (!this.iterator.hasNext()) break;
            this.brlw.reset(this.iterator.next());
            this.literalWordStartPosition = this.iterator.literalWords();
        }
    }

    @Override
    public void discardRunningWords() {
        this.brlw.RunningLength = 0;
        if (this.brlw.getNumberOfLiteralWords() == 0) {
            this.next();
        }
    }

    public int discharge(BitmapStorage32 container, int max2) {
        int index;
        int pd;
        for (index = 0; index < max2 && this.size() > 0; index += pd) {
            int pl = this.getRunningLength();
            if (index + pl > max2) {
                pl = max2 - index;
            }
            container.addStreamOfEmptyWords(this.getRunningBit(), pl);
            pd = this.getNumberOfLiteralWords();
            if (pd + (index += pl) > max2) {
                pd = max2 - index;
            }
            this.writeLiteralWords(pd, container);
            this.discardFirstWords(pl + pd);
        }
        return index;
    }

    public int dischargeNegated(BitmapStorage32 container, int max2) {
        int index;
        int pd;
        for (index = 0; index < max2 && this.size() > 0; index += pd) {
            int pl = this.getRunningLength();
            if (index + pl > max2) {
                pl = max2 - index;
            }
            container.addStreamOfEmptyWords(!this.getRunningBit(), pl);
            pd = this.getNumberOfLiteralWords();
            if (pd + (index += pl) > max2) {
                pd = max2 - index;
            }
            this.writeNegatedLiteralWords(pd, container);
            this.discardFirstWords(pl + pd);
        }
        return index;
    }

    @Override
    public boolean next() {
        if (!this.iterator.hasNext()) {
            this.brlw.NumberOfLiteralWords = 0;
            this.brlw.RunningLength = 0;
            return false;
        }
        this.brlw.reset(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords();
        return true;
    }

    public void dischargeAsEmpty(BitmapStorage32 container) {
        while (this.size() > 0) {
            container.addStreamOfEmptyWords(false, this.size());
            this.discardFirstWords(this.size());
        }
    }

    public void discharge(BitmapStorage32 container) {
        this.brlw.literalWordOffset = this.literalWordStartPosition - this.iterator.literalWords();
        IteratingBufferedRunningLengthWord32.discharge(this.brlw, this.iterator, container);
    }

    @Override
    public int getLiteralWordAt(int index) {
        return this.buffer.getWord(this.literalWordStartPosition + index);
    }

    @Override
    public int getNumberOfLiteralWords() {
        return this.brlw.NumberOfLiteralWords;
    }

    @Override
    public boolean getRunningBit() {
        return this.brlw.RunningBit;
    }

    @Override
    public int getRunningLength() {
        return this.brlw.RunningLength;
    }

    @Override
    public int size() {
        return this.brlw.size();
    }

    public void writeLiteralWords(int numWords, BitmapStorage32 container) {
        container.addStreamOfLiteralWords(this.buffer, this.literalWordStartPosition, numWords);
    }

    public void writeNegatedLiteralWords(int numWords, BitmapStorage32 container) {
        container.addStreamOfNegatedLiteralWords(this.buffer, this.literalWordStartPosition, numWords);
    }

    protected static void discharge(BufferedRunningLengthWord32 initialWord, EWAHIterator32 iterator2, BitmapStorage32 container) {
        BufferedRunningLengthWord32 runningLengthWord = initialWord;
        while (true) {
            int runningLength = runningLengthWord.getRunningLength();
            container.addStreamOfEmptyWords(runningLengthWord.getRunningBit(), runningLength);
            container.addStreamOfLiteralWords(iterator2.buffer(), iterator2.literalWords() + runningLengthWord.literalWordOffset, runningLengthWord.getNumberOfLiteralWords());
            if (!iterator2.hasNext()) break;
            runningLengthWord = new BufferedRunningLengthWord32(iterator2.next());
        }
    }

    @Override
    public IteratingBufferedRunningLengthWord32 clone() throws CloneNotSupportedException {
        IteratingBufferedRunningLengthWord32 answer = (IteratingBufferedRunningLengthWord32)super.clone();
        answer.brlw = this.brlw.clone();
        answer.iterator = this.iterator.clone();
        return answer;
    }
}

