/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@ThreadSafe
public class BasicHttpContext
implements HttpContext {
    private final HttpContext parentContext;
    private final Map<String, Object> map = new ConcurrentHashMap<String, Object>();

    public BasicHttpContext() {
        this(null);
    }

    public BasicHttpContext(HttpContext parentContext) {
        this.parentContext = parentContext;
    }

    public Object getAttribute(String id2) {
        Args.notNull(id2, "Id");
        Object obj2 = this.map.get(id2);
        if (obj2 == null && this.parentContext != null) {
            obj2 = this.parentContext.getAttribute(id2);
        }
        return obj2;
    }

    public void setAttribute(String id2, Object obj2) {
        Args.notNull(id2, "Id");
        if (obj2 != null) {
            this.map.put(id2, obj2);
        } else {
            this.map.remove(id2);
        }
    }

    public Object removeAttribute(String id2) {
        Args.notNull(id2, "Id");
        return this.map.remove(id2);
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }
}

