/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.annotation.GuardedBy;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.util.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class UriPatternMatcher<T> {
    @GuardedBy(value="this")
    private final Map<String, T> map = new HashMap<String, T>();

    public synchronized void register(String pattern2, T obj2) {
        Args.notNull(pattern2, "URI request pattern");
        this.map.put(pattern2, obj2);
    }

    public synchronized void unregister(String pattern2) {
        if (pattern2 == null) {
            return;
        }
        this.map.remove(pattern2);
    }

    @Deprecated
    public synchronized void setHandlers(Map<String, T> map23) {
        Args.notNull(map23, "Map of handlers");
        this.map.clear();
        this.map.putAll(map23);
    }

    @Deprecated
    public synchronized void setObjects(Map<String, T> map23) {
        Args.notNull(map23, "Map of handlers");
        this.map.clear();
        this.map.putAll(map23);
    }

    @Deprecated
    public synchronized Map<String, T> getObjects() {
        return this.map;
    }

    public synchronized T lookup(String path) {
        Args.notNull(path, "Request path");
        T obj2 = this.map.get(path);
        if (obj2 == null) {
            String bestMatch = null;
            for (String pattern2 : this.map.keySet()) {
                if (!this.matchUriRequestPattern(pattern2, path) || bestMatch != null && bestMatch.length() >= pattern2.length() && (bestMatch.length() != pattern2.length() || !pattern2.endsWith("*"))) continue;
                obj2 = this.map.get(pattern2);
                bestMatch = pattern2;
            }
        }
        return obj2;
    }

    protected boolean matchUriRequestPattern(String pattern2, String path) {
        if (pattern2.equals("*")) {
            return true;
        }
        return pattern2.endsWith("*") && path.startsWith(pattern2.substring(0, pattern2.length() - 1)) || pattern2.startsWith("*") && path.endsWith(pattern2.substring(1, pattern2.length()));
    }

    public String toString() {
        return this.map.toString();
    }
}

