/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.SubmoduleConfig;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.Transport;

public class FetchCommand
extends TransportCommand<FetchCommand, FetchResult> {
    private String remote = "origin";
    private List<RefSpec> refSpecs;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private boolean checkFetchedObjects;
    private Boolean removeDeletedRefs;
    private boolean dryRun;
    private boolean thin = true;
    private TagOpt tagOption;
    private SubmoduleConfig.FetchRecurseSubmodulesMode submoduleRecurseMode = null;
    private Callback callback;

    protected FetchCommand(Repository repo) {
        super(repo);
        this.refSpecs = new ArrayList<RefSpec>(3);
    }

    private SubmoduleConfig.FetchRecurseSubmodulesMode getRecurseMode(String path) {
        if (this.submoduleRecurseMode != null) {
            return this.submoduleRecurseMode;
        }
        SubmoduleConfig.FetchRecurseSubmodulesMode mode = (SubmoduleConfig.FetchRecurseSubmodulesMode)this.repo.getConfig().getEnum(SubmoduleConfig.FetchRecurseSubmodulesMode.values(), "submodule", path, "fetchRecurseSubmodules", null);
        if (mode != null) {
            return mode;
        }
        mode = (SubmoduleConfig.FetchRecurseSubmodulesMode)this.repo.getConfig().getEnum(SubmoduleConfig.FetchRecurseSubmodulesMode.values(), "fetch", null, "recurseSubmodules", null);
        if (mode != null) {
            return mode;
        }
        return SubmoduleConfig.FetchRecurseSubmodulesMode.ON_DEMAND;
    }

    private void fetchSubmodules(FetchResult results) throws TransportException, GitAPIException, InvalidConfigurationException {
        try (SubmoduleWalk walk2 = new SubmoduleWalk(this.repo);
             RevWalk revWalk = new RevWalk(this.repo);){
            ObjectId fetchHead = this.repo.resolve("FETCH_HEAD");
            if (fetchHead == null) {
                return;
            }
            walk2.setTree(revWalk.parseTree(fetchHead));
            while (walk2.next()) {
                SubmoduleConfig.FetchRecurseSubmodulesMode recurseMode;
                Repository submoduleRepo = walk2.getRepository();
                if (submoduleRepo == null || walk2.getModulesPath() == null || walk2.getConfigUrl() == null || ((recurseMode = this.getRecurseMode(walk2.getPath())) != SubmoduleConfig.FetchRecurseSubmodulesMode.ON_DEMAND || submoduleRepo.hasObject(walk2.getObjectId())) && recurseMode != SubmoduleConfig.FetchRecurseSubmodulesMode.YES) continue;
                FetchCommand f = new FetchCommand(submoduleRepo).setProgressMonitor(this.monitor).setTagOpt(this.tagOption).setCheckFetchedObjects(this.checkFetchedObjects).setRemoveDeletedRefs(this.isRemoveDeletedRefs()).setThin(this.thin).setRefSpecs(this.refSpecs).setDryRun(this.dryRun).setRecurseSubmodules(recurseMode);
                if (this.callback != null) {
                    this.callback.fetchingSubmodule(walk2.getPath());
                }
                results.addSubmodule(walk2.getPath(), f.call());
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FetchResult call() throws GitAPIException, InvalidRemoteException, TransportException {
        this.checkCallable();
        try (Transport transport = Transport.open(this.repo, this.remote);){
            transport.setCheckFetchedObjects(this.checkFetchedObjects);
            transport.setRemoveDeletedRefs(this.isRemoveDeletedRefs());
            transport.setDryRun(this.dryRun);
            if (this.tagOption != null) {
                transport.setTagOpt(this.tagOption);
            }
            transport.setFetchThin(this.thin);
            this.configure(transport);
            FetchResult result2 = transport.fetch(this.monitor, this.refSpecs);
            if (!this.repo.isBare()) {
                this.fetchSubmodules(result2);
            }
            FetchResult fetchResult = result2;
            return fetchResult;
        }
        catch (NoRemoteRepositoryException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), e);
        }
        catch (org.eclipse.jgit.errors.TransportException e) {
            throw new TransportException(e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote));
        }
        catch (NotSupportedException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfFetchCommand, e);
        }
    }

    public FetchCommand setRecurseSubmodules(SubmoduleConfig.FetchRecurseSubmodulesMode recurse) {
        this.checkCallable();
        this.submoduleRecurseMode = recurse;
        return this;
    }

    public FetchCommand setRemote(String remote2) {
        this.checkCallable();
        this.remote = remote2;
        return this;
    }

    public String getRemote() {
        return this.remote;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isCheckFetchedObjects() {
        return this.checkFetchedObjects;
    }

    public FetchCommand setCheckFetchedObjects(boolean checkFetchedObjects) {
        this.checkCallable();
        this.checkFetchedObjects = checkFetchedObjects;
        return this;
    }

    public boolean isRemoveDeletedRefs() {
        if (this.removeDeletedRefs != null) {
            return this.removeDeletedRefs;
        }
        boolean result2 = false;
        StoredConfig config = this.repo.getConfig();
        result2 = config.getBoolean("fetch", null, "prune", result2);
        result2 = config.getBoolean("remote", this.remote, "prune", result2);
        return result2;
    }

    public FetchCommand setRemoveDeletedRefs(boolean removeDeletedRefs) {
        this.checkCallable();
        this.removeDeletedRefs = removeDeletedRefs;
        return this;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public FetchCommand setProgressMonitor(ProgressMonitor monitor) {
        this.checkCallable();
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public List<RefSpec> getRefSpecs() {
        return this.refSpecs;
    }

    public FetchCommand setRefSpecs(RefSpec ... specs2) {
        this.checkCallable();
        this.refSpecs.clear();
        for (RefSpec spec : specs2) {
            this.refSpecs.add(spec);
        }
        return this;
    }

    public FetchCommand setRefSpecs(List<RefSpec> specs2) {
        this.checkCallable();
        this.refSpecs.clear();
        this.refSpecs.addAll(specs2);
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public FetchCommand setDryRun(boolean dryRun) {
        this.checkCallable();
        this.dryRun = dryRun;
        return this;
    }

    public boolean isThin() {
        return this.thin;
    }

    public FetchCommand setThin(boolean thin) {
        this.checkCallable();
        this.thin = thin;
        return this;
    }

    public FetchCommand setTagOpt(TagOpt tagOpt) {
        this.checkCallable();
        this.tagOption = tagOpt;
        return this;
    }

    public FetchCommand setCallback(Callback callback) {
        this.callback = callback;
        return this;
    }

    public static interface Callback {
        public void fetchingSubmodule(String var1);
    }
}

