/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class ListNotesCommand
extends GitCommand<List<Note>> {
    private String notesRef = "refs/notes/commits";

    protected ListNotesCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<Note> call() throws GitAPIException {
        this.checkCallable();
        ArrayList<Note> notes = new ArrayList<Note>();
        NoteMap map23 = NoteMap.newEmptyMap();
        try (RevWalk walk2 = new RevWalk(this.repo);){
            Ref ref = this.repo.findRef(this.notesRef);
            if (ref != null) {
                RevCommit notesCommit = walk2.parseCommit(ref.getObjectId());
                map23 = NoteMap.read(walk2.getObjectReader(), notesCommit);
            }
            Iterator<Note> i = map23.iterator();
            while (i.hasNext()) {
                notes.add(i.next());
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        return notes;
    }

    public ListNotesCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

