/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.blame;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

final class ReverseWalk
extends RevWalk {
    ReverseWalk(Repository repo) {
        super(repo);
    }

    @Override
    public ReverseCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ReverseCommit c = (ReverseCommit)super.next();
        if (c == null) {
            return null;
        }
        for (int pIdx = 0; pIdx < c.getParentCount(); ++pIdx) {
            ((ReverseCommit)c.getParent(pIdx)).addChild(c);
        }
        return c;
    }

    @Override
    protected RevCommit createCommit(AnyObjectId id2) {
        return new ReverseCommit(id2);
    }

    static final class ReverseCommit
    extends RevCommit {
        private static final ReverseCommit[] NO_CHILDREN = new ReverseCommit[0];
        private ReverseCommit[] children = NO_CHILDREN;

        ReverseCommit(AnyObjectId id2) {
            super(id2);
        }

        void addChild(ReverseCommit c) {
            int cnt = this.children.length;
            if (cnt == 0) {
                this.children = new ReverseCommit[]{c};
            } else if (cnt == 1) {
                this.children = new ReverseCommit[]{c, this.children[0]};
            } else {
                ReverseCommit[] n = new ReverseCommit[1 + cnt];
                n[0] = c;
                System.arraycopy(this.children, 0, n, 1, cnt);
                this.children = n;
            }
        }

        int getChildCount() {
            return this.children.length;
        }

        ReverseCommit getChild(int nth) {
            return this.children[nth];
        }
    }
}

