/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore;

import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.internal.IMatcher;
import org.eclipse.jgit.ignore.internal.PathMatcher;
import org.eclipse.jgit.ignore.internal.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastIgnoreRule {
    private static final Logger LOG = LoggerFactory.getLogger(FastIgnoreRule.class);
    public static final char PATH_SEPARATOR = '/';
    private final IMatcher matcher;
    private final boolean inverse;
    private final boolean dirOnly;

    public FastIgnoreRule(String pattern2) {
        IMatcher m;
        char next2;
        if (pattern2 == null) {
            throw new IllegalArgumentException("Pattern must not be null!");
        }
        if (pattern2.length() == 0) {
            this.dirOnly = false;
            this.inverse = false;
            this.matcher = IMatcher.NO_MATCH;
            return;
        }
        boolean bl = this.inverse = pattern2.charAt(0) == '!';
        if (this.inverse && (pattern2 = pattern2.substring(1)).length() == 0) {
            this.dirOnly = false;
            this.matcher = IMatcher.NO_MATCH;
            return;
        }
        if (pattern2.charAt(0) == '#') {
            this.matcher = IMatcher.NO_MATCH;
            this.dirOnly = false;
            return;
        }
        if (pattern2.charAt(0) == '\\' && pattern2.length() > 1 && ((next2 = pattern2.charAt(1)) == '!' || next2 == '#')) {
            pattern2 = pattern2.substring(1);
        }
        this.dirOnly = Strings.isDirectoryPattern(pattern2);
        if (this.dirOnly) {
            pattern2 = Strings.stripTrailingWhitespace(pattern2);
            if ((pattern2 = Strings.stripTrailing(pattern2, '/')).length() == 0) {
                this.matcher = IMatcher.NO_MATCH;
                return;
            }
        }
        try {
            m = PathMatcher.createPathMatcher(pattern2, Character.valueOf('/'), this.dirOnly);
        }
        catch (InvalidPatternException e) {
            m = IMatcher.NO_MATCH;
            LOG.error(e.getMessage(), e);
        }
        this.matcher = m;
    }

    public boolean isMatch(String path, boolean directory) {
        if (path == null) {
            return false;
        }
        if (path.length() == 0) {
            return false;
        }
        boolean match = this.matcher.matches(path, directory);
        return match;
    }

    public boolean getNameOnly() {
        return !(this.matcher instanceof PathMatcher);
    }

    public boolean dirOnly() {
        return this.dirOnly;
    }

    public boolean getNegation() {
        return this.inverse;
    }

    public boolean getResult() {
        return !this.inverse;
    }

    public boolean isEmpty() {
        return this.matcher == IMatcher.NO_MATCH;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.inverse) {
            sb.append('!');
        }
        sb.append(this.matcher);
        if (this.dirOnly) {
            sb.append('/');
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.inverse ? 1231 : 1237);
        result2 = 31 * result2 + (this.dirOnly ? 1231 : 1237);
        result2 = 31 * result2 + (this.matcher == null ? 0 : this.matcher.hashCode());
        return result2;
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (!(obj2 instanceof FastIgnoreRule)) {
            return false;
        }
        FastIgnoreRule other = (FastIgnoreRule)obj2;
        if (this.inverse != other.inverse) {
            return false;
        }
        if (this.dirOnly != other.dirOnly) {
            return false;
        }
        return this.matcher.equals(other.matcher);
    }
}

