/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore.internal;

import org.eclipse.jgit.ignore.internal.NameMatcher;

public class LeadingAsteriskMatcher
extends NameMatcher {
    LeadingAsteriskMatcher(String pattern2, Character pathSeparator, boolean dirOnly) {
        super(pattern2, pathSeparator, dirOnly, true);
        if (this.subPattern.charAt(0) != '*') {
            throw new IllegalArgumentException("Pattern must have leading asterisk: " + pattern2);
        }
    }

    @Override
    public boolean matches(String segment, int startIncl, int endExcl, boolean assumeDirectory) {
        String s2 = this.subPattern;
        int subLength = s2.length() - 1;
        if (subLength == 0) {
            return true;
        }
        if (subLength > endExcl - startIncl) {
            return false;
        }
        int i = subLength;
        int j = endExcl - 1;
        while (i > 0) {
            char c2;
            char c1 = s2.charAt(i);
            if (c1 != (c2 = segment.charAt(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }
}

