/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.internal.AbstractMatcher;
import org.eclipse.jgit.ignore.internal.IMatcher;
import org.eclipse.jgit.ignore.internal.LeadingAsteriskMatcher;
import org.eclipse.jgit.ignore.internal.NameMatcher;
import org.eclipse.jgit.ignore.internal.Strings;
import org.eclipse.jgit.ignore.internal.TrailingAsteriskMatcher;
import org.eclipse.jgit.ignore.internal.WildCardMatcher;
import org.eclipse.jgit.ignore.internal.WildMatcher;

public class PathMatcher
extends AbstractMatcher {
    private static final WildMatcher WILD = WildMatcher.INSTANCE;
    private final List<IMatcher> matchers;
    private final char slash;
    private boolean beginning;

    PathMatcher(String pattern2, Character pathSeparator, boolean dirOnly) throws InvalidPatternException {
        super(pattern2, dirOnly);
        this.slash = Strings.getPathSeparator(pathSeparator);
        this.beginning = pattern2.indexOf(this.slash) == 0;
        this.matchers = this.isSimplePathWithSegments(pattern2) ? null : PathMatcher.createMatchers(Strings.split(pattern2, this.slash), pathSeparator, dirOnly);
    }

    private boolean isSimplePathWithSegments(String path) {
        return !Strings.isWildCard(path) && path.indexOf(92) < 0 && Strings.count(path, this.slash, true) > 0;
    }

    private static List<IMatcher> createMatchers(List<String> segments2, Character pathSeparator, boolean dirOnly) throws InvalidPatternException {
        ArrayList<IMatcher> matchers = new ArrayList<IMatcher>(segments2.size());
        for (int i = 0; i < segments2.size(); ++i) {
            String segment = segments2.get(i);
            IMatcher matcher = PathMatcher.createNameMatcher0(segment, pathSeparator, dirOnly);
            if (matcher == WILD && i > 0 && matchers.get(matchers.size() - 1) == WILD) continue;
            matchers.add(matcher);
        }
        return matchers;
    }

    public static IMatcher createPathMatcher(String pattern2, Character pathSeparator, boolean dirOnly) throws InvalidPatternException {
        char slash;
        int slashIdx = (pattern2 = PathMatcher.trim(pattern2)).indexOf(slash = Strings.getPathSeparator(pathSeparator), 1);
        if (slashIdx > 0 && slashIdx < pattern2.length() - 1) {
            return new PathMatcher(pattern2, pathSeparator, dirOnly);
        }
        return PathMatcher.createNameMatcher0(pattern2, pathSeparator, dirOnly);
    }

    private static String trim(String pattern2) {
        while (pattern2.length() > 0 && pattern2.charAt(pattern2.length() - 1) == ' ') {
            if (pattern2.length() > 1 && pattern2.charAt(pattern2.length() - 2) == '\\') {
                pattern2 = pattern2.substring(0, pattern2.length() - 2) + " ";
                return pattern2;
            }
            pattern2 = pattern2.substring(0, pattern2.length() - 1);
        }
        return pattern2;
    }

    private static IMatcher createNameMatcher0(String segment, Character pathSeparator, boolean dirOnly) throws InvalidPatternException {
        if ("**".equals(segment) || "/**".equals(segment)) {
            return WILD;
        }
        Strings.PatternState state = Strings.checkWildCards(segment);
        switch (state) {
            case LEADING_ASTERISK_ONLY: {
                return new LeadingAsteriskMatcher(segment, pathSeparator, dirOnly);
            }
            case TRAILING_ASTERISK_ONLY: {
                return new TrailingAsteriskMatcher(segment, pathSeparator, dirOnly);
            }
            case COMPLEX: {
                return new WildCardMatcher(segment, pathSeparator, dirOnly);
            }
        }
        return new NameMatcher(segment, pathSeparator, dirOnly, true);
    }

    @Override
    public boolean matches(String path, boolean assumeDirectory) {
        if (this.matchers == null) {
            return this.simpleMatch(path, assumeDirectory);
        }
        return this.iterate(path, 0, path.length(), assumeDirectory);
    }

    private boolean simpleMatch(String path, boolean assumeDirectory) {
        boolean hasSlash;
        boolean bl = hasSlash = path.indexOf(this.slash) == 0;
        if (this.beginning && !hasSlash) {
            path = this.slash + path;
        }
        if (!this.beginning && hasSlash) {
            path = path.substring(1);
        }
        if (path.equals(this.pattern)) {
            return !this.dirOnly || assumeDirectory;
        }
        return path.startsWith(this.pattern + '/');
    }

    @Override
    public boolean matches(String segment, int startIncl, int endExcl, boolean assumeDirectory) {
        throw new UnsupportedOperationException("Path matcher works only on entire paths");
    }

    boolean iterate(String path, int startIncl, int endExcl, boolean assumeDirectory) {
        int matcher = 0;
        int right2 = startIncl;
        boolean match = false;
        int lastWildmatch = -1;
        while (true) {
            int left2 = ++right2;
            if ((right2 = path.indexOf(this.slash, right2)) == -1) {
                if (left2 < endExcl) {
                    match = this.matches(matcher, path, left2, endExcl, assumeDirectory);
                }
                if (match) {
                    if (matcher == this.matchers.size() - 2 && this.matchers.get(matcher + 1) == WILD) {
                        return true;
                    }
                    if (matcher < this.matchers.size() - 1 && this.matchers.get(matcher) == WILD) {
                        match = this.matches(++matcher, path, left2, endExcl, assumeDirectory);
                    } else if (this.dirOnly && !assumeDirectory) {
                        return false;
                    }
                }
                return match && matcher + 1 == this.matchers.size();
            }
            if (right2 - left2 <= 0) continue;
            match = this.matches(matcher, path, left2, right2, assumeDirectory);
            if (match) {
                if (this.matchers.get(matcher) == WILD) {
                    lastWildmatch = matcher;
                    right2 = left2 - 1;
                }
                if (++matcher == this.matchers.size()) {
                    return true;
                }
            } else if (lastWildmatch != -1) {
                matcher = lastWildmatch + 1;
            } else {
                return false;
            }
            ++right2;
        }
    }

    boolean matches(int matcherIdx, String path, int startIncl, int endExcl, boolean assumeDirectory) {
        IMatcher matcher = this.matchers.get(matcherIdx);
        return matcher.matches(path, startIncl, endExcl, assumeDirectory);
    }
}

