/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.internal.JGitText;

public class Strings {
    static final List<String> POSIX_CHAR_CLASSES = Arrays.asList("alnum", "alpha", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "xdigit", "word");
    private static final String DL = "\\p{javaDigit}\\p{javaLetter}";
    static final List<String> JAVA_CHAR_CLASSES = Arrays.asList("\\p{Alnum}", "\\p{javaLetter}", "\\p{Blank}", "\\p{Cntrl}", "\\p{javaDigit}", "[\\p{Graph}\\p{javaDigit}\\p{javaLetter}]", "\\p{Ll}", "[\\p{Print}\\p{javaDigit}\\p{javaLetter}]", "\\p{Punct}", "\\p{Space}", "\\p{Lu}", "\\p{XDigit}", "[\\p{javaDigit}\\p{javaLetter}_]");
    static final Pattern UNSUPPORTED = Pattern.compile("\\[\\[[.=]\\w+[.=]\\]\\]");

    static char getPathSeparator(Character pathSeparator) {
        return pathSeparator == null ? (char)'/' : (char)pathSeparator.charValue();
    }

    public static String stripTrailing(String pattern2, char c) {
        for (int i = pattern2.length() - 1; i >= 0; --i) {
            char charAt = pattern2.charAt(i);
            if (charAt == c) continue;
            if (i == pattern2.length() - 1) {
                return pattern2;
            }
            return pattern2.substring(0, i + 1);
        }
        return "";
    }

    public static String stripTrailingWhitespace(String pattern2) {
        for (int i = pattern2.length() - 1; i >= 0; --i) {
            char charAt = pattern2.charAt(i);
            if (Character.isWhitespace(charAt)) continue;
            if (i == pattern2.length() - 1) {
                return pattern2;
            }
            return pattern2.substring(0, i + 1);
        }
        return "";
    }

    public static boolean isDirectoryPattern(String pattern2) {
        for (int i = pattern2.length() - 1; i >= 0; --i) {
            char charAt = pattern2.charAt(i);
            if (Character.isWhitespace(charAt)) continue;
            return charAt == '/';
        }
        return false;
    }

    static int count(String s2, char c, boolean ignoreFirstLast) {
        int start = 0;
        int count2 = 0;
        while ((start = s2.indexOf(c, start)) != -1) {
            if (!ignoreFirstLast || start != 0 && start != s2.length()) {
                ++count2;
            }
            ++start;
        }
        return count2;
    }

    public static List<String> split(String pattern2, char slash) {
        int count2 = Strings.count(pattern2, slash, true);
        if (count2 < 1) {
            throw new IllegalStateException("Pattern must have at least two segments: " + pattern2);
        }
        ArrayList<String> segments2 = new ArrayList<String>(count2);
        int right2 = 0;
        while (true) {
            int left2 = ++right2;
            if ((right2 = pattern2.indexOf(slash, right2)) == -1) {
                if (left2 >= pattern2.length()) break;
                segments2.add(pattern2.substring(left2));
                break;
            }
            if (right2 - left2 <= 0) continue;
            if (left2 == 1) {
                segments2.add(pattern2.substring(left2 - 1, right2));
                continue;
            }
            if (right2 == pattern2.length() - 1) {
                segments2.add(pattern2.substring(left2, right2 + 1));
                continue;
            }
            segments2.add(pattern2.substring(left2, right2));
        }
        return segments2;
    }

    static boolean isWildCard(String pattern2) {
        return pattern2.indexOf(42) != -1 || Strings.isComplexWildcard(pattern2);
    }

    private static boolean isComplexWildcard(String pattern2) {
        int idx1 = pattern2.indexOf(91);
        if (idx1 != -1) {
            return true;
        }
        if (pattern2.indexOf(63) != -1) {
            return true;
        }
        int backSlash = pattern2.indexOf(92);
        if (backSlash >= 0) {
            int nextIdx = backSlash + 1;
            if (pattern2.length() == nextIdx) {
                return false;
            }
            char nextChar = pattern2.charAt(nextIdx);
            return Strings.escapedByBackslash(nextChar);
        }
        return false;
    }

    private static boolean escapedByBackslash(char nextChar) {
        return nextChar == '?' || nextChar == '*' || nextChar == '[';
    }

    static PatternState checkWildCards(String pattern2) {
        if (Strings.isComplexWildcard(pattern2)) {
            return PatternState.COMPLEX;
        }
        int startIdx = pattern2.indexOf(42);
        if (startIdx < 0) {
            return PatternState.NONE;
        }
        if (startIdx == pattern2.length() - 1) {
            return PatternState.TRAILING_ASTERISK_ONLY;
        }
        if (pattern2.lastIndexOf(42) == 0) {
            return PatternState.LEADING_ASTERISK_ONLY;
        }
        return PatternState.COMPLEX;
    }

    static Pattern convertGlob(String pattern2) throws InvalidPatternException {
        if (UNSUPPORTED.matcher(pattern2).find()) {
            throw new InvalidPatternException("Collating symbols [[.a.]] or equivalence class expressions [[=a=]] are not supported", pattern2);
        }
        StringBuilder sb = new StringBuilder(pattern2.length());
        int in_brackets = 0;
        boolean seenEscape = false;
        boolean ignoreLastBracket = false;
        boolean in_char_class = false;
        char[] charClass = new char[6];
        for (int i = 0; i < pattern2.length(); ++i) {
            char c = pattern2.charAt(i);
            switch (c) {
                case '*': {
                    if (seenEscape || in_brackets > 0) {
                        sb.append(c);
                        break;
                    }
                    sb.append('.').append(c);
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    if (seenEscape || in_brackets > 0) {
                        sb.append(c);
                        break;
                    }
                    sb.append('\\').append(c);
                    break;
                }
                case '.': {
                    if (seenEscape) {
                        sb.append(c);
                        break;
                    }
                    sb.append('\\').append('.');
                    break;
                }
                case '?': {
                    if (seenEscape || in_brackets > 0) {
                        sb.append(c);
                        break;
                    }
                    sb.append('.');
                    break;
                }
                case ':': {
                    if (in_brackets > 0 && Strings.lookBehind(sb) == '[' && Character.isLetter(Strings.lookAhead(pattern2, i))) {
                        in_char_class = true;
                    }
                    sb.append(':');
                    break;
                }
                case '-': {
                    if (in_brackets > 0) {
                        if (Strings.lookAhead(pattern2, i) == ']') {
                            sb.append('\\').append(c);
                            break;
                        }
                        sb.append(c);
                        break;
                    }
                    sb.append('-');
                    break;
                }
                case '\\': {
                    char lookAhead;
                    if (in_brackets > 0) {
                        lookAhead = Strings.lookAhead(pattern2, i);
                        if (lookAhead == ']' || lookAhead == '[') {
                            ignoreLastBracket = true;
                        }
                    } else {
                        lookAhead = Strings.lookAhead(pattern2, i);
                        if (lookAhead != '\\' && lookAhead != '[' && lookAhead != '?' && lookAhead != '*' && lookAhead != ' ' && Strings.lookBehind(sb) != '\\') break;
                    }
                    sb.append(c);
                    break;
                }
                case '[': {
                    if (in_brackets > 0) {
                        sb.append('\\').append('[');
                        ignoreLastBracket = true;
                        break;
                    }
                    if (!seenEscape) {
                        ++in_brackets;
                        ignoreLastBracket = false;
                    }
                    sb.append('[');
                    break;
                }
                case ']': {
                    if (seenEscape) {
                        sb.append(']');
                        ignoreLastBracket = true;
                        break;
                    }
                    if (in_brackets <= 0) {
                        sb.append('\\').append(']');
                        ignoreLastBracket = true;
                        break;
                    }
                    char lookBehind = Strings.lookBehind(sb);
                    if (lookBehind == '[' && !ignoreLastBracket || lookBehind == '^') {
                        sb.append('\\');
                        sb.append(']');
                        ignoreLastBracket = true;
                        break;
                    }
                    ignoreLastBracket = false;
                    if (!in_char_class) {
                        --in_brackets;
                        sb.append(']');
                        break;
                    }
                    in_char_class = false;
                    String charCl = Strings.checkPosixCharClass(charClass);
                    if (charCl != null) {
                        sb.setLength(sb.length() - 4);
                        sb.append(charCl);
                    }
                    Strings.reset(charClass);
                    break;
                }
                case '!': {
                    if (in_brackets > 0) {
                        if (Strings.lookBehind(sb) == '[') {
                            sb.append('^');
                            break;
                        }
                        sb.append(c);
                        break;
                    }
                    sb.append(c);
                    break;
                }
                default: {
                    if (in_char_class) {
                        Strings.setNext(charClass, c);
                        break;
                    }
                    sb.append(c);
                }
            }
            seenEscape = c == '\\';
        }
        if (in_brackets > 0) {
            throw new InvalidPatternException("Not closed bracket?", pattern2);
        }
        try {
            return Pattern.compile(sb.toString());
        }
        catch (PatternSyntaxException e) {
            InvalidPatternException patternException = new InvalidPatternException(MessageFormat.format(JGitText.get().invalidIgnoreRule, pattern2), pattern2);
            patternException.initCause(e);
            throw patternException;
        }
    }

    private static char lookBehind(StringBuilder buffer) {
        return buffer.length() > 0 ? buffer.charAt(buffer.length() - 1) : (char)'\u0000';
    }

    private static char lookAhead(String pattern2, int i) {
        int idx = i + 1;
        return idx >= pattern2.length() ? (char)'\u0000' : pattern2.charAt(idx);
    }

    private static void setNext(char[] buffer, char c) {
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] != '\u0000') continue;
            buffer[i] = c;
            break;
        }
    }

    private static void reset(char[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = '\u0000';
        }
    }

    private static String checkPosixCharClass(char[] buffer) {
        for (int i = 0; i < POSIX_CHAR_CLASSES.size(); ++i) {
            String clazz = POSIX_CHAR_CLASSES.get(i);
            boolean match = true;
            for (int j = 0; j < clazz.length(); ++j) {
                if (buffer[j] == clazz.charAt(j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return JAVA_CHAR_CLASSES.get(i);
        }
        return null;
    }

    static String deleteBackslash(String s2) {
        if (s2.indexOf(92) < 0) {
            return s2;
        }
        StringBuilder sb = new StringBuilder(s2.length());
        for (int i = 0; i < s2.length(); ++i) {
            char ch = s2.charAt(i);
            if (ch == '\\') {
                if (i + 1 == s2.length()) continue;
                char next2 = s2.charAt(i + 1);
                if (next2 == '\\') {
                    sb.append(ch);
                    ++i;
                    continue;
                }
                if (!Strings.escapedByBackslash(next2)) continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    static enum PatternState {
        LEADING_ASTERISK_ONLY,
        TRAILING_ASTERISK_ONLY,
        COMPLEX,
        NONE;

    }
}

