/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import org.eclipse.jgit.internal.storage.dfs.DfsRefDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;

final class DfsRefUpdate
extends RefUpdate {
    private final DfsRefDatabase refdb;
    private Ref dstRef;
    private RevWalk rw;

    DfsRefUpdate(DfsRefDatabase refdb, Ref ref) {
        super(ref);
        this.refdb = refdb;
    }

    @Override
    protected DfsRefDatabase getRefDatabase() {
        return this.refdb;
    }

    @Override
    protected DfsRepository getRepository() {
        return this.refdb.getRepository();
    }

    @Override
    protected boolean tryLock(boolean deref) throws IOException {
        this.dstRef = this.getRef();
        if (deref) {
            this.dstRef = this.dstRef.getLeaf();
        }
        if (this.dstRef.isSymbolic()) {
            this.setOldObjectId(null);
        } else {
            this.setOldObjectId(this.dstRef.getObjectId());
        }
        return true;
    }

    @Override
    protected void unlock() {
    }

    @Override
    public RefUpdate.Result update(RevWalk walk2) throws IOException {
        try {
            this.rw = walk2;
            RefUpdate.Result result2 = super.update(walk2);
            return result2;
        }
        finally {
            this.rw = null;
        }
    }

    @Override
    protected RefUpdate.Result doUpdate(RefUpdate.Result desiredResult) throws IOException {
        RevObject obj2 = this.rw.parseAny(this.getNewObjectId());
        ObjectIdRef newRef = obj2 instanceof RevTag ? new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, this.dstRef.getName(), this.getNewObjectId(), this.rw.peel(obj2).copy()) : new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, this.dstRef.getName(), this.getNewObjectId());
        if (this.getRefDatabase().compareAndPut(this.dstRef, newRef)) {
            this.getRefDatabase().stored(newRef);
            return desiredResult;
        }
        return RefUpdate.Result.LOCK_FAILURE;
    }

    @Override
    protected RefUpdate.Result doDelete(RefUpdate.Result desiredResult) throws IOException {
        if (this.getRefDatabase().compareAndRemove(this.dstRef)) {
            this.getRefDatabase().removed(this.dstRef.getName());
            return desiredResult;
        }
        return RefUpdate.Result.LOCK_FAILURE;
    }

    @Override
    protected RefUpdate.Result doLink(String target) throws IOException {
        SymbolicRef newRef = new SymbolicRef(this.dstRef.getName(), new ObjectIdRef.Unpeeled(Ref.Storage.NEW, target, null));
        if (this.getRefDatabase().compareAndPut(this.dstRef, newRef)) {
            this.getRefDatabase().stored(newRef);
            if (this.dstRef.getStorage() == Ref.Storage.NEW) {
                return RefUpdate.Result.NEW;
            }
            return RefUpdate.Result.FORCED;
        }
        return RefUpdate.Result.LOCK_FAILURE;
    }
}

