/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftree;

import java.io.IOException;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

public class Command {
    private final Ref oldRef;
    private final Ref newRef;
    private final ReceiveCommand cmd;
    private ReceiveCommand.Result result;

    public static void abort(Iterable<Command> commands2, @Nullable String why) {
        if (why == null || why.isEmpty()) {
            why = JGitText.get().transactionAborted;
        }
        for (Command c : commands2) {
            if (c.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
            c.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, why);
            why = JGitText.get().transactionAborted;
        }
    }

    public Command(@Nullable Ref oldRef, @Nullable Ref newRef) {
        this.oldRef = oldRef;
        this.newRef = newRef;
        this.cmd = null;
        this.result = ReceiveCommand.Result.NOT_ATTEMPTED;
        if (oldRef == null && newRef == null) {
            throw new IllegalArgumentException();
        }
        if (newRef != null && !newRef.isPeeled() && !newRef.isSymbolic()) {
            throw new IllegalArgumentException();
        }
        if (oldRef != null && newRef != null && !oldRef.getName().equals(newRef.getName())) {
            throw new IllegalArgumentException();
        }
    }

    public Command(RevWalk rw, ReceiveCommand cmd) throws MissingObjectException, IOException {
        this.oldRef = Command.toRef(rw, cmd.getOldId(), cmd.getRefName(), false);
        this.newRef = Command.toRef(rw, cmd.getNewId(), cmd.getRefName(), true);
        this.cmd = cmd;
    }

    static Ref toRef(RevWalk rw, ObjectId id2, String name, boolean mustExist) throws MissingObjectException, IOException {
        if (ObjectId.zeroId().equals(id2)) {
            return null;
        }
        try {
            RevObject o = rw.parseAny(id2);
            if (o instanceof RevTag) {
                RevObject p = rw.peel(o);
                return new ObjectIdRef.PeeledTag(Ref.Storage.NETWORK, name, id2, p.copy());
            }
            return new ObjectIdRef.PeeledNonTag(Ref.Storage.NETWORK, name, id2);
        }
        catch (MissingObjectException e) {
            if (mustExist) {
                throw e;
            }
            return new ObjectIdRef.Unpeeled(Ref.Storage.NETWORK, name, id2);
        }
    }

    public String getRefName() {
        if (this.cmd != null) {
            return this.cmd.getRefName();
        }
        if (this.newRef != null) {
            return this.newRef.getName();
        }
        return this.oldRef.getName();
    }

    public void setResult(ReceiveCommand.Result result2) {
        this.setResult(result2, null);
    }

    public void setResult(ReceiveCommand.Result result2, @Nullable String why) {
        if (this.cmd != null) {
            this.cmd.setResult(result2, why);
        } else {
            this.result = result2;
        }
    }

    public ReceiveCommand.Result getResult() {
        return this.cmd != null ? this.cmd.getResult() : this.result;
    }

    @Nullable
    public String getMessage() {
        return this.cmd != null ? this.cmd.getMessage() : null;
    }

    @Nullable
    public Ref getOldRef() {
        return this.oldRef;
    }

    @Nullable
    public Ref getNewRef() {
        return this.newRef;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        Command.append(s2, this.oldRef, "CREATE");
        s2.append(' ');
        Command.append(s2, this.newRef, "DELETE");
        s2.append(' ').append(this.getRefName());
        s2.append(' ').append((Object)this.getResult());
        if (this.getMessage() != null) {
            s2.append(' ').append(this.getMessage());
        }
        return s2.toString();
    }

    private static void append(StringBuilder s2, Ref r, String nullName) {
        if (r == null) {
            s2.append(nullName);
        } else if (r.isSymbolic()) {
            s2.append(r.getTarget().getName());
        } else {
            ObjectId id2 = r.getObjectId();
            if (id2 != null) {
                s2.append(id2.name());
            }
        }
    }

    boolean checkRef(@Nullable DirCacheEntry entry) {
        if (entry != null && entry.getRawMode() == 0) {
            entry = null;
        }
        return Command.check(entry, this.oldRef) || Command.check(entry, this.newRef);
    }

    private static boolean check(@Nullable DirCacheEntry cur, @Nullable Ref exp) {
        if (cur == null) {
            return exp == null;
        }
        if (exp == null) {
            return false;
        }
        if (exp.isSymbolic()) {
            String dst = exp.getTarget().getName();
            return cur.getRawMode() == 40960 && cur.getObjectId().equals(Command.symref(dst));
        }
        return cur.getRawMode() == 57344 && cur.getObjectId().equals(exp.getObjectId());
    }

    static ObjectId symref(String s2) {
        ObjectInserter.Formatter fmt = new ObjectInserter.Formatter();
        return fmt.idFor(3, Constants.encode(s2));
    }
}

