/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.net.URISyntaxException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;

public class BranchConfig {
    public static final String LOCAL_REPOSITORY = ".";
    private final Config config;
    private final String branchName;

    public BranchConfig(Config config, String branchName) {
        this.config = config;
        this.branchName = branchName;
    }

    public String getTrackingBranch() {
        String remote2 = this.getRemoteOrDefault();
        String mergeRef = this.getMerge();
        if (remote2 == null || mergeRef == null) {
            return null;
        }
        if (this.isRemoteLocal()) {
            return mergeRef;
        }
        return this.findRemoteTrackingBranch(remote2, mergeRef);
    }

    public String getRemoteTrackingBranch() {
        String remote2 = this.getRemoteOrDefault();
        String mergeRef = this.getMerge();
        if (remote2 == null || mergeRef == null) {
            return null;
        }
        return this.findRemoteTrackingBranch(remote2, mergeRef);
    }

    public boolean isRemoteLocal() {
        return LOCAL_REPOSITORY.equals(this.getRemote());
    }

    public String getRemote() {
        return this.config.getString("branch", this.branchName, "remote");
    }

    public String getMerge() {
        return this.config.getString("branch", this.branchName, "merge");
    }

    public boolean isRebase() {
        return this.getRebaseMode() != BranchRebaseMode.NONE;
    }

    public BranchRebaseMode getRebaseMode() {
        return (BranchRebaseMode)this.config.getEnum(BranchRebaseMode.values(), "branch", this.branchName, "rebase", BranchRebaseMode.NONE);
    }

    private String findRemoteTrackingBranch(String remote2, String mergeRef) {
        RemoteConfig remoteConfig;
        try {
            remoteConfig = new RemoteConfig(this.config, remote2);
        }
        catch (URISyntaxException e) {
            return null;
        }
        for (RefSpec refSpec : remoteConfig.getFetchRefSpecs()) {
            if (!refSpec.matchSource(mergeRef)) continue;
            RefSpec expanded = refSpec.expandFromSource(mergeRef);
            return expanded.getDestination();
        }
        return null;
    }

    private String getRemoteOrDefault() {
        String remote2 = this.getRemote();
        if (remote2 == null) {
            return "origin";
        }
        return remote2;
    }

    public static enum BranchRebaseMode implements Config.ConfigEnum
    {
        REBASE("true"),
        PRESERVE("preserve"),
        INTERACTIVE("interactive"),
        NONE("false");

        private final String configValue;

        private BranchRebaseMode(String configValue) {
            this.configValue = configValue;
        }

        @Override
        public String toConfigValue() {
            return this.configValue;
        }

        @Override
        public boolean matchConfigValue(String s2) {
            return this.configValue.equals(s2);
        }
    }
}

