/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public class BranchTrackingStatus {
    private final String remoteTrackingBranch;
    private final int aheadCount;
    private final int behindCount;

    public static BranchTrackingStatus of(Repository repository, String branchName) throws IOException {
        String shortBranchName = Repository.shortenRefName(branchName);
        String fullBranchName = "refs/heads/" + shortBranchName;
        BranchConfig branchConfig = new BranchConfig(repository.getConfig(), shortBranchName);
        String trackingBranch = branchConfig.getTrackingBranch();
        if (trackingBranch == null) {
            return null;
        }
        Ref tracking = repository.exactRef(trackingBranch);
        if (tracking == null) {
            return null;
        }
        Ref local2 = repository.exactRef(fullBranchName);
        if (local2 == null) {
            return null;
        }
        RevWalk walk2 = new RevWalk(repository);
        RevCommit localCommit = walk2.parseCommit(local2.getObjectId());
        RevCommit trackingCommit = walk2.parseCommit(tracking.getObjectId());
        walk2.setRevFilter(RevFilter.MERGE_BASE);
        walk2.markStart(localCommit);
        walk2.markStart(trackingCommit);
        RevCommit mergeBase = walk2.next();
        walk2.reset();
        walk2.setRevFilter(RevFilter.ALL);
        int aheadCount = RevWalkUtils.count(walk2, localCommit, mergeBase);
        int behindCount = RevWalkUtils.count(walk2, trackingCommit, mergeBase);
        return new BranchTrackingStatus(trackingBranch, aheadCount, behindCount);
    }

    private BranchTrackingStatus(String remoteTrackingBranch, int aheadCount, int behindCount) {
        this.remoteTrackingBranch = remoteTrackingBranch;
        this.aheadCount = aheadCount;
        this.behindCount = behindCount;
    }

    public String getRemoteTrackingBranch() {
        return this.remoteTrackingBranch;
    }

    public int getAheadCount() {
        return this.aheadCount;
    }

    public int getBehindCount() {
        return this.behindCount;
    }
}

