/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.attributes.AttributesNodeProvider;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerList;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.CheckoutEntry;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.RebaseTodoFile;
import org.eclipse.jgit.lib.RebaseTodoLine;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Repository
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(Repository.class);
    private static final ListenerList globalListeners = new ListenerList();
    private static final Pattern FORBIDDEN_BRANCH_NAME_COMPONENTS = Pattern.compile("(^|/)(aux|com[1-9]|con|lpt[1-9]|nul|prn)(\\.[^/]*)?", 2);
    final AtomicInteger useCnt = new AtomicInteger(1);
    final AtomicLong closedAt = new AtomicLong();
    private final File gitDir;
    private final FS fs;
    private final ListenerList myListeners = new ListenerList();
    private final File workTree;
    private final File indexFile;

    public static ListenerList getGlobalListenerList() {
        return globalListeners;
    }

    protected Repository(BaseRepositoryBuilder options) {
        this.gitDir = options.getGitDir();
        this.fs = options.getFS();
        this.workTree = options.getWorkTree();
        this.indexFile = options.getIndexFile();
    }

    @NonNull
    public ListenerList getListenerList() {
        return this.myListeners;
    }

    public void fireEvent(RepositoryEvent<?> event) {
        event.setRepository(this);
        this.myListeners.dispatch(event);
        globalListeners.dispatch(event);
    }

    public void create() throws IOException {
        this.create(false);
    }

    public abstract void create(boolean var1) throws IOException;

    public File getDirectory() {
        return this.gitDir;
    }

    @NonNull
    public abstract ObjectDatabase getObjectDatabase();

    @NonNull
    public ObjectInserter newObjectInserter() {
        return this.getObjectDatabase().newInserter();
    }

    @NonNull
    public ObjectReader newObjectReader() {
        return this.getObjectDatabase().newReader();
    }

    @NonNull
    public abstract RefDatabase getRefDatabase();

    @NonNull
    public abstract StoredConfig getConfig();

    @NonNull
    public abstract AttributesNodeProvider createAttributesNodeProvider();

    public FS getFS() {
        return this.fs;
    }

    public boolean hasObject(AnyObjectId objectId) {
        try {
            return this.getObjectDatabase().has(objectId);
        }
        catch (IOException e) {
            return false;
        }
    }

    @NonNull
    public ObjectLoader open(AnyObjectId objectId) throws MissingObjectException, IOException {
        return this.getObjectDatabase().open(objectId);
    }

    @NonNull
    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.getObjectDatabase().open(objectId, typeHint);
    }

    @NonNull
    public RefUpdate updateRef(String ref) throws IOException {
        return this.updateRef(ref, false);
    }

    @NonNull
    public RefUpdate updateRef(String ref, boolean detach) throws IOException {
        return this.getRefDatabase().newUpdate(ref, detach);
    }

    @NonNull
    public RefRename renameRef(String fromRef, String toRef) throws IOException {
        return this.getRefDatabase().newRename(fromRef, toRef);
    }

    @Nullable
    public ObjectId resolve(String revstr) throws AmbiguousObjectException, IncorrectObjectTypeException, RevisionSyntaxException, IOException {
        try (RevWalk rw = new RevWalk(this);){
            Object resolved = this.resolve(rw, revstr);
            if (resolved instanceof String) {
                Ref ref = this.getRef((String)resolved);
                ObjectId objectId = ref != null ? ref.getLeaf().getObjectId() : null;
                return objectId;
            }
            ObjectId objectId = (ObjectId)resolved;
            return objectId;
        }
    }

    @Nullable
    public String simplify(String revstr) throws AmbiguousObjectException, IOException {
        try (RevWalk rw = new RevWalk(this);){
            Object resolved = this.resolve(rw, revstr);
            if (resolved != null) {
                if (resolved instanceof String) {
                    String string2 = (String)resolved;
                    return string2;
                }
                String string3 = ((AnyObjectId)resolved).getName();
                return string3;
            }
            String string4 = null;
            return string4;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    private Object resolve(RevWalk rw, String revstr) throws IOException {
        revChars = revstr.toCharArray();
        rev /* !! */  = null;
        name = null;
        done = 0;
        block16: for (i = 0; i < revChars.length; ++i) {
            switch (revChars[i]) {
                case '^': {
                    if (rev /* !! */  == null) {
                        if (name == null) {
                            if (done == 0) {
                                name = new String(revChars, done, i);
                            } else {
                                done = i + 1;
                                continue block16;
                            }
                        }
                        rev /* !! */  = this.parseSimple(rw, name);
                        name = null;
                        if (rev /* !! */  == null) {
                            return null;
                        }
                    }
                    if (i + 1 >= revChars.length) ** GOTO lbl69
                    switch (revChars[i + 1]) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            rev /* !! */  = rw.parseCommit(rev /* !! */ );
                            for (j = i + 1; j < revChars.length && Character.isDigit(revChars[j]); ++j) {
                            }
                            parentnum = new String(revChars, i + 1, j - i - 1);
                            try {
                                pnum = Integer.parseInt(parentnum);
                            }
                            catch (NumberFormatException e) {
                                throw new RevisionSyntaxException(JGitText.get().invalidCommitParentNumber, revstr);
                            }
                            if (pnum != 0) {
                                commit = (RevCommit)rev /* !! */ ;
                                rev /* !! */  = pnum > commit.getParentCount() ? null : commit.getParent(pnum - 1);
                            }
                            i = j - 1;
                            done = j;
                            ** GOTO lbl74
                        }
                        case '{': {
                            item = null;
                            for (k = i + 2; k < revChars.length; ++k) {
                                if (revChars[k] != '}') continue;
                                item = new String(revChars, i + 2, k - i - 2);
                                break;
                            }
                            i = k;
                            if (item == null) ** GOTO lbl59
                            if (item.equals("tree")) {
                                rev /* !! */  = rw.parseTree(rev /* !! */ );
                            } else if (item.equals("commit")) {
                                rev /* !! */  = rw.parseCommit(rev /* !! */ );
                            } else if (item.equals("blob")) {
                                if (!((rev /* !! */  = rw.peel((RevObject)rev /* !! */ )) instanceof RevBlob)) {
                                    throw new IncorrectObjectTypeException((ObjectId)rev /* !! */ , "blob");
                                }
                            } else if (item.equals("")) {
                                rev /* !! */  = rw.peel((RevObject)rev /* !! */ );
                            } else {
                                throw new RevisionSyntaxException(revstr);
lbl59:
                                // 1 sources

                                throw new RevisionSyntaxException(revstr);
                            }
                            done = k;
                            ** GOTO lbl74
                        }
                        default: {
                            rev /* !! */  = rw.peel((RevObject)rev /* !! */ );
                            if (!(rev /* !! */  instanceof RevCommit)) ** GOTO lbl68
                            commit = (RevCommit)rev /* !! */ ;
                            rev /* !! */  = commit.getParentCount() == 0 ? null : commit.getParent(0);
                            ** GOTO lbl74
lbl68:
                            // 1 sources

                            throw new IncorrectObjectTypeException((ObjectId)rev /* !! */ , "commit");
                        }
                    }
lbl69:
                    // 1 sources

                    if ((rev /* !! */  = rw.peel((RevObject)rev /* !! */ )) instanceof RevCommit) {
                        commit = (RevCommit)rev /* !! */ ;
                        rev /* !! */  = commit.getParentCount() == 0 ? null : commit.getParent(0);
                    } else {
                        throw new IncorrectObjectTypeException((ObjectId)rev /* !! */ , "commit");
                    }
lbl74:
                    // 4 sources

                    done = i + 1;
                    continue block16;
                }
                case '~': {
                    if (rev /* !! */  == null) {
                        if (name == null) {
                            if (done == 0) {
                                name = new String(revChars, done, i);
                            } else {
                                done = i + 1;
                                continue block16;
                            }
                        }
                        rev /* !! */  = this.parseSimple(rw, name);
                        name = null;
                        if (rev /* !! */  == null) {
                            return null;
                        }
                    }
                    if (!((rev /* !! */  = rw.peel((RevObject)rev /* !! */ )) instanceof RevCommit)) {
                        throw new IncorrectObjectTypeException((ObjectId)rev /* !! */ , "commit");
                    }
                    for (l = i + 1; l < revChars.length && Character.isDigit(revChars[l]); ++l) {
                    }
                    if (l - i > 1) {
                        distnum = new String(revChars, i + 1, l - i - 1);
                        try {
                            dist = Integer.parseInt(distnum);
                        }
                        catch (NumberFormatException e) {
                            throw new RevisionSyntaxException(JGitText.get().invalidAncestryLength, revstr);
                        }
                    } else {
                        dist = 1;
                    }
                    while (dist > 0) {
                        commit = (RevCommit)rev /* !! */ ;
                        if (commit.getParentCount() == 0) {
                            rev /* !! */  = null;
                            break;
                        }
                        commit = commit.getParent(0);
                        rw.parseHeaders(commit);
                        rev /* !! */  = commit;
                        --dist;
                    }
                    i = l - 1;
                    done = l;
                    continue block16;
                }
                case '@': {
                    if (rev /* !! */  != null) {
                        throw new RevisionSyntaxException(revstr);
                    }
                    if (i + 1 < revChars.length && revChars[i + 1] != '{') continue block16;
                    time = null;
                    for (m = i + 2; m < revChars.length; ++m) {
                        if (revChars[m] != '}') continue;
                        time = new String(revChars, i + 2, m - i - 2);
                        break;
                    }
                    if (time != null) {
                        if (time.equals("upstream")) {
                            if (name == null) {
                                name = new String(revChars, done, i);
                            }
                            if (name.equals("")) {
                                name = "HEAD";
                            }
                            if (!Repository.isValidRefName("x/" + name)) {
                                throw new RevisionSyntaxException(MessageFormat.format(JGitText.get().invalidRefName, new Object[]{name}), revstr);
                            }
                            ref = this.getRef(name);
                            name = null;
                            if (ref == null) {
                                return null;
                            }
                            if (ref.isSymbolic()) {
                                ref = ref.getLeaf();
                            }
                            name = ref.getName();
                            try {
                                remoteConfig = new RemoteConfig(this.getConfig(), "origin");
                            }
                            catch (URISyntaxException e) {
                                throw new RevisionSyntaxException(revstr);
                            }
                            remoteBranchName = this.getConfig().getString("branch", Repository.shortenRefName(ref.getName()), "merge");
                            fetchRefSpecs = remoteConfig.getFetchRefSpecs();
                            for (RefSpec refSpec : fetchRefSpecs) {
                                if (!refSpec.matchSource(remoteBranchName)) continue;
                                expandFromSource = refSpec.expandFromSource(remoteBranchName);
                                name = expandFromSource.getDestination();
                                break;
                            }
                            if (name == null) {
                                throw new RevisionSyntaxException(revstr);
                            }
                        } else if (time.matches("^-\\d+$")) {
                            if (name != null) {
                                throw new RevisionSyntaxException(revstr);
                            }
                            previousCheckout = this.resolveReflogCheckout(-Integer.parseInt(time));
                            if (ObjectId.isId(previousCheckout)) {
                                rev /* !! */  = this.parseSimple(rw, previousCheckout);
                            } else {
                                name = previousCheckout;
                            }
                        } else {
                            if (name == null) {
                                name = new String(revChars, done, i);
                            }
                            if (name.equals("")) {
                                name = "HEAD";
                            }
                            if (!Repository.isValidRefName("x/" + name)) {
                                throw new RevisionSyntaxException(MessageFormat.format(JGitText.get().invalidRefName, new Object[]{name}), revstr);
                            }
                            ref = this.getRef(name);
                            name = null;
                            if (ref == null) {
                                return null;
                            }
                            if (ref.isSymbolic()) {
                                ref = ref.getLeaf();
                            }
                            rev /* !! */  = this.resolveReflog(rw, ref, time);
                        }
                        i = m;
                        continue block16;
                    }
                    throw new RevisionSyntaxException(revstr);
                }
                case ':': {
                    if (rev /* !! */  == null) {
                        if (name == null) {
                            name = new String(revChars, done, i);
                        }
                        if (name.equals("")) {
                            name = "HEAD";
                        }
                        rev /* !! */  = this.parseSimple(rw, name);
                        name = null;
                    }
                    if (rev /* !! */  == null) {
                        return null;
                    }
                    tree = rw.parseTree(rev /* !! */ );
                    if (i == revChars.length - 1) {
                        return tree.copy();
                    }
                    tw = TreeWalk.forPath(rw.getObjectReader(), new String(revChars, i + 1, revChars.length - i - 1), new AnyObjectId[]{tree});
                    return tw != null ? tw.getObjectId(0) : null;
                }
                default: {
                    if (rev /* !! */  == null) continue block16;
                    throw new RevisionSyntaxException(revstr);
                }
            }
        }
        if (rev /* !! */  != null) {
            return rev /* !! */ .copy();
        }
        if (name != null) {
            return name;
        }
        if (done == revstr.length()) {
            return null;
        }
        name = revstr.substring(done);
        if (!Repository.isValidRefName("x/" + name)) {
            throw new RevisionSyntaxException(MessageFormat.format(JGitText.get().invalidRefName, new Object[]{name}), revstr);
        }
        if (this.getRef(name) != null) {
            return name;
        }
        return this.resolveSimple(name);
    }

    private static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    private static boolean isAllHex(String str, int ptr) {
        while (ptr < str.length()) {
            if (Repository.isHex(str.charAt(ptr++))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private RevObject parseSimple(RevWalk rw, String revstr) throws IOException {
        ObjectId id2 = this.resolveSimple(revstr);
        return id2 != null ? rw.parseAny(id2) : null;
    }

    @Nullable
    private ObjectId resolveSimple(String revstr) throws IOException {
        String s2;
        Ref r;
        if (ObjectId.isId(revstr)) {
            return ObjectId.fromString(revstr);
        }
        if (Repository.isValidRefName("x/" + revstr) && (r = this.getRefDatabase().getRef(revstr)) != null) {
            return r.getObjectId();
        }
        if (AbbreviatedObjectId.isId(revstr)) {
            return this.resolveAbbreviation(revstr);
        }
        int dashg = revstr.indexOf("-g");
        if (dashg + 5 < revstr.length() && 0 <= dashg && Repository.isHex(revstr.charAt(dashg + 2)) && Repository.isHex(revstr.charAt(dashg + 3)) && Repository.isAllHex(revstr, dashg + 4) && AbbreviatedObjectId.isId(s2 = revstr.substring(dashg + 2))) {
            return this.resolveAbbreviation(s2);
        }
        return null;
    }

    @Nullable
    private String resolveReflogCheckout(int checkoutNo) throws IOException {
        ReflogReader reader = this.getReflogReader("HEAD");
        if (reader == null) {
            return null;
        }
        List<ReflogEntry> reflogEntries = reader.getReverseEntries();
        for (ReflogEntry entry : reflogEntries) {
            CheckoutEntry checkout = entry.parseCheckout();
            if (checkout == null || checkoutNo-- != 1) continue;
            return checkout.getFromBranch();
        }
        return null;
    }

    private RevCommit resolveReflog(RevWalk rw, Ref ref, String time) throws IOException {
        int number;
        try {
            number = Integer.parseInt(time);
        }
        catch (NumberFormatException nfe) {
            throw new RevisionSyntaxException(MessageFormat.format(JGitText.get().invalidReflogRevision, time));
        }
        assert (number >= 0);
        ReflogReader reader = this.getReflogReader(ref.getName());
        if (reader == null) {
            throw new RevisionSyntaxException(MessageFormat.format(JGitText.get().reflogEntryNotFound, number, ref.getName()));
        }
        ReflogEntry entry = reader.getReverseEntry(number);
        if (entry == null) {
            throw new RevisionSyntaxException(MessageFormat.format(JGitText.get().reflogEntryNotFound, number, ref.getName()));
        }
        return rw.parseCommit(entry.getNewId());
    }

    @Nullable
    private ObjectId resolveAbbreviation(String revstr) throws IOException, AmbiguousObjectException {
        AbbreviatedObjectId id2 = AbbreviatedObjectId.fromString(revstr);
        Throwable throwable = null;
        try (ObjectReader reader = this.newObjectReader();){
            Collection<ObjectId> matches = reader.resolve(id2);
            if (matches.size() == 0) {
                ObjectId objectId = null;
                return objectId;
            }
            if (matches.size() == 1) {
                ObjectId objectId = matches.iterator().next();
                return objectId;
            }
            try {
                throw new AmbiguousObjectException(id2, matches);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void incrementOpen() {
        this.useCnt.incrementAndGet();
    }

    @Override
    public void close() {
        int newCount = this.useCnt.decrementAndGet();
        if (newCount == 0) {
            if (RepositoryCache.isCached(this)) {
                this.closedAt.set(System.currentTimeMillis());
            } else {
                this.doClose();
            }
        } else if (newCount == -1) {
            String message = MessageFormat.format(JGitText.get().corruptUseCnt, this.toString());
            if (LOG.isDebugEnabled()) {
                LOG.debug(message, new IllegalStateException());
            } else {
                LOG.warn(message);
            }
            if (RepositoryCache.isCached(this)) {
                this.closedAt.set(System.currentTimeMillis());
            }
        }
    }

    protected void doClose() {
        this.getObjectDatabase().close();
        this.getRefDatabase().close();
    }

    @NonNull
    public String toString() {
        File directory = this.getDirectory();
        String desc = directory != null ? directory.getPath() : this.getClass().getSimpleName() + "-" + System.identityHashCode(this);
        return "Repository[" + desc + "]";
    }

    @Nullable
    public String getFullBranch() throws IOException {
        Ref head2 = this.exactRef("HEAD");
        if (head2 == null) {
            return null;
        }
        if (head2.isSymbolic()) {
            return head2.getTarget().getName();
        }
        ObjectId objectId = head2.getObjectId();
        if (objectId != null) {
            return objectId.name();
        }
        return null;
    }

    @Nullable
    public String getBranch() throws IOException {
        String name = this.getFullBranch();
        if (name != null) {
            return Repository.shortenRefName(name);
        }
        return null;
    }

    @NonNull
    public Set<ObjectId> getAdditionalHaves() {
        return Collections.emptySet();
    }

    @Deprecated
    @Nullable
    public Ref getRef(String name) throws IOException {
        return this.findRef(name);
    }

    @Nullable
    public Ref exactRef(String name) throws IOException {
        return this.getRefDatabase().exactRef(name);
    }

    @Nullable
    public Ref findRef(String name) throws IOException {
        return this.getRefDatabase().getRef(name);
    }

    @NonNull
    public Map<String, Ref> getAllRefs() {
        try {
            return this.getRefDatabase().getRefs("");
        }
        catch (IOException e) {
            return new HashMap<String, Ref>();
        }
    }

    @NonNull
    public Map<String, Ref> getTags() {
        try {
            return this.getRefDatabase().getRefs("refs/tags/");
        }
        catch (IOException e) {
            return new HashMap<String, Ref>();
        }
    }

    @NonNull
    public Ref peel(Ref ref) {
        try {
            return this.getRefDatabase().peel(ref);
        }
        catch (IOException e) {
            return ref;
        }
    }

    @NonNull
    public Map<AnyObjectId, Set<Ref>> getAllRefsByPeeledObjectId() {
        Map<String, Ref> allRefs = this.getAllRefs();
        HashMap<AnyObjectId, Set<Ref>> ret = new HashMap<AnyObjectId, Set<Ref>>(allRefs.size());
        for (Ref ref : allRefs.values()) {
            Set<Ref> oset;
            ObjectId target = (ref = this.peel(ref)).getPeeledObjectId();
            if (target == null) {
                target = ref.getObjectId();
            }
            if ((oset = ret.put(target, Collections.singleton(ref))) == null) continue;
            if (oset.size() == 1) {
                oset = new HashSet<Ref>(oset);
            }
            ret.put(target, oset);
            oset.add(ref);
        }
        return ret;
    }

    @NonNull
    public File getIndexFile() throws NoWorkTreeException {
        if (this.isBare()) {
            throw new NoWorkTreeException();
        }
        return this.indexFile;
    }

    public RevCommit parseCommit(AnyObjectId id2) throws IncorrectObjectTypeException, IOException, MissingObjectException {
        if (id2 instanceof RevCommit && ((RevCommit)id2).getRawBuffer() != null) {
            return (RevCommit)id2;
        }
        try (RevWalk walk2 = new RevWalk(this);){
            RevCommit revCommit = walk2.parseCommit(id2);
            return revCommit;
        }
    }

    @NonNull
    public DirCache readDirCache() throws NoWorkTreeException, CorruptObjectException, IOException {
        return DirCache.read(this);
    }

    @NonNull
    public DirCache lockDirCache() throws NoWorkTreeException, CorruptObjectException, IOException {
        IndexChangedListener l = new IndexChangedListener(){

            @Override
            public void onIndexChanged(IndexChangedEvent event) {
                Repository.this.notifyIndexChanged();
            }
        };
        return DirCache.lock(this, l);
    }

    @NonNull
    public RepositoryState getRepositoryState() {
        if (this.isBare() || this.getDirectory() == null) {
            return RepositoryState.BARE;
        }
        if (new File(this.getWorkTree(), ".dotest").exists()) {
            return RepositoryState.REBASING;
        }
        if (new File(this.getDirectory(), ".dotest-merge").exists()) {
            return RepositoryState.REBASING_INTERACTIVE;
        }
        if (new File(this.getDirectory(), "rebase-apply/rebasing").exists()) {
            return RepositoryState.REBASING_REBASING;
        }
        if (new File(this.getDirectory(), "rebase-apply/applying").exists()) {
            return RepositoryState.APPLY;
        }
        if (new File(this.getDirectory(), "rebase-apply").exists()) {
            return RepositoryState.REBASING;
        }
        if (new File(this.getDirectory(), "rebase-merge/interactive").exists()) {
            return RepositoryState.REBASING_INTERACTIVE;
        }
        if (new File(this.getDirectory(), "rebase-merge").exists()) {
            return RepositoryState.REBASING_MERGE;
        }
        if (new File(this.getDirectory(), "MERGE_HEAD").exists()) {
            try {
                if (!this.readDirCache().hasUnmergedPaths()) {
                    return RepositoryState.MERGING_RESOLVED;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return RepositoryState.MERGING;
        }
        if (new File(this.getDirectory(), "BISECT_LOG").exists()) {
            return RepositoryState.BISECTING;
        }
        if (new File(this.getDirectory(), "CHERRY_PICK_HEAD").exists()) {
            try {
                if (!this.readDirCache().hasUnmergedPaths()) {
                    return RepositoryState.CHERRY_PICKING_RESOLVED;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return RepositoryState.CHERRY_PICKING;
        }
        if (new File(this.getDirectory(), "REVERT_HEAD").exists()) {
            try {
                if (!this.readDirCache().hasUnmergedPaths()) {
                    return RepositoryState.REVERTING_RESOLVED;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return RepositoryState.REVERTING;
        }
        return RepositoryState.SAFE;
    }

    public static boolean isValidRefName(String refName) {
        int len = refName.length();
        if (len == 0) {
            return false;
        }
        if (refName.endsWith(".lock")) {
            return false;
        }
        try {
            SystemReader.getInstance().checkPath(refName);
        }
        catch (CorruptObjectException e) {
            return false;
        }
        int components = 1;
        int p = 0;
        for (int i = 0; i < len; ++i) {
            char c = refName.charAt(i);
            if (c <= ' ') {
                return false;
            }
            switch (c) {
                case '.': {
                    switch (p) {
                        case 0: 
                        case 46: 
                        case 47: {
                            return false;
                        }
                    }
                    if (i != len - 1) break;
                    return false;
                }
                case '/': {
                    if (i == 0 || i == len - 1) {
                        return false;
                    }
                    if (p == 47) {
                        return false;
                    }
                    ++components;
                    break;
                }
                case '{': {
                    if (p != 64) break;
                    return false;
                }
                case '*': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '~': 
                case '\u007f': {
                    return false;
                }
            }
            p = c;
        }
        return components > 1;
    }

    public static String normalizeBranchName(String name) {
        String fullName;
        if (name == null || name.isEmpty()) {
            return "";
        }
        String result2 = name.trim();
        String string2 = fullName = result2.startsWith("refs/heads/") ? result2 : "refs/heads/" + result2;
        if (Repository.isValidRefName(fullName)) {
            return result2;
        }
        result2 = result2.replaceAll("(?:\\h|\\v)+", "_");
        StringBuilder b = new StringBuilder();
        int p = 47;
        int len = result2.length();
        block7: for (int i = 0; i < len; ++i) {
            int c = result2.charAt(i);
            if (c < 32 || c == 127) continue;
            switch (c) {
                case 34: 
                case 42: 
                case 58: 
                case 60: 
                case 62: 
                case 63: 
                case 64: 
                case 91: 
                case 92: 
                case 94: 
                case 124: 
                case 126: {
                    c = 45;
                    break;
                }
            }
            switch (c) {
                case 47: {
                    if (p == 47) continue block7;
                    p = 47;
                    break;
                }
                case 45: 
                case 46: 
                case 95: {
                    if (p == 47 || p == 45) continue block7;
                    p = 45;
                    break;
                }
                default: {
                    p = c;
                }
            }
            b.append((char)c);
        }
        result2 = b.toString().replaceFirst("[/_.-]+$", "").replaceAll("\\.lock($|/)", "_lock$1");
        return FORBIDDEN_BRANCH_NAME_COMPONENTS.matcher(result2).replaceAll("$1+$2$3");
    }

    @NonNull
    public static String stripWorkDir(File workDir, File file) {
        String filePath = file.getPath();
        String workDirPath = workDir.getPath();
        if (filePath.length() <= workDirPath.length() || filePath.charAt(workDirPath.length()) != File.separatorChar || !filePath.startsWith(workDirPath)) {
            File absFile;
            File absWd = workDir.isAbsolute() ? workDir : workDir.getAbsoluteFile();
            File file2 = absFile = file.isAbsolute() ? file : file.getAbsoluteFile();
            if (absWd == workDir && absFile == file) {
                return "";
            }
            return Repository.stripWorkDir(absWd, absFile);
        }
        String relName = filePath.substring(workDirPath.length() + 1);
        if (File.separatorChar != '/') {
            relName = relName.replace(File.separatorChar, '/');
        }
        return relName;
    }

    public boolean isBare() {
        return this.workTree == null;
    }

    @NonNull
    public File getWorkTree() throws NoWorkTreeException {
        if (this.isBare()) {
            throw new NoWorkTreeException();
        }
        return this.workTree;
    }

    public abstract void scanForRepoChanges() throws IOException;

    public abstract void notifyIndexChanged();

    @NonNull
    public static String shortenRefName(String refName) {
        if (refName.startsWith("refs/heads/")) {
            return refName.substring("refs/heads/".length());
        }
        if (refName.startsWith("refs/tags/")) {
            return refName.substring("refs/tags/".length());
        }
        if (refName.startsWith("refs/remotes/")) {
            return refName.substring("refs/remotes/".length());
        }
        return refName;
    }

    @Nullable
    public String shortenRemoteBranchName(String refName) {
        for (String remote2 : this.getRemoteNames()) {
            String remotePrefix = "refs/remotes/" + remote2 + "/";
            if (!refName.startsWith(remotePrefix)) continue;
            return refName.substring(remotePrefix.length());
        }
        return null;
    }

    @Nullable
    public String getRemoteName(String refName) {
        for (String remote2 : this.getRemoteNames()) {
            String remotePrefix = "refs/remotes/" + remote2 + "/";
            if (!refName.startsWith(remotePrefix)) continue;
            return remote2;
        }
        return null;
    }

    @Nullable
    public String getGitwebDescription() throws IOException {
        return null;
    }

    public void setGitwebDescription(@Nullable String description) throws IOException {
        throw new IOException(JGitText.get().unsupportedRepositoryDescription);
    }

    @Nullable
    public abstract ReflogReader getReflogReader(String var1) throws IOException;

    @Nullable
    public String readMergeCommitMsg() throws IOException, NoWorkTreeException {
        return this.readCommitMsgFile("MERGE_MSG");
    }

    public void writeMergeCommitMsg(String msg) throws IOException {
        File mergeMsgFile = new File(this.gitDir, "MERGE_MSG");
        this.writeCommitMsg(mergeMsgFile, msg);
    }

    @Nullable
    public String readCommitEditMsg() throws IOException, NoWorkTreeException {
        return this.readCommitMsgFile("COMMIT_EDITMSG");
    }

    public void writeCommitEditMsg(String msg) throws IOException {
        File commiEditMsgFile = new File(this.gitDir, "COMMIT_EDITMSG");
        this.writeCommitMsg(commiEditMsgFile, msg);
    }

    @Nullable
    public List<ObjectId> readMergeHeads() throws IOException, NoWorkTreeException {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        byte[] raw2 = this.readGitDirectoryFile("MERGE_HEAD");
        if (raw2 == null) {
            return null;
        }
        LinkedList<ObjectId> heads = new LinkedList<ObjectId>();
        int p = 0;
        while (p < raw2.length) {
            heads.add(ObjectId.fromString(raw2, p));
            p = RawParseUtils.nextLF(raw2, p + 40);
        }
        return heads;
    }

    public void writeMergeHeads(List<? extends ObjectId> heads) throws IOException {
        this.writeHeadsFile(heads, "MERGE_HEAD");
    }

    @Nullable
    public ObjectId readCherryPickHead() throws IOException, NoWorkTreeException {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        byte[] raw2 = this.readGitDirectoryFile("CHERRY_PICK_HEAD");
        if (raw2 == null) {
            return null;
        }
        return ObjectId.fromString(raw2, 0);
    }

    @Nullable
    public ObjectId readRevertHead() throws IOException, NoWorkTreeException {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        byte[] raw2 = this.readGitDirectoryFile("REVERT_HEAD");
        if (raw2 == null) {
            return null;
        }
        return ObjectId.fromString(raw2, 0);
    }

    public void writeCherryPickHead(ObjectId head2) throws IOException {
        List<ObjectId> heads = head2 != null ? Collections.singletonList(head2) : null;
        this.writeHeadsFile(heads, "CHERRY_PICK_HEAD");
    }

    public void writeRevertHead(ObjectId head2) throws IOException {
        List<ObjectId> heads = head2 != null ? Collections.singletonList(head2) : null;
        this.writeHeadsFile(heads, "REVERT_HEAD");
    }

    public void writeOrigHead(ObjectId head2) throws IOException {
        List<ObjectId> heads = head2 != null ? Collections.singletonList(head2) : null;
        this.writeHeadsFile(heads, "ORIG_HEAD");
    }

    @Nullable
    public ObjectId readOrigHead() throws IOException, NoWorkTreeException {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        byte[] raw2 = this.readGitDirectoryFile("ORIG_HEAD");
        return raw2 != null ? ObjectId.fromString(raw2, 0) : null;
    }

    @Nullable
    public String readSquashCommitMsg() throws IOException {
        return this.readCommitMsgFile("SQUASH_MSG");
    }

    public void writeSquashCommitMsg(String msg) throws IOException {
        File squashMsgFile = new File(this.gitDir, "SQUASH_MSG");
        this.writeCommitMsg(squashMsgFile, msg);
    }

    @Nullable
    private String readCommitMsgFile(String msgFilename) throws IOException {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        File mergeMsgFile = new File(this.getDirectory(), msgFilename);
        try {
            return RawParseUtils.decode(IO.readFully(mergeMsgFile));
        }
        catch (FileNotFoundException e) {
            if (mergeMsgFile.exists()) {
                throw e;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCommitMsg(File msgFile, String msg) throws IOException {
        if (msg != null) {
            try (FileOutputStream fos = new FileOutputStream(msgFile);){
                fos.write(msg.getBytes("UTF-8"));
            }
        } else {
            FileUtils.delete(msgFile, 4);
        }
    }

    @Nullable
    private byte[] readGitDirectoryFile(String filename) throws IOException {
        File file = new File(this.getDirectory(), filename);
        try {
            byte[] raw2 = IO.readFully(file);
            return (byte[])(raw2.length > 0 ? raw2 : null);
        }
        catch (FileNotFoundException notFound) {
            if (file.exists()) {
                throw notFound;
            }
            return null;
        }
    }

    private void writeHeadsFile(List<? extends ObjectId> heads, String filename) throws FileNotFoundException, IOException {
        File headsFile = new File(this.getDirectory(), filename);
        if (heads != null) {
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(headsFile));){
                for (ObjectId objectId : heads) {
                    objectId.copyTo(bos);
                    ((OutputStream)bos).write(10);
                }
            }
        } else {
            FileUtils.delete(headsFile, 4);
        }
    }

    @NonNull
    public List<RebaseTodoLine> readRebaseTodo(String path, boolean includeComments) throws IOException {
        return new RebaseTodoFile(this).readRebaseTodo(path, includeComments);
    }

    public void writeRebaseTodoFile(String path, List<RebaseTodoLine> steps, boolean append2) throws IOException {
        new RebaseTodoFile(this).writeRebaseTodoFile(path, steps, append2);
    }

    @NonNull
    public Set<String> getRemoteNames() {
        return this.getConfig().getSubsections("remote");
    }

    public void autoGC(ProgressMonitor monitor) {
    }
}

