/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.nls;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jgit.nls.GlobalBundleCache;
import org.eclipse.jgit.nls.TranslationBundle;

public class NLS {
    public static final Locale ROOT_LOCALE = new Locale("", "", "");
    private static final InheritableThreadLocal<NLS> local = new InheritableThreadLocal<NLS>(){

        @Override
        protected NLS initialValue() {
            return new NLS(Locale.getDefault());
        }
    };
    private final Locale locale;
    private final ConcurrentHashMap<Class, TranslationBundle> map = new ConcurrentHashMap();

    public static void setLocale(Locale locale) {
        local.set(new NLS(locale));
    }

    public static void useJVMDefaultLocale() {
        local.set(new NLS(Locale.getDefault()));
    }

    public static <T extends TranslationBundle> T getBundleFor(Class<T> type) {
        return ((NLS)local.get()).get(type);
    }

    private NLS(Locale locale) {
        this.locale = locale;
    }

    private <T extends TranslationBundle> T get(Class<T> type) {
        TranslationBundle old;
        TranslationBundle bundle2 = this.map.get(type);
        if (bundle2 == null && (old = this.map.putIfAbsent(type, bundle2 = GlobalBundleCache.lookupBundle(this.locale, type))) != null) {
            bundle2 = old;
        }
        return (T)bundle2;
    }
}

