/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.notes;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.notes.InMemoryNoteBucket;
import org.eclipse.jgit.notes.LeafBucket;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteParser;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;

public class NoteMap
implements Iterable<Note> {
    private final ObjectReader reader;
    private InMemoryNoteBucket root;

    public static NoteMap newEmptyMap() {
        NoteMap r = new NoteMap(null);
        r.root = new LeafBucket(0);
        return r;
    }

    public static String shortenRefName(String noteRefName) {
        if (noteRefName.startsWith("refs/notes/")) {
            return noteRefName.substring("refs/notes/".length());
        }
        return noteRefName;
    }

    public static NoteMap read(ObjectReader reader, RevCommit commit) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        return NoteMap.read(reader, commit.getTree());
    }

    public static NoteMap read(ObjectReader reader, RevTree tree) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        return NoteMap.readTree(reader, tree);
    }

    public static NoteMap readTree(ObjectReader reader, ObjectId treeId) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        NoteMap map23 = new NoteMap(reader);
        map23.load(treeId);
        return map23;
    }

    static NoteMap newMap(InMemoryNoteBucket root, ObjectReader reader) {
        NoteMap map23 = new NoteMap(reader);
        map23.root = root;
        return map23;
    }

    private NoteMap(ObjectReader reader) {
        this.reader = reader;
    }

    @Override
    public Iterator<Note> iterator() {
        try {
            return this.root.iterator(new MutableObjectId(), this.reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectId get(AnyObjectId id2) throws IOException {
        Note n = this.root.getNote(id2, this.reader);
        return n == null ? null : n.getData();
    }

    public Note getNote(AnyObjectId id2) throws IOException {
        return this.root.getNote(id2, this.reader);
    }

    public boolean contains(AnyObjectId id2) throws IOException {
        return this.get(id2) != null;
    }

    public byte[] getCachedBytes(AnyObjectId id2, int sizeLimit) throws LargeObjectException, MissingObjectException, IOException {
        ObjectId dataId = this.get(id2);
        if (dataId != null) {
            return this.reader.open(dataId).getCachedBytes(sizeLimit);
        }
        return null;
    }

    public void set(AnyObjectId noteOn, ObjectId noteData) throws IOException {
        InMemoryNoteBucket newRoot = this.root.set(noteOn, noteData, this.reader);
        if (newRoot == null) {
            newRoot = new LeafBucket(0);
            newRoot.nonNotes = this.root.nonNotes;
        }
        this.root = newRoot;
    }

    public void set(AnyObjectId noteOn, String noteData, ObjectInserter ins) throws IOException {
        ObjectId dataId;
        if (noteData != null) {
            byte[] dataUTF8 = Constants.encode(noteData);
            dataId = ins.insert(3, dataUTF8);
        } else {
            dataId = null;
        }
        this.set(noteOn, dataId);
    }

    public void remove(AnyObjectId noteOn) throws IOException {
        this.set(noteOn, null);
    }

    public ObjectId writeTree(ObjectInserter inserter) throws IOException {
        return this.root.writeTree(inserter);
    }

    InMemoryNoteBucket getRoot() {
        return this.root;
    }

    private void load(ObjectId rootTree) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        AbbreviatedObjectId none = AbbreviatedObjectId.fromString("");
        this.root = NoteParser.parse(none, rootTree, this.reader);
    }
}

