/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.BlockRevQueue;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;

class DepthGenerator
extends Generator {
    private final FIFORevQueue pending = new FIFORevQueue();
    private final int depth;
    private final RevWalk walk;
    private final RevFlag UNSHALLOW;
    private final RevFlag REINTERESTING;

    DepthGenerator(DepthWalk w, Generator s2) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c;
        this.walk = (RevWalk)((Object)w);
        this.depth = w.getDepth();
        this.UNSHALLOW = w.getUnshallowFlag();
        this.REINTERESTING = w.getReinterestingFlag();
        s2.shareFreeList(this.pending);
        while ((c = s2.next()) != null) {
            if (((DepthWalk.Commit)c).getDepth() != 0) continue;
            this.pending.add(c);
        }
    }

    @Override
    int outputType() {
        return this.pending.outputType() | 0x10;
    }

    @Override
    void shareFreeList(BlockRevQueue q) {
        this.pending.shareFreeList(q);
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        DepthWalk.Commit c;
        boolean produce2;
        do {
            if ((c = (DepthWalk.Commit)this.pending.next()) == null) {
                return null;
            }
            if ((c.flags & 1) == 0) {
                c.parseHeaders(this.walk);
            }
            int newDepth = c.depth + 1;
            for (RevCommit p : c.parents) {
                DepthWalk.Commit dp = (DepthWalk.Commit)p;
                if (dp.depth == -1) {
                    dp.depth = newDepth;
                    if (newDepth <= this.depth) {
                        this.pending.add(p);
                    }
                }
                if (!c.has(this.UNSHALLOW) && !c.has(this.REINTERESTING)) continue;
                p.add(this.REINTERESTING);
                p.flags &= 0xFFFFFFFB;
            }
            boolean bl = produce2 = c.depth <= this.depth;
            if ((c.flags & 4) == 0 || c.has(this.UNSHALLOW)) continue;
            produce2 = false;
        } while (!produce2);
        return c;
    }
}

