/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class OrRevFilter
extends RevFilter {
    public static RevFilter create(RevFilter a, RevFilter b) {
        if (a == ALL || b == ALL) {
            return ALL;
        }
        return new Binary(a, b);
    }

    public static RevFilter create(RevFilter[] list2) {
        if (list2.length == 2) {
            return OrRevFilter.create(list2[0], list2[1]);
        }
        if (list2.length < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        RevFilter[] subfilters = new RevFilter[list2.length];
        System.arraycopy(list2, 0, subfilters, 0, list2.length);
        return new List(subfilters);
    }

    public static RevFilter create(Collection<RevFilter> list2) {
        if (list2.size() < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        RevFilter[] subfilters = new RevFilter[list2.size()];
        list2.toArray(subfilters);
        if (subfilters.length == 2) {
            return OrRevFilter.create(subfilters[0], subfilters[1]);
        }
        return new List(subfilters);
    }

    private static class Binary
    extends OrRevFilter {
        private final RevFilter a;
        private final RevFilter b;
        private final boolean requiresCommitBody;

        Binary(RevFilter one, RevFilter two) {
            this.a = one;
            this.b = two;
            this.requiresCommitBody = this.a.requiresCommitBody() || this.b.requiresCommitBody();
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.a.include(walker, c) || this.b.include(walker, c);
        }

        @Override
        public boolean requiresCommitBody() {
            return this.requiresCommitBody;
        }

        @Override
        public RevFilter clone() {
            return new Binary(this.a.clone(), this.b.clone());
        }

        @Override
        public String toString() {
            return "(" + this.a.toString() + " OR " + this.b.toString() + ")";
        }
    }

    private static class List
    extends OrRevFilter {
        private final RevFilter[] subfilters;
        private final boolean requiresCommitBody;

        List(RevFilter[] list2) {
            this.subfilters = list2;
            boolean rcb = false;
            for (RevFilter filter2 : this.subfilters) {
                rcb |= filter2.requiresCommitBody();
            }
            this.requiresCommitBody = rcb;
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            for (RevFilter f : this.subfilters) {
                if (!f.include(walker, c)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean requiresCommitBody() {
            return this.requiresCommitBody;
        }

        @Override
        public RevFilter clone() {
            RevFilter[] s2 = new RevFilter[this.subfilters.length];
            for (int i = 0; i < s2.length; ++i) {
                s2[i] = this.subfilters[i].clone();
            }
            return new List(s2);
        }

        @Override
        public String toString() {
            StringBuilder r = new StringBuilder();
            r.append("(");
            for (int i = 0; i < this.subfilters.length; ++i) {
                if (i > 0) {
                    r.append(" OR ");
                }
                r.append(this.subfilters[i].toString());
            }
            r.append(")");
            return r.toString();
        }
    }
}

