/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.Serializable;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Ref;

public class RefSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String WILDCARD_SUFFIX = "/*";
    private boolean force;
    private boolean wildcard;
    private WildcardMode allowMismatchedWildcards;
    private String srcName;
    private String dstName;

    public static boolean isWildcard(String s2) {
        return s2 != null && s2.contains("*");
    }

    public RefSpec() {
        this.force = false;
        this.wildcard = false;
        this.srcName = "HEAD";
        this.dstName = null;
        this.allowMismatchedWildcards = WildcardMode.REQUIRE_MATCH;
    }

    public RefSpec(String spec, WildcardMode mode) {
        int c;
        this.allowMismatchedWildcards = mode;
        String s2 = spec;
        if (s2.startsWith("+")) {
            this.force = true;
            s2 = s2.substring(1);
        }
        if ((c = s2.lastIndexOf(58)) == 0) {
            if (RefSpec.isWildcard(s2 = s2.substring(1))) {
                this.wildcard = true;
                if (mode == WildcardMode.REQUIRE_MATCH) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidWildcards, spec));
                }
            }
            this.dstName = RefSpec.checkValid(s2);
        } else if (c > 0) {
            String src = s2.substring(0, c);
            String dst = s2.substring(c + 1);
            if (RefSpec.isWildcard(src) && RefSpec.isWildcard(dst)) {
                this.wildcard = true;
            } else if (RefSpec.isWildcard(src) || RefSpec.isWildcard(dst)) {
                this.wildcard = true;
                if (mode == WildcardMode.REQUIRE_MATCH) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidWildcards, spec));
                }
            }
            this.srcName = RefSpec.checkValid(src);
            this.dstName = RefSpec.checkValid(dst);
        } else {
            if (RefSpec.isWildcard(s2)) {
                if (mode == WildcardMode.REQUIRE_MATCH) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidWildcards, spec));
                }
                this.wildcard = true;
            }
            this.srcName = RefSpec.checkValid(s2);
        }
    }

    public RefSpec(String spec) {
        this(spec, WildcardMode.REQUIRE_MATCH);
    }

    private RefSpec(RefSpec p) {
        this.force = p.isForceUpdate();
        this.wildcard = p.isWildcard();
        this.srcName = p.getSource();
        this.dstName = p.getDestination();
        this.allowMismatchedWildcards = p.allowMismatchedWildcards;
    }

    public boolean isForceUpdate() {
        return this.force;
    }

    public RefSpec setForceUpdate(boolean forceUpdate) {
        RefSpec r = new RefSpec(this);
        r.force = forceUpdate;
        return r;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public String getSource() {
        return this.srcName;
    }

    public RefSpec setSource(String source) {
        RefSpec r = new RefSpec(this);
        r.srcName = RefSpec.checkValid(source);
        if (RefSpec.isWildcard(r.srcName) && r.dstName == null) {
            throw new IllegalStateException(JGitText.get().destinationIsNotAWildcard);
        }
        if (RefSpec.isWildcard(r.srcName) != RefSpec.isWildcard(r.dstName)) {
            throw new IllegalStateException(JGitText.get().sourceDestinationMustMatch);
        }
        return r;
    }

    public String getDestination() {
        return this.dstName;
    }

    public RefSpec setDestination(String destination) {
        RefSpec r = new RefSpec(this);
        r.dstName = RefSpec.checkValid(destination);
        if (RefSpec.isWildcard(r.dstName) && r.srcName == null) {
            throw new IllegalStateException(JGitText.get().sourceIsNotAWildcard);
        }
        if (RefSpec.isWildcard(r.srcName) != RefSpec.isWildcard(r.dstName)) {
            throw new IllegalStateException(JGitText.get().sourceDestinationMustMatch);
        }
        return r;
    }

    public RefSpec setSourceDestination(String source, String destination) {
        if (RefSpec.isWildcard(source) != RefSpec.isWildcard(destination)) {
            throw new IllegalStateException(JGitText.get().sourceDestinationMustMatch);
        }
        RefSpec r = new RefSpec(this);
        r.wildcard = RefSpec.isWildcard(source);
        r.srcName = source;
        r.dstName = destination;
        return r;
    }

    public boolean matchSource(String r) {
        return this.match(r, this.getSource());
    }

    public boolean matchSource(Ref r) {
        return this.match(r.getName(), this.getSource());
    }

    public boolean matchDestination(String r) {
        return this.match(r, this.getDestination());
    }

    public boolean matchDestination(Ref r) {
        return this.match(r.getName(), this.getDestination());
    }

    public RefSpec expandFromSource(String r) {
        if (this.allowMismatchedWildcards != WildcardMode.REQUIRE_MATCH) {
            throw new IllegalStateException(JGitText.get().invalidExpandWildcard);
        }
        return this.isWildcard() ? new RefSpec(this).expandFromSourceImp(r) : this;
    }

    private RefSpec expandFromSourceImp(String name) {
        String psrc = this.srcName;
        String pdst = this.dstName;
        this.wildcard = false;
        this.srcName = name;
        this.dstName = RefSpec.expandWildcard(name, psrc, pdst);
        return this;
    }

    public RefSpec expandFromSource(Ref r) {
        return this.expandFromSource(r.getName());
    }

    public RefSpec expandFromDestination(String r) {
        if (this.allowMismatchedWildcards != WildcardMode.REQUIRE_MATCH) {
            throw new IllegalStateException(JGitText.get().invalidExpandWildcard);
        }
        return this.isWildcard() ? new RefSpec(this).expandFromDstImp(r) : this;
    }

    private RefSpec expandFromDstImp(String name) {
        String psrc = this.srcName;
        String pdst = this.dstName;
        this.wildcard = false;
        this.srcName = RefSpec.expandWildcard(name, pdst, psrc);
        this.dstName = name;
        return this;
    }

    public RefSpec expandFromDestination(Ref r) {
        return this.expandFromDestination(r.getName());
    }

    private boolean match(String name, String s2) {
        if (s2 == null) {
            return false;
        }
        if (RefSpec.isWildcard(s2)) {
            int wildcardIndex = s2.indexOf(42);
            String prefix = s2.substring(0, wildcardIndex);
            String suffix = s2.substring(wildcardIndex + 1);
            return name.length() > prefix.length() + suffix.length() && name.startsWith(prefix) && name.endsWith(suffix);
        }
        return name.equals(s2);
    }

    private static String expandWildcard(String name, String patternA, String patternB) {
        int a = patternA.indexOf(42);
        int trailingA = patternA.length() - (a + 1);
        int b = patternB.indexOf(42);
        String match = name.substring(a, name.length() - trailingA);
        return patternB.substring(0, b) + match + patternB.substring(b + 1);
    }

    private static String checkValid(String spec) {
        if (spec != null && !RefSpec.isValid(spec)) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidRefSpec, spec));
        }
        return spec;
    }

    private static boolean isValid(String s2) {
        if (s2.startsWith("/")) {
            return false;
        }
        if (s2.contains("//")) {
            return false;
        }
        if (s2.endsWith("/")) {
            return false;
        }
        int i = s2.indexOf(42);
        return i == -1 || s2.indexOf(42, i + 1) <= i;
    }

    public int hashCode() {
        int hc = 0;
        if (this.getSource() != null) {
            hc = hc * 31 + this.getSource().hashCode();
        }
        if (this.getDestination() != null) {
            hc = hc * 31 + this.getDestination().hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof RefSpec)) {
            return false;
        }
        RefSpec b = (RefSpec)obj2;
        if (this.isForceUpdate() != b.isForceUpdate()) {
            return false;
        }
        if (this.isWildcard() != b.isWildcard()) {
            return false;
        }
        if (!RefSpec.eq(this.getSource(), b.getSource())) {
            return false;
        }
        return RefSpec.eq(this.getDestination(), b.getDestination());
    }

    private static boolean eq(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        if (this.isForceUpdate()) {
            r.append('+');
        }
        if (this.getSource() != null) {
            r.append(this.getSource());
        }
        if (this.getDestination() != null) {
            r.append(':');
            r.append(this.getDestination());
        }
        return r.toString();
    }

    public static enum WildcardMode {
        REQUIRE_MATCH,
        ALLOW_MISMATCH;

    }
}

