/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;

public abstract class TransportProtocol {
    public abstract String getName();

    public Set<String> getSchemes() {
        return Collections.emptySet();
    }

    public Set<URIishField> getRequiredFields() {
        return Collections.unmodifiableSet(EnumSet.of(URIishField.PATH));
    }

    public Set<URIishField> getOptionalFields() {
        return Collections.emptySet();
    }

    public int getDefaultPort() {
        return -1;
    }

    public boolean canHandle(URIish uri) {
        return this.canHandle(uri, null, null);
    }

    public boolean canHandle(URIish uri, Repository local2, String remoteName) {
        if (!this.getSchemes().isEmpty() && !this.getSchemes().contains(uri.getScheme())) {
            return false;
        }
        block7: for (URIishField field2 : this.getRequiredFields()) {
            switch (field2) {
                case USER: {
                    if (uri.getUser() != null && uri.getUser().length() != 0) continue block7;
                    return false;
                }
                case PASS: {
                    if (uri.getPass() != null && uri.getPass().length() != 0) continue block7;
                    return false;
                }
                case HOST: {
                    if (uri.getHost() != null && uri.getHost().length() != 0) continue block7;
                    return false;
                }
                case PORT: {
                    if (uri.getPort() > 0) continue block7;
                    return false;
                }
                case PATH: {
                    if (uri.getPath() != null && uri.getPath().length() != 0) continue block7;
                    return false;
                }
            }
            return false;
        }
        EnumSet<URIishField> canHave = EnumSet.copyOf(this.getRequiredFields());
        canHave.addAll(this.getOptionalFields());
        if (uri.getUser() != null && !canHave.contains((Object)URIishField.USER)) {
            return false;
        }
        if (uri.getPass() != null && !canHave.contains((Object)URIishField.PASS)) {
            return false;
        }
        if (uri.getHost() != null && !canHave.contains((Object)URIishField.HOST)) {
            return false;
        }
        if (uri.getPort() > 0 && !canHave.contains((Object)URIishField.PORT)) {
            return false;
        }
        return uri.getPath() == null || canHave.contains((Object)URIishField.PATH);
    }

    public abstract Transport open(URIish var1, Repository var2, String var3) throws NotSupportedException, TransportException;

    public Transport open(URIish uri) throws NotSupportedException, TransportException {
        throw new NotSupportedException(JGitText.get().transportNeedsRepository);
    }

    public static enum URIishField {
        USER,
        PASS,
        HOST,
        PORT,
        PATH;

    }
}

