/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.BitSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;

public class URIish
implements Serializable {
    private static final String SCHEME_P = "([a-z][a-z0-9+-]+)://";
    private static final String OPT_USER_PWD_P = "(?:([^/:]+)(?::([^\\\\/]+))?@)?";
    private static final String HOST_P = "((?:[^\\\\/:]+)|(?:\\[[0-9a-f:]+\\]))";
    private static final String OPT_PORT_P = "(?::(\\d+))?";
    private static final String USER_HOME_P = "(?:/~(?:[^\\\\/]+))";
    private static final String OPT_DRIVE_LETTER_P = "(?:[A-Za-z]:)?";
    private static final String RELATIVE_PATH_P = "(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*)";
    private static final String PATH_P = "((?:[A-Za-z]:)?[\\\\/]?(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*))";
    private static final long serialVersionUID = 1L;
    private static final Pattern FULL_URI = Pattern.compile("^([a-z][a-z0-9+-]+)://(?:(?:([^/:]+)(?::([^\\\\/]+))?@)?((?:[^\\\\/:]+)|(?:\\[[0-9a-f:]+\\]))(?::(\\d+))?((?:/~(?:[^\\\\/]+))?(?:[\\\\/])|$))?(.+)?$");
    private static final Pattern LOCAL_FILE = Pattern.compile("^([\\\\/]?((?:[A-Za-z]:)?[\\\\/]?(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*)))$");
    private static final Pattern SINGLE_SLASH_FILE_URI = Pattern.compile("^(file):([\\\\/](?![\\\\/])((?:[A-Za-z]:)?[\\\\/]?(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*)))$");
    private static final Pattern RELATIVE_SCP_URI = Pattern.compile("^(?:([^/:]+)(?::([^\\\\/]+))?@)?((?:[^\\\\/:]+)|(?:\\[[0-9a-f:]+\\])):((?:(?:/~(?:[^\\\\/]+))[\\\\/])?(?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*))$");
    private static final Pattern ABSOLUTE_SCP_URI = Pattern.compile("^(?:([^/:]+)(?::([^\\\\/]+))?@)?([^\\\\/:]{2,}):([\\\\/](?:(?:[^\\\\/]+[\\\\/]+)*[^\\\\/]+[\\\\/]*))$");
    private String scheme;
    private String path;
    private String rawPath;
    private String user;
    private String pass;
    private int port = -1;
    private String host;
    private static final BitSet reservedChars = new BitSet(127);

    public URIish(String s2) throws URISyntaxException {
        if (StringUtils.isEmptyOrNull(s2)) {
            throw new URISyntaxException("The uri was empty or null", JGitText.get().cannotParseGitURIish);
        }
        Matcher matcher = SINGLE_SLASH_FILE_URI.matcher(s2);
        if (matcher.matches()) {
            this.scheme = matcher.group(1);
            this.rawPath = this.cleanLeadingSlashes(matcher.group(2), this.scheme);
            this.path = URIish.unescape(this.rawPath);
            return;
        }
        matcher = FULL_URI.matcher(s2);
        if (matcher.matches()) {
            this.scheme = matcher.group(1);
            this.user = URIish.unescape(matcher.group(2));
            this.pass = URIish.unescape(matcher.group(3));
            this.host = URIish.unescape(matcher.group(4));
            if (matcher.group(5) != null) {
                this.port = Integer.parseInt(matcher.group(5));
            }
            this.rawPath = this.cleanLeadingSlashes(this.n2e(matcher.group(6)) + this.n2e(matcher.group(7)), this.scheme);
            this.path = URIish.unescape(this.rawPath);
            return;
        }
        matcher = RELATIVE_SCP_URI.matcher(s2);
        if (matcher.matches()) {
            this.user = matcher.group(1);
            this.pass = matcher.group(2);
            this.host = matcher.group(3);
            this.path = this.rawPath = matcher.group(4);
            return;
        }
        matcher = ABSOLUTE_SCP_URI.matcher(s2);
        if (matcher.matches()) {
            this.user = matcher.group(1);
            this.pass = matcher.group(2);
            this.host = matcher.group(3);
            this.path = this.rawPath = matcher.group(4);
            return;
        }
        matcher = LOCAL_FILE.matcher(s2);
        if (matcher.matches()) {
            this.path = this.rawPath = matcher.group(1);
            return;
        }
        throw new URISyntaxException(s2, JGitText.get().cannotParseGitURIish);
    }

    private static int parseHexByte(byte c1, byte c2) {
        return RawParseUtils.parseHexInt4(c1) << 4 | RawParseUtils.parseHexInt4(c2);
    }

    private static String unescape(String s2) throws URISyntaxException {
        byte[] bytes2;
        if (s2 == null) {
            return null;
        }
        if (s2.indexOf(37) < 0) {
            return s2;
        }
        try {
            bytes2 = s2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        byte[] os = new byte[bytes2.length];
        int j = 0;
        for (int i = 0; i < bytes2.length; ++i) {
            byte c = bytes2[i];
            if (c == 37) {
                int val;
                if (i + 2 >= bytes2.length) {
                    throw new URISyntaxException(s2, JGitText.get().cannotParseGitURIish);
                }
                byte c1 = bytes2[i + 1];
                byte c2 = bytes2[i + 2];
                try {
                    val = URIish.parseHexByte(c1, c2);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new URISyntaxException(s2, JGitText.get().cannotParseGitURIish);
                }
                os[j++] = (byte)val;
                i += 2;
                continue;
            }
            os[j++] = c;
        }
        return RawParseUtils.decode(os, 0, j);
    }

    private static String escape(String s2, boolean escapeReservedChars, boolean encodeNonAscii) {
        byte[] bytes2;
        if (s2 == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(s2.length());
        try {
            bytes2 = s2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < bytes2.length; ++i) {
            int b = bytes2[i] & 0xFF;
            if (b <= 32 || encodeNonAscii && b > 127 || b == 37 || escapeReservedChars && reservedChars.get(b)) {
                os.write(37);
                byte[] tmp = Constants.encodeASCII(String.format("%02x", b));
                os.write(tmp[0]);
                os.write(tmp[1]);
                continue;
            }
            os.write(b);
        }
        byte[] buf = os.toByteArray();
        return RawParseUtils.decode(buf, 0, buf.length);
    }

    private String n2e(String s2) {
        if (s2 == null) {
            return "";
        }
        return s2;
    }

    private String cleanLeadingSlashes(String p, String s2) {
        if (p.length() >= 3 && p.charAt(0) == '/' && p.charAt(2) == ':' && (p.charAt(1) >= 'A' && p.charAt(1) <= 'Z' || p.charAt(1) >= 'a' && p.charAt(1) <= 'z')) {
            return p.substring(1);
        }
        if (s2 != null && p.length() >= 2 && p.charAt(0) == '/' && p.charAt(1) == '~') {
            return p.substring(1);
        }
        return p;
    }

    public URIish(URL u) {
        this.scheme = u.getProtocol();
        this.path = u.getPath();
        this.path = this.cleanLeadingSlashes(this.path, this.scheme);
        try {
            this.rawPath = u.toURI().getRawPath();
            this.rawPath = this.cleanLeadingSlashes(this.rawPath, this.scheme);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String ui = u.getUserInfo();
        if (ui != null) {
            int d = ui.indexOf(58);
            this.user = d < 0 ? ui : ui.substring(0, d);
            this.pass = d < 0 ? null : ui.substring(d + 1);
        }
        this.port = u.getPort();
        this.host = u.getHost();
    }

    public URIish() {
    }

    private URIish(URIish u) {
        this.scheme = u.scheme;
        this.rawPath = u.rawPath;
        this.path = u.path;
        this.user = u.user;
        this.pass = u.pass;
        this.port = u.port;
        this.host = u.host;
    }

    public boolean isRemote() {
        return this.getHost() != null;
    }

    public String getHost() {
        return this.host;
    }

    public URIish setHost(String n) {
        URIish r = new URIish(this);
        r.host = n;
        return r;
    }

    public String getScheme() {
        return this.scheme;
    }

    public URIish setScheme(String n) {
        URIish r = new URIish(this);
        r.scheme = n;
        return r;
    }

    public String getPath() {
        return this.path;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public URIish setPath(String n) {
        URIish r = new URIish(this);
        r.path = n;
        r.rawPath = n;
        return r;
    }

    public URIish setRawPath(String n) throws URISyntaxException {
        URIish r = new URIish(this);
        r.path = URIish.unescape(n);
        r.rawPath = n;
        return r;
    }

    public String getUser() {
        return this.user;
    }

    public URIish setUser(String n) {
        URIish r = new URIish(this);
        r.user = n;
        return r;
    }

    public String getPass() {
        return this.pass;
    }

    public URIish setPass(String n) {
        URIish r = new URIish(this);
        r.pass = n;
        return r;
    }

    public int getPort() {
        return this.port;
    }

    public URIish setPort(int n) {
        URIish r = new URIish(this);
        r.port = n > 0 ? n : -1;
        return r;
    }

    public int hashCode() {
        int hc = 0;
        if (this.getScheme() != null) {
            hc = hc * 31 + this.getScheme().hashCode();
        }
        if (this.getUser() != null) {
            hc = hc * 31 + this.getUser().hashCode();
        }
        if (this.getPass() != null) {
            hc = hc * 31 + this.getPass().hashCode();
        }
        if (this.getHost() != null) {
            hc = hc * 31 + this.getHost().hashCode();
        }
        if (this.getPort() > 0) {
            hc = hc * 31 + this.getPort();
        }
        if (this.getPath() != null) {
            hc = hc * 31 + this.getPath().hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof URIish)) {
            return false;
        }
        URIish b = (URIish)obj2;
        if (!URIish.eq(this.getScheme(), b.getScheme())) {
            return false;
        }
        if (!URIish.eq(this.getUser(), b.getUser())) {
            return false;
        }
        if (!URIish.eq(this.getPass(), b.getPass())) {
            return false;
        }
        if (!URIish.eq(this.getHost(), b.getHost())) {
            return false;
        }
        if (this.getPort() != b.getPort()) {
            return false;
        }
        return URIish.eq(this.getPath(), b.getPath());
    }

    private static boolean eq(String a, String b) {
        if (a == b) {
            return true;
        }
        if (StringUtils.isEmptyOrNull(a) && StringUtils.isEmptyOrNull(b)) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public String toPrivateString() {
        return this.format(true, false);
    }

    public String toString() {
        return this.format(false, false);
    }

    private String format(boolean includePassword, boolean escapeNonAscii) {
        StringBuilder r = new StringBuilder();
        if (this.getScheme() != null) {
            r.append(this.getScheme());
            r.append("://");
        }
        if (this.getUser() != null) {
            r.append(URIish.escape(this.getUser(), true, escapeNonAscii));
            if (includePassword && this.getPass() != null) {
                r.append(':');
                r.append(URIish.escape(this.getPass(), true, escapeNonAscii));
            }
        }
        if (this.getHost() != null) {
            if (this.getUser() != null && this.getUser().length() > 0) {
                r.append('@');
            }
            r.append(URIish.escape(this.getHost(), false, escapeNonAscii));
            if (this.getScheme() != null && this.getPort() > 0) {
                r.append(':');
                r.append(this.getPort());
            }
        }
        if (this.getPath() != null) {
            if (this.getScheme() != null) {
                if (!this.getPath().startsWith("/") && !this.getPath().isEmpty()) {
                    r.append('/');
                }
            } else if (this.getHost() != null) {
                r.append(':');
            }
            if (this.getScheme() != null) {
                if (escapeNonAscii) {
                    r.append(URIish.escape(this.getPath(), false, escapeNonAscii));
                } else {
                    r.append(this.getRawPath());
                }
            } else {
                r.append(this.getPath());
            }
        }
        return r.toString();
    }

    public String toASCIIString() {
        return this.format(false, true);
    }

    public String toPrivateASCIIString() {
        return this.format(true, true);
    }

    public String getHumanishName() throws IllegalArgumentException {
        String s2 = this.getPath();
        if ("/".equals(s2) || "".equals(s2)) {
            s2 = this.getHost();
        }
        if (s2 == null) {
            throw new IllegalArgumentException();
        }
        String[] elements = "file".equals(this.scheme) || LOCAL_FILE.matcher(s2).matches() ? s2.split("[\\" + File.separatorChar + "/]") : s2.split("/+");
        if (elements.length == 0) {
            throw new IllegalArgumentException();
        }
        String result2 = elements[elements.length - 1];
        if (".git".equals(result2)) {
            result2 = elements[elements.length - 2];
        } else if (result2.endsWith(".git")) {
            result2 = result2.substring(0, result2.length() - ".git".length());
        }
        return result2;
    }

    static {
        for (byte b : Constants.encodeASCII("!*'();:@&=+$,/?#[]")) {
            reservedChars.set(b);
        }
    }
}

