/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public abstract class OrTreeFilter
extends TreeFilter {
    public static TreeFilter create(TreeFilter a, TreeFilter b) {
        if (a == ALL || b == ALL) {
            return ALL;
        }
        return new Binary(a, b);
    }

    public static TreeFilter create(TreeFilter[] list2) {
        if (list2.length == 2) {
            return OrTreeFilter.create(list2[0], list2[1]);
        }
        if (list2.length < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        TreeFilter[] subfilters = new TreeFilter[list2.length];
        System.arraycopy(list2, 0, subfilters, 0, list2.length);
        return new List(subfilters);
    }

    public static TreeFilter create(Collection<TreeFilter> list2) {
        if (list2.size() < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        TreeFilter[] subfilters = new TreeFilter[list2.size()];
        list2.toArray(subfilters);
        if (subfilters.length == 2) {
            return OrTreeFilter.create(subfilters[0], subfilters[1]);
        }
        return new List(subfilters);
    }

    private static class Binary
    extends OrTreeFilter {
        private final TreeFilter a;
        private final TreeFilter b;

        Binary(TreeFilter one, TreeFilter two) {
            this.a = one;
            this.b = two;
        }

        @Override
        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.matchFilter(walker) <= 0;
        }

        @Override
        public int matchFilter(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            int ra = this.a.matchFilter(walker);
            if (ra == 0) {
                return 0;
            }
            int rb = this.b.matchFilter(walker);
            if (rb == 0) {
                return 0;
            }
            if (ra == -1 || rb == -1) {
                return -1;
            }
            return 1;
        }

        @Override
        public boolean shouldBeRecursive() {
            return this.a.shouldBeRecursive() || this.b.shouldBeRecursive();
        }

        @Override
        public TreeFilter clone() {
            return new Binary(this.a.clone(), this.b.clone());
        }

        @Override
        public String toString() {
            return "(" + this.a.toString() + " OR " + this.b.toString() + ")";
        }
    }

    private static class List
    extends OrTreeFilter {
        private final TreeFilter[] subfilters;

        List(TreeFilter[] list2) {
            this.subfilters = list2;
        }

        @Override
        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.matchFilter(walker) <= 0;
        }

        @Override
        public int matchFilter(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            int m = 1;
            for (TreeFilter f : this.subfilters) {
                int r = f.matchFilter(walker);
                if (r == 0) {
                    return 0;
                }
                if (r != -1) continue;
                m = -1;
            }
            return m;
        }

        @Override
        public boolean shouldBeRecursive() {
            for (TreeFilter f : this.subfilters) {
                if (!f.shouldBeRecursive()) continue;
                return true;
            }
            return false;
        }

        @Override
        public TreeFilter clone() {
            TreeFilter[] s2 = new TreeFilter[this.subfilters.length];
            for (int i = 0; i < s2.length; ++i) {
                s2[i] = this.subfilters[i].clone();
            }
            return new List(s2);
        }

        @Override
        public String toString() {
            StringBuilder r = new StringBuilder();
            r.append("(");
            for (int i = 0; i < this.subfilters.length; ++i) {
                if (i > 0) {
                    r.append(" OR ");
                }
                r.append(this.subfilters[i].toString());
            }
            r.append(")");
            return r.toString();
        }
    }
}

