/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.SystemReader;

public class GitDateParser {
    public static final Date NEVER = new Date(Long.MAX_VALUE);
    private static ThreadLocal<Map<Locale, Map<ParseableSimpleDateFormat, SimpleDateFormat>>> formatCache = new ThreadLocal<Map<Locale, Map<ParseableSimpleDateFormat, SimpleDateFormat>>>(){

        @Override
        protected Map<Locale, Map<ParseableSimpleDateFormat, SimpleDateFormat>> initialValue() {
            return new HashMap<Locale, Map<ParseableSimpleDateFormat, SimpleDateFormat>>();
        }
    };

    private static SimpleDateFormat getDateFormat(ParseableSimpleDateFormat f, Locale locale) {
        Map<Locale, Map<ParseableSimpleDateFormat, SimpleDateFormat>> cache = formatCache.get();
        Map<ParseableSimpleDateFormat, SimpleDateFormat> map23 = cache.get(locale);
        if (map23 == null) {
            map23 = new HashMap<ParseableSimpleDateFormat, SimpleDateFormat>();
            cache.put(locale, map23);
            return GitDateParser.getNewSimpleDateFormat(f, locale, map23);
        }
        SimpleDateFormat dateFormat = map23.get((Object)f);
        if (dateFormat != null) {
            return dateFormat;
        }
        SimpleDateFormat df = GitDateParser.getNewSimpleDateFormat(f, locale, map23);
        return df;
    }

    private static SimpleDateFormat getNewSimpleDateFormat(ParseableSimpleDateFormat f, Locale locale, Map<ParseableSimpleDateFormat, SimpleDateFormat> map23) {
        SimpleDateFormat df = SystemReader.getInstance().getSimpleDateFormat(f.formatStr, locale);
        map23.put(f, df);
        return df;
    }

    public static Date parse(String dateStr, Calendar now) throws ParseException {
        return GitDateParser.parse(dateStr, now, Locale.getDefault());
    }

    public static Date parse(String dateStr, Calendar now, Locale locale) throws ParseException {
        if ("never".equalsIgnoreCase(dateStr = dateStr.trim())) {
            return NEVER;
        }
        Date ret = GitDateParser.parse_relative(dateStr, now);
        if (ret != null) {
            return ret;
        }
        for (ParseableSimpleDateFormat f : ParseableSimpleDateFormat.values()) {
            try {
                return GitDateParser.parse_simple(dateStr, f, locale);
            }
            catch (ParseException parseException) {
            }
        }
        ParseableSimpleDateFormat[] values = ParseableSimpleDateFormat.values();
        StringBuilder allFormats = new StringBuilder("\"").append(values[0].formatStr);
        for (int i = 1; i < values.length; ++i) {
            allFormats.append("\", \"").append(values[i].formatStr);
        }
        allFormats.append("\"");
        throw new ParseException(MessageFormat.format(JGitText.get().cannotParseDate, dateStr, allFormats.toString()), 0);
    }

    private static Date parse_simple(String dateStr, ParseableSimpleDateFormat f, Locale locale) throws ParseException {
        SimpleDateFormat dateFormat = GitDateParser.getDateFormat(f, locale);
        dateFormat.setLenient(false);
        return dateFormat.parse(dateStr);
    }

    private static Date parse_relative(String dateStr, Calendar now) {
        Calendar cal;
        SystemReader sysRead = SystemReader.getInstance();
        if ("now".equals(dateStr)) {
            return now == null ? new Date(sysRead.getCurrentTime()) : now.getTime();
        }
        if (now == null) {
            cal = new GregorianCalendar(sysRead.getTimeZone(), sysRead.getLocale());
            cal.setTimeInMillis(sysRead.getCurrentTime());
        } else {
            cal = (Calendar)now.clone();
        }
        if ("yesterday".equals(dateStr)) {
            cal.add(5, -1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        String[] parts = dateStr.split("\\.| ");
        int partsLength = parts.length;
        if (partsLength < 3 || (partsLength & 1) == 0 || !"ago".equals(parts[parts.length - 1])) {
            return null;
        }
        for (int i = 0; i < parts.length - 2; i += 2) {
            int number;
            try {
                number = Integer.parseInt(parts[i]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if ("year".equals(parts[i + 1]) || "years".equals(parts[i + 1])) {
                cal.add(1, -number);
                continue;
            }
            if ("month".equals(parts[i + 1]) || "months".equals(parts[i + 1])) {
                cal.add(2, -number);
                continue;
            }
            if ("week".equals(parts[i + 1]) || "weeks".equals(parts[i + 1])) {
                cal.add(3, -number);
                continue;
            }
            if ("day".equals(parts[i + 1]) || "days".equals(parts[i + 1])) {
                cal.add(5, -number);
                continue;
            }
            if ("hour".equals(parts[i + 1]) || "hours".equals(parts[i + 1])) {
                cal.add(11, -number);
                continue;
            }
            if ("minute".equals(parts[i + 1]) || "minutes".equals(parts[i + 1])) {
                cal.add(12, -number);
                continue;
            }
            if ("second".equals(parts[i + 1]) || "seconds".equals(parts[i + 1])) {
                cal.add(13, -number);
                continue;
            }
            return null;
        }
        return cal.getTime();
    }

    static enum ParseableSimpleDateFormat {
        ISO("yyyy-MM-dd HH:mm:ss Z"),
        RFC("EEE, dd MMM yyyy HH:mm:ss Z"),
        SHORT("yyyy-MM-dd"),
        SHORT_WITH_DOTS_REVERSE("dd.MM.yyyy"),
        SHORT_WITH_DOTS("yyyy.MM.dd"),
        SHORT_WITH_SLASH("MM/dd/yyyy"),
        DEFAULT("EEE MMM dd HH:mm:ss yyyy Z"),
        LOCAL("EEE MMM dd HH:mm:ss yyyy");

        String formatStr;

        private ParseableSimpleDateFormat(String formatStr) {
            this.formatStr = formatStr;
        }
    }
}

