/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.convert.RenameHandler;
import org.joda.convert.Types;

final class TypeUtils {
    private static final String EXTENDS = "? extends ";
    private static final String SUPER = "? super ";
    private static final Map<String, Class<?>> PRIMITIVES;

    private TypeUtils() {
    }

    static Type parse(String str) {
        try {
            return TypeUtils.doParse(str);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Type doParse(String str) throws Exception {
        Class<?> token = PRIMITIVES.get(str);
        if (token != null) {
            return token;
        }
        int first2 = str.indexOf(60);
        if (first2 < 0) {
            return RenameHandler.INSTANCE.loadType(str);
        }
        int last2 = str.lastIndexOf(62);
        String baseStr = str.substring(0, first2);
        Class<?> base2 = RenameHandler.INSTANCE.loadType(baseStr);
        String argsStr = str.substring(first2 + 1, last2);
        List<String> splitArgs = TypeUtils.split(argsStr);
        ArrayList types = new ArrayList();
        for (String splitArg : splitArgs) {
            Class<?> componentCls;
            String componentStr;
            Class<?> argType;
            String remainder;
            if (splitArg.startsWith(EXTENDS)) {
                remainder = splitArg.substring(EXTENDS.length());
                argType = TypeUtils.wildExtendsType(TypeUtils.doParse(remainder));
            } else if (splitArg.startsWith(SUPER)) {
                remainder = splitArg.substring(SUPER.length());
                argType = TypeUtils.wildSuperType(TypeUtils.doParse(remainder));
            } else if (splitArg.equals("?")) {
                argType = TypeUtils.wildExtendsType(Object.class);
            } else if (splitArg.endsWith("[]")) {
                componentStr = splitArg.substring(0, splitArg.length() - 2);
                componentCls = RenameHandler.INSTANCE.loadType(componentStr);
                argType = Array.newInstance(componentCls, 0).getClass();
            } else if (splitArg.startsWith("[L") && splitArg.endsWith(";")) {
                componentStr = splitArg.substring(2, splitArg.length() - 1);
                componentCls = RenameHandler.INSTANCE.loadType(componentStr);
                argType = Array.newInstance(componentCls, 0).getClass();
            } else {
                argType = TypeUtils.doParse(splitArg);
            }
            types.add(argType);
        }
        return TypeUtils.newParameterizedType(base2, types.toArray(new Type[types.size()]));
    }

    private static List<String> split(String str) {
        ArrayList<String> result2 = new ArrayList<String>();
        int genericCount = 0;
        int startPos = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ',' && genericCount == 0) {
                result2.add(str.substring(startPos, i).trim());
                startPos = i + 1;
                continue;
            }
            if (str.charAt(i) == '<') {
                ++genericCount;
                continue;
            }
            if (str.charAt(i) != '>') continue;
            --genericCount;
        }
        result2.add(str.substring(startPos).trim());
        return result2;
    }

    private static Type wildExtendsType(Type bound) throws Exception {
        return Types.subtypeOf(bound);
    }

    private static Type wildSuperType(Type bound) throws Exception {
        return Types.supertypeOf(bound);
    }

    private static ParameterizedType newParameterizedType(Class<?> base2, Type ... args) throws Exception {
        return Types.newParameterizedType(base2, args);
    }

    static {
        HashMap<String, Class<Serializable>> map23 = new HashMap<String, Class<Serializable>>();
        map23.put("byte", Byte.TYPE);
        map23.put("short", Short.TYPE);
        map23.put("int", Integer.TYPE);
        map23.put("long", Long.TYPE);
        map23.put("boolean", Boolean.TYPE);
        map23.put("char", Character.TYPE);
        map23.put("float", Float.TYPE);
        map23.put("double", Double.TYPE);
        PRIMITIVES = Collections.unmodifiableMap(map23);
    }
}

