/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert.factory;

import java.util.Arrays;
import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.TypedStringConverter;

public final class NumericArrayStringConverterFactory
implements StringConverterFactory {
    public static final StringConverterFactory INSTANCE = new NumericArrayStringConverterFactory();

    private NumericArrayStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        if (cls.isArray() && cls.getComponentType().isPrimitive()) {
            if (cls == long[].class) {
                return LongArrayStringConverter.INSTANCE;
            }
            if (cls == int[].class) {
                return IntArrayStringConverter.INSTANCE;
            }
            if (cls == short[].class) {
                return ShortArrayStringConverter.INSTANCE;
            }
            if (cls == double[].class) {
                return DoubleArrayStringConverter.INSTANCE;
            }
            if (cls == float[].class) {
                return FloatArrayStringConverter.INSTANCE;
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static enum FloatArrayStringConverter implements TypedStringConverter<float[]>
    {
        INSTANCE{

            @Override
            public String convertToString(float[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 8);
                buf.append(array[0]);
                for (int i = 1; i < array.length; ++i) {
                    buf.append(',').append(array[i]);
                }
                return buf.toString();
            }

            @Override
            public float[] convertFromString(Class<? extends float[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                int count2 = 0;
                int base2 = 0;
                int sep = str.indexOf(44);
                float[] array = new float[str.length() / 2 + 1];
                while (sep >= 0) {
                    array[count2++] = Float.parseFloat(str.substring(base2, sep));
                    base2 = sep + 1;
                    sep = str.indexOf(44, sep + 1);
                }
                array[count2++] = Float.parseFloat(str.substring(base2, str.length()));
                return Arrays.copyOf(array, count2);
            }

            @Override
            public Class<?> getEffectiveType() {
                return float[].class;
            }
        };

        private static final float[] EMPTY;

        static {
            EMPTY = new float[0];
        }
    }

    static enum DoubleArrayStringConverter implements TypedStringConverter<double[]>
    {
        INSTANCE{

            @Override
            public String convertToString(double[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 8);
                buf.append(array[0]);
                for (int i = 1; i < array.length; ++i) {
                    buf.append(',').append(array[i]);
                }
                return buf.toString();
            }

            @Override
            public double[] convertFromString(Class<? extends double[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                int count2 = 0;
                int base2 = 0;
                int sep = str.indexOf(44);
                double[] array = new double[str.length() / 2 + 1];
                while (sep >= 0) {
                    array[count2++] = Double.parseDouble(str.substring(base2, sep));
                    base2 = sep + 1;
                    sep = str.indexOf(44, sep + 1);
                }
                array[count2++] = Double.parseDouble(str.substring(base2, str.length()));
                return Arrays.copyOf(array, count2);
            }

            @Override
            public Class<?> getEffectiveType() {
                return double[].class;
            }
        };

        private static final double[] EMPTY;

        static {
            EMPTY = new double[0];
        }
    }

    static enum ShortArrayStringConverter implements TypedStringConverter<short[]>
    {
        INSTANCE{

            @Override
            public String convertToString(short[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 3);
                buf.append(array[0]);
                for (int i = 1; i < array.length; ++i) {
                    buf.append(',').append(array[i]);
                }
                return buf.toString();
            }

            @Override
            public short[] convertFromString(Class<? extends short[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                int count2 = 0;
                int base2 = 0;
                int sep = str.indexOf(44);
                short[] array = new short[str.length() / 2 + 1];
                while (sep >= 0) {
                    array[count2++] = Short.parseShort(str.substring(base2, sep));
                    base2 = sep + 1;
                    sep = str.indexOf(44, sep + 1);
                }
                array[count2++] = Short.parseShort(str.substring(base2, str.length()));
                return Arrays.copyOf(array, count2);
            }

            @Override
            public Class<?> getEffectiveType() {
                return short[].class;
            }
        };

        private static final short[] EMPTY;

        static {
            EMPTY = new short[0];
        }
    }

    static enum IntArrayStringConverter implements TypedStringConverter<int[]>
    {
        INSTANCE{

            @Override
            public String convertToString(int[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 6);
                buf.append(array[0]);
                for (int i = 1; i < array.length; ++i) {
                    buf.append(',').append(array[i]);
                }
                return buf.toString();
            }

            @Override
            public int[] convertFromString(Class<? extends int[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                int count2 = 0;
                int base2 = 0;
                int sep = str.indexOf(44);
                int[] array = new int[str.length() / 2 + 1];
                while (sep >= 0) {
                    array[count2++] = Integer.parseInt(str.substring(base2, sep));
                    base2 = sep + 1;
                    sep = str.indexOf(44, sep + 1);
                }
                array[count2++] = Integer.parseInt(str.substring(base2, str.length()));
                return Arrays.copyOf(array, count2);
            }

            @Override
            public Class<?> getEffectiveType() {
                return int[].class;
            }
        };

        private static final int[] EMPTY;

        static {
            EMPTY = new int[0];
        }
    }

    static enum LongArrayStringConverter implements TypedStringConverter<long[]>
    {
        INSTANCE{

            @Override
            public String convertToString(long[] array) {
                if (array.length == 0) {
                    return "";
                }
                StringBuilder buf = new StringBuilder(array.length * 8);
                buf.append(array[0]);
                for (int i = 1; i < array.length; ++i) {
                    buf.append(',').append(array[i]);
                }
                return buf.toString();
            }

            @Override
            public long[] convertFromString(Class<? extends long[]> cls, String str) {
                if (str.length() == 0) {
                    return EMPTY;
                }
                int count2 = 0;
                int base2 = 0;
                int sep = str.indexOf(44);
                long[] array = new long[str.length() / 2 + 1];
                while (sep >= 0) {
                    array[count2++] = Long.parseLong(str.substring(base2, sep));
                    base2 = sep + 1;
                    sep = str.indexOf(44, sep + 1);
                }
                array[count2++] = Long.parseLong(str.substring(base2, str.length()));
                return Arrays.copyOf(array, count2);
            }

            @Override
            public Class<?> getEffectiveType() {
                return long[].class;
            }
        };

        private static final long[] EMPTY;

        static {
            EMPTY = new long[0];
        }
    }
}

