/*
 * Decompiled with CFR 0.152.
 */
package scalaj.http;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLDecoder;
import java.net.URLEncoder;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import scalaj.http.Base64;
import scalaj.http.HttpOptions$;
import scalaj.http.Token;

public final class HttpConstants$ {
    public static final HttpConstants$ MODULE$;
    private final Regex CharsetRegex;
    private final Function2<HttpURLConnection, Object, BoxedUnit> setFixedLengthStreamingMode;
    private final String utf8;

    static {
        new HttpConstants$();
    }

    public Regex CharsetRegex() {
        return this.CharsetRegex;
    }

    public Seq<Function1<HttpURLConnection, BoxedUnit>> defaultOptions() {
        return (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{HttpOptions$.MODULE$.connTimeout(1000), HttpOptions$.MODULE$.readTimeout(5000), HttpOptions$.MODULE$.followRedirects(false)}));
    }

    public Function2<HttpURLConnection, Object, BoxedUnit> setFixedLengthStreamingMode() {
        return this.setFixedLengthStreamingMode;
    }

    public String urlEncode(String name, String charset) {
        return URLEncoder.encode(name, charset);
    }

    public String urlDecode(String name, String charset) {
        return URLDecoder.decode(name, charset);
    }

    public String base64(byte[] bytes2) {
        return new String(Base64.encode(bytes2));
    }

    public String base64(String in) {
        return this.base64(in.getBytes(this.utf8()));
    }

    public String basicAuthValue(String user, String password) {
        return new StringBuilder().append((Object)"Basic ").append((Object)this.base64(new StringBuilder().append((Object)user).append((Object)":").append((Object)password).toString())).toString();
    }

    public String toQs(Seq<Tuple2<String, String>> params2, String charset) {
        return ((TraversableOnce)params2.map(new Serializable(charset){
            public static final long serialVersionUID = 0L;
            private final String charset$2;

            public final String apply(Tuple2<String, String> p) {
                return new StringBuilder().append((Object)HttpConstants$.MODULE$.urlEncode(p._1(), this.charset$2)).append((Object)"=").append((Object)HttpConstants$.MODULE$.urlEncode(p._2(), this.charset$2)).toString();
            }
            {
                this.charset$2 = charset$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("&");
    }

    public String appendQs(String url, Seq<Tuple2<String, String>> params2, String charset) {
        return new StringBuilder().append((Object)url).append((Object)(params2.isEmpty() ? "" : new StringBuilder().append((Object)(url.contains("?") ? "&" : "?")).append((Object)this.toQs(params2, charset)).toString())).toString();
    }

    public String readString(InputStream is) {
        return this.readString(is, this.utf8());
    }

    public String readString(InputStream is, String charset) {
        String string2;
        if (is == null) {
            string2 = "";
        } else {
            InputStreamReader in = new InputStreamReader(is, charset);
            StringBuilder bos = new StringBuilder();
            char[] ba = new char[4096];
            this.readOnce$2(in, bos, ba);
            string2 = bos.toString();
        }
        return string2;
    }

    public byte[] readBytes(InputStream in) {
        byte[] byArray;
        if (in == null) {
            byArray = (byte[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Byte());
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] ba = new byte[4096];
            this.readOnce$3(in, bos, ba);
            byArray = bos.toByteArray();
        }
        return byArray;
    }

    public Seq<Tuple2<String, String>> readParams(InputStream in, String charset) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.readString(in, charset).split("&")).flatMap(new Serializable(charset){
            public static final long serialVersionUID = 0L;
            private final String charset$1;

            public final Iterable<Tuple2<String, String>> apply(String x$27) {
                Iterable<java.io.Serializable> iterable;
                String[] stringArray = x$27.split("=");
                Option<IndexedSeq<T>> option2 = Array$.MODULE$.unapplySeq(stringArray);
                if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0) {
                    String k = (String)((SeqLike)option2.get()).apply(0);
                    String v = (String)((SeqLike)option2.get()).apply(1);
                    iterable = Option$.MODULE$.option2Iterable(new Some<Tuple2<String, String>>(new Tuple2<String, String>(HttpConstants$.MODULE$.urlDecode(k, this.charset$1), HttpConstants$.MODULE$.urlDecode(v, this.charset$1))));
                } else {
                    iterable = Option$.MODULE$.option2Iterable(None$.MODULE$);
                }
                return iterable;
            }
            {
                this.charset$1 = charset$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toList();
    }

    public String readParams$default$2() {
        return this.utf8();
    }

    public Map<String, String> readParamMap(InputStream in, String charset) {
        return (Map)Predef$.MODULE$.Map().apply(this.readParams(in, charset));
    }

    public String readParamMap$default$2() {
        return this.utf8();
    }

    public Token readToken(InputStream in) {
        Map<String, String> params2 = this.readParamMap(in, this.readParamMap$default$2());
        return new Token((String)params2.apply("oauth_token"), (String)params2.apply("oauth_token_secret"));
    }

    public Proxy proxy(String host, int port, Proxy.Type proxyType) {
        return new Proxy(proxyType, new InetSocketAddress(host, port));
    }

    public Proxy.Type proxy$default$3() {
        return Proxy.Type.HTTP;
    }

    public String utf8() {
        return this.utf8;
    }

    private final Tuple2 liftedTree1$1(Class connClass$1) {
        Tuple2<Boolean, Method> tuple23;
        try {
            tuple23 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToBoolean(true)), connClass$1.getDeclaredMethod("setFixedLengthStreamingMode", Long.TYPE));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            tuple23 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToBoolean(false)), connClass$1.getDeclaredMethod("setFixedLengthStreamingMode", Integer.TYPE));
        }
        return tuple23;
    }

    private final void readOnce$2(InputStreamReader in$2, StringBuilder bos$1, char[] ba$1) {
        int len;
        do {
            java.io.Serializable serializable = (len = in$2.read(ba$1)) > 0 ? bos$1.appendAll(ba$1, 0, len) : BoxedUnit.UNIT;
        } while (len >= 0);
    }

    private final void readOnce$3(InputStream in$1, ByteArrayOutputStream bos$2, byte[] ba$2) {
        int len;
        do {
            if ((len = in$1.read(ba$2)) <= 0) continue;
            bos$2.write(ba$2, 0, len);
        } while (len >= 0);
    }

    private HttpConstants$() {
        MODULE$ = this;
        this.CharsetRegex = new Regex("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)", Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Class<HttpURLConnection> connClass = HttpURLConnection.class;
        Tuple2 tuple23 = this.liftedTree1$1(connClass);
        if (tuple23 != null) {
            Tuple2<Boolean, Method> tuple24;
            boolean isLong = tuple23._1$mcZ$sp();
            Method theMethod = (Method)tuple23._2();
            Tuple2<Boolean, Method> tuple25 = tuple24 = new Tuple2<Boolean, Method>(BoxesRunTime.boxToBoolean(isLong), theMethod);
            boolean isLong2 = tuple25._1$mcZ$sp();
            Method theMethod2 = tuple25._2();
            this.setFixedLengthStreamingMode = new Serializable(isLong2, theMethod2){
                public static final long serialVersionUID = 0L;
                private final boolean isLong$1;
                private final Method theMethod$1;

                public final void apply(HttpURLConnection conn, long length) {
                    if (this.isLong$1) {
                        this.theMethod$1.invoke((Object)conn, Predef$.MODULE$.long2Long(length));
                    } else {
                        if (length > Integer.MAX_VALUE) {
                            throw new RuntimeException("Failing attempt to upload file greater than 2GB on java version < 1.7");
                        }
                        this.theMethod$1.invoke((Object)conn, Predef$.MODULE$.int2Integer((int)length));
                    }
                }
                {
                    this.isLong$1 = isLong$1;
                    this.theMethod$1 = theMethod$1;
                }
            };
            this.utf8 = "UTF-8";
            return;
        }
        throw new MatchError(tuple23);
    }
}

