/*
 * Decompiled with CFR 0.152.
 */
package codacy.git;

import codacy.foundation.logging.context.ContextAwareLogger;
import codacy.foundation.logging.context.ContextLogging;
import codacy.foundation.logging.context.LogContext;
import codacy.foundation.logging.context.ProjectLogContext;
import codacy.git.GitCommandRunner;
import codacy.git.GitCommandRunner$FatalError$;
import codacy.git.GitCommandRunner$IndexLockError$;
import codacy.git.GitCommandRunner$UnadvertisedObjectRequest$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.CodingErrorAction;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.FileUtils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.io.Codec;
import scala.io.Codec$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.sys.process.Process;
import scala.sys.process.Process$;
import scala.sys.process.ProcessIO;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class GitCommandRunner$
implements ContextLogging {
    public static GitCommandRunner$ MODULE$;
    private final Codec codacy$git$GitCommandRunner$$codec;
    private transient ContextAwareLogger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new GitCommandRunner$();
    }

    private ContextAwareLogger logger$lzycompute() {
        GitCommandRunner$ gitCommandRunner$ = this;
        synchronized (gitCommandRunner$) {
            if (!this.bitmap$trans$0) {
                this.logger = ContextLogging.logger$((ContextLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public ContextAwareLogger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public <T> T exec(Seq<String> command, Option<File> directory, Option<Duration> timeout, T zero, Function2<T, String, T> fn, ProjectLogContext logContext) {
        return this.runBfs(command, directory, (Duration)timeout.getOrElse((Function0 & Serializable & scala.Serializable)() -> Duration$.MODULE$.Inf()), this.runBfs$default$4(), zero, fn, logContext);
    }

    public <T> Option<File> exec$default$2() {
        return None$.MODULE$;
    }

    public <T> Option<Duration> exec$default$3() {
        return None$.MODULE$;
    }

    public void execNoOutput(Seq<String> command, Option<File> directory, Option<Duration> timeout, ProjectLogContext logContext) {
        this.runBfs(command, directory, (Duration)timeout.getOrElse((Function0 & Serializable & scala.Serializable)() -> Duration$.MODULE$.Inf()), this.runBfs$default$4(), BoxedUnit.UNIT, (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> {
            GitCommandRunner$.$anonfun$execNoOutput$2(x$1, x$2);
            return BoxedUnit.UNIT;
        }, logContext);
    }

    public Option<File> execNoOutput$default$2() {
        return None$.MODULE$;
    }

    public Option<Duration> execNoOutput$default$3() {
        return None$.MODULE$;
    }

    public Codec codacy$git$GitCommandRunner$$codec() {
        return this.codacy$git$GitCommandRunner$$codec;
    }

    private Timer triggerTimeout(Process process, Duration timeout) {
        Timer timer;
        block0: {
            timer = new Timer();
            Duration duration = timeout;
            Duration.Infinite infinite = Duration$.MODULE$.Inf();
            if (!(duration == null ? infinite != null : !duration.equals(infinite))) break block0;
            timer.schedule(new TimerTask(process){
                private final Process process$1;

                public void run() {
                    Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.process$1.destroy());
                }
                {
                    this.process$1 = process$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(codacy.git.GitCommandRunner$$anon$1 )}, serializedLambda);
                }
            }, timeout.toMillis());
        }
        return timer;
    }

    private Option<GitCommandRunner.Error> parseStdErr(String line) {
        if (line.contains("index.lock")) {
            return new Some((Object)GitCommandRunner$IndexLockError$.MODULE$);
        }
        if (line.contains("fatal: Invalid symmetric difference expression")) {
            return new Some((Object)GitCommandRunner$FatalError$.MODULE$);
        }
        if (line.contains("Server does not allow request for unadvertised object")) {
            return new Some((Object)GitCommandRunner$UnadvertisedObjectRequest$.MODULE$);
        }
        return None$.MODULE$;
    }

    private <T> T runBfs(Seq<String> cmd, Option<File> dir, Duration timeout, int retries, T zero, Function2<T, String, T> fn, ProjectLogContext logContext) {
        int result;
        ObjectRef commandErrorText;
        String dirLog;
        String commandLog;
        while (true) {
            boolean bl;
            commandLog = cmd.mkString("`", " ", "`");
            dirLog = (String)dir.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getPath()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "N/A");
            this.logger().info(new StringBuilder(52).append("Executing git command: ").append(commandLog).append(", pwd: ").append(dirLog).append(", timeout: ").append(timeout).append(", retries: ").append(retries).toString(), (LogContext)logContext);
            ObjectRef commandResult = ObjectRef.create(zero);
            commandErrorText = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
            ObjectRef userCodeThrowable = ObjectRef.create((Object)Option$.MODULE$.empty());
            ProcessIO pio = new ProcessIO((Function1 & Serializable & scala.Serializable)writeInput -> {
                writeInput.close();
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)stdout -> {
                GitCommandRunner$.$anonfun$runBfs$4(commandResult, zero, fn, userCodeThrowable, stdout);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)stderr -> {
                GitCommandRunner$.$anonfun$runBfs$5(commandErrorText, stderr);
                return BoxedUnit.UNIT;
            });
            Process process = Process$.MODULE$.apply(cmd, dir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).run(pio);
            Timer timeoutTimer = this.triggerTimeout(process, timeout);
            result = process.exitValue();
            ((Option)userCodeThrowable.elem).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                throw x$4;
            });
            timeoutTimer.cancel();
            if (result == 0) {
                return (T)commandResult.elem;
            }
            this.logger().warn(new StringBuilder(33).append("Command failed: ").append(commandLog).append(", pwd: ").append(dirLog).append(", result: ").append(result).toString(), (LogContext)logContext);
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> process.destroy());
            Seq commandErrors = (Seq)((Seq)commandErrorText.elem).flatMap((Function1 & Serializable & scala.Serializable)line -> Option$.MODULE$.option2Iterable(MODULE$.parseStdErr((String)line)), Seq$.MODULE$.canBuildFrom());
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = bl = retries > 0;
            if (bl) {
                bl2 = true;
                bl3 = bl;
                if (commandErrors.contains((Object)GitCommandRunner$IndexLockError$.MODULE$)) {
                    this.logger().warn(new StringBuilder(86).append("IndexLockError error while executing command: ").append(commandLog).append(", pwd: ").append(dirLog).append(". ").append("Delete the lock file and retry.").toString(), (LogContext)logContext);
                    Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> FileUtils.forceDelete((File)new File(new StringBuilder(4).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)dir), File.separator)).append(".git").toString(), "index.lock")));
                    --retries;
                    continue;
                }
            }
            if (bl2 && commandErrors.contains((Object)GitCommandRunner$FatalError$.MODULE$)) {
                this.logger().warn(new StringBuilder(80).append("Fatal error while executing command: ").append(commandLog).append(", pwd: ").append(dirLog).append(". ").append("Run a recovery command and repeat.").toString(), (LogContext)logContext);
                Seq recoveryCmd = (Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"clean", (List)new .colon.colon((Object)"-dfx", (List)Nil$.MODULE$)));
                this.runBfs((Seq<String>)recoveryCmd, dir, timeout, 0, BoxedUnit.UNIT, (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> {
                    GitCommandRunner$.$anonfun$runBfs$10(x$5, x$6);
                    return BoxedUnit.UNIT;
                }, logContext);
                --retries;
                continue;
            }
            if (!bl2 || !commandErrors.contains((Object)GitCommandRunner$UnadvertisedObjectRequest$.MODULE$)) break;
            this.logger().warn(new StringBuilder(72).append("UnadvertisedObjectRequest error while executing command: ").append(commandLog).append(", pwd: ").append(dirLog).append(". Retry.").toString(), (LogContext)logContext);
            --retries;
        }
        ((Seq)commandErrorText.elem).foreach((Function1 & Serializable & scala.Serializable)line -> {
            GitCommandRunner$.$anonfun$runBfs$11(logContext, line);
            return BoxedUnit.UNIT;
        });
        String errorStr = new StringBuilder(40).append("Error running command: ").append(commandLog).append(", pwd: ").append(dirLog).append(", result: ").append(result).toString();
        this.logger().error(errorStr, (LogContext)logContext);
        throw new Exception(errorStr);
    }

    private <T> int runBfs$default$4() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$execNoOutput$2(BoxedUnit x$1, String x$2) {
    }

    public static final /* synthetic */ void $anonfun$runBfs$4(ObjectRef commandResult$1, Object zero$1, Function2 fn$1, ObjectRef userCodeThrowable$1, InputStream stdout) {
        block6: {
            GitCommandRunner.OnlyNewLineBufferedSource buffSource = new GitCommandRunner.OnlyNewLineBufferedSource(stdout);
            try {
                try {
                    commandResult$1.elem = buffSource.getLines().foldLeft(zero$1, fn$1);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        userCodeThrowable$1.elem = new Some((Object)e);
                        break block6;
                    }
                    throw throwable;
                }
            }
            finally {
                stdout.close();
            }
        }
    }

    public static final /* synthetic */ void $anonfun$runBfs$5(ObjectRef commandErrorText$1, InputStream stderr) {
        GitCommandRunner.OnlyNewLineBufferedSource buffSource = new GitCommandRunner.OnlyNewLineBufferedSource(stderr);
        commandErrorText$1.elem = buffSource.getLines().toList();
        stderr.close();
    }

    public static final /* synthetic */ void $anonfun$runBfs$10(BoxedUnit x$5, String x$6) {
    }

    public static final /* synthetic */ void $anonfun$runBfs$11(ProjectLogContext logContext$1, String line) {
        MODULE$.logger().error(line, (LogContext)logContext$1);
    }

    /*
     * WARNING - void declaration
     */
    private GitCommandRunner$() {
        void var1_1;
        MODULE$ = this;
        ContextLogging.$init$((ContextLogging)this);
        Codec codec0 = Codec$.MODULE$.UTF8();
        codec0.onMalformedInput(CodingErrorAction.IGNORE);
        codec0.onUnmappableCharacter(CodingErrorAction.IGNORE);
        this.codacy$git$GitCommandRunner$$codec = var1_1;
    }
}

