/*
 * Decompiled with CFR 0.152.
 */
package codacy.git.authentication;

import codacy.foundation.logging.context.ContextAwareLogger;
import codacy.foundation.logging.context.ContextLogging;
import codacy.foundation.logging.context.LogContext;
import codacy.foundation.logging.context.ProjectLogContext;
import codacy.git.repository.GitRepositoryDefinition;
import codacy.git.repository.GitRepositoryDefinition$;
import codacy.git.repository.ProjectRequest;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import play.api.libs.json.Json$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class SSHAuthenticationWrapper$
implements ContextLogging {
    public static SSHAuthenticationWrapper$ MODULE$;
    private transient ContextAwareLogger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SSHAuthenticationWrapper$();
    }

    private ContextAwareLogger logger$lzycompute() {
        SSHAuthenticationWrapper$ sSHAuthenticationWrapper$ = this;
        synchronized (sSHAuthenticationWrapper$) {
            if (!this.bitmap$trans$0) {
                this.logger = ContextLogging.logger$((ContextLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public ContextAwareLogger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Seq<String> wrap(ProjectRequest projectRequest, String command, String repositoryKeysLocation, ProjectLogContext logContext) {
        String keyFile2 = Integer.toString(projectRequest.hashCode());
        String pkeyAddCommand = (String)this.parseProjectData(projectRequest.data().value()).flatMap((Function1 & Serializable & scala.Serializable)rep -> MODULE$.writeConfigFile(repositoryKeysLocation, keyFile2, rep.privateKey(), logContext)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)keyFile -> new StringBuilder(21).append("ssh-add ").append(keyFile.getAbsolutePath()).append(" &>/dev/null;").toString());
        return (Seq)new .colon.colon((Object)"ssh-agent", (List)new .colon.colon((Object)"bash", (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)new StringBuilder(3).append("(").append(pkeyAddCommand).append(" ").append(command).append(")").toString(), (List)Nil$.MODULE$))));
    }

    private Option<File> writeConfigFile(String path, String name, String content, ProjectLogContext logContext) {
        Failure failure;
        Throwable throwable;
        Option option;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            MODULE$.logger().info("Processing config file", (LogContext)logContext);
            File sourceFolder = new File(path);
            Object object2 = !sourceFolder.exists() ? BoxesRunTime.boxToBoolean((boolean)sourceFolder.mkdirs()) : BoxedUnit.UNIT;
            File file = new File(sourceFolder, name);
            if (!file.exists()) {
                MODULE$.logger().info("Writing a config file", (LogContext)logContext);
                FileWriter fw = new FileWriter(file);
                fw.write(content);
                fw.flush();
                fw.close();
                file.setReadable(false, false);
                file.setReadable(true);
                file.setWritable(false, false);
                object = BoxesRunTime.boxToBoolean((boolean)file.setWritable(true));
            } else {
                object = BoxedUnit.UNIT;
            }
            MODULE$.logger().info("Config file processed", (LogContext)logContext);
            return new Some((Object)file);
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Some file = (Some)success.value();
            return file;
        }
        if (try_ instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)try_).exception())).isEmpty()) {
            Throwable e = (Throwable)option.get();
            this.logger().error(new StringBuilder(24).append("Error writing key file: ").append(name).toString(), e, (LogContext)logContext);
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    public Seq<String> commandWithKey(String projectData, String command, String repositoryKeysLocation, ProjectLogContext logContext) {
        String keyFile2 = Integer.toString(projectData.hashCode());
        String pkeyAddCommand = (String)this.parseProjectData(projectData).flatMap((Function1 & Serializable & scala.Serializable)rep -> MODULE$.writeConfigFile(repositoryKeysLocation, keyFile2, rep.privateKey(), logContext)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)keyFile -> new StringBuilder(21).append("ssh-add ").append(keyFile.getAbsolutePath()).append(" &>/dev/null;").toString());
        return (Seq)new .colon.colon((Object)"ssh-agent", (List)new .colon.colon((Object)"bash", (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)new StringBuilder(3).append("(").append(pkeyAddCommand).append(" ").append(command).append(")").toString(), (List)Nil$.MODULE$))));
    }

    public Option<GitRepositoryDefinition> parseProjectData(String json) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Json$.MODULE$.parse(json).asOpt(GitRepositoryDefinition$.MODULE$.gitRepositoryDefinitionFmt())).toOption().flatten(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)repDef -> new GitRepositoryDefinition(repDef.publicKey(), repDef.privateKey()));
    }

    private SSHAuthenticationWrapper$() {
        MODULE$ = this;
        ContextLogging.$init$((ContextLogging)this);
    }
}

