/*
 * Decompiled with CFR 0.152.
 */
package codacy.git.repository;

import codacy.foundation.crypto.CryptoTools$;
import codacy.foundation.logging.context.ContextAwareLogger;
import codacy.foundation.logging.context.ContextLogging;
import codacy.foundation.logging.context.LogContext;
import codacy.foundation.logging.context.ProjectLogContext;
import codacy.foundation.utils.InputValidation$;
import codacy.git.GitCommandRunner$;
import codacy.git.authentication.SSHAuthenticationWrapper$;
import codacy.git.authentication.TokenAuthenticationWrapper$;
import codacy.git.diff.CommitDiff;
import codacy.git.repository.AccessTokenRepositoryData;
import codacy.git.repository.BranchRequest;
import codacy.git.repository.CommitRequest;
import codacy.git.repository.EmptyRepositoryData$;
import codacy.git.repository.GitCommit;
import codacy.git.repository.GitCommitWithIndex;
import codacy.git.repository.GitFile;
import codacy.git.repository.GitFileContents;
import codacy.git.repository.GitFileContents$;
import codacy.git.repository.GitListResult;
import codacy.git.repository.GitListResult$;
import codacy.git.repository.GitRepository$;
import codacy.git.repository.ProjectRequest;
import codacy.git.repository.RepositoryData;
import codacy.git.repository.RepositoryUrlHelper$;
import codacy.git.repository.SshRepositoryData;
import codacy.utils.FileOperations$;
import codacy.utils.FileSystemLocks;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015e!\u0002'N\u0003\u0003!\u0006\u0002C6\u0001\u0005\u000b\u0007I\u0011\u00017\t\u0011a\u0004!\u0011!Q\u0001\n5D\u0001\"\u001f\u0001\u0003\u0006\u0004%\t\u0001\u001c\u0005\tu\u0002\u0011\t\u0011)A\u0005[\")1\u0010\u0001C\u0001y\"A\u00111\u0001\u0001\u0005\u00125\u000b)\u0001C\u0004\u0002$\u0001!\t\"\u00147\t\u0011\u0005\u0015\u0002A\"\u0005P\u0003OA!\"a\u001e\u0001#\u0003%\tbTA=\u0011\u001d\t\u0019\n\u0001D\u0001\u0003+Cq!!*\u0001\t#\t9\u000bC\u0004\u0002&\u0002!\t\"a3\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\"9\u00111\u001e\u0001\u0005\u0002\u00055\bb\u0002B\u0001\u0001\u0011\u0005!1\u0001\u0005\n\u0005[\u0001\u0011\u0013!C\u0001\u0005_AqA!\u0001\u0001\t\u0003\u0011\u0019\u0004C\u0004\u0003\u0002\u0001!\tAa\u0012\t\u000f\tU\u0003\u0001\"\u0001\u0003X!9!\u0011\u000e\u0001\u0005\u0002\t-\u0004b\u0002B;\u0001\u0011%!q\u000f\u0005\t\u0005\u007f\u0002A\u0011A(\u0003\u0002\"9!q\u0011\u0001\u0005\u0002\t%\u0005b\u0002BP\u0001\u0011%!\u0011\u0015\u0005\b\u0005_\u0003A\u0011\u0003BY\u0011\u001d\u0011i\f\u0001C\u0005\u0005\u007fCqA!4\u0001\t\u0003\u0011y\rC\u0005\u0003f\u0002\t\n\u0011\"\u0001\u00030!9!q\u001d\u0001\u0005\u0002\t%\bb\u0002B\u0000\u0001\u0011\u00051\u0011\u0001\u0005\b\u0007O\u0001A\u0011AB\u0015\u0011\u001d\u00199\u0004\u0001C\u0001\u0007sAqa!\u0014\u0001\t\u0003\u0019y\u0005C\u0004\u0004X\u0001!Ia!\u0017\t\u000f\r\u001d\u0004\u0001\"\u0003\u0004j!91q\u000b\u0001\u0005\n\rU\u0004bBBC\u0001\u0011%1q\u0011\u0005\b\u0005+\u0002A\u0011BBJ\u000f\u001d\u0019y*\u0014E\u0001\u0007C3a\u0001T'\t\u0002\r\r\u0006BB>)\t\u0003\u0019)\u000bC\u0005\u0004(\"\u0012\r\u0011\"\u0001\u0004*\"A1Q\u0017\u0015!\u0002\u0013\u0019Y\u000bC\u0005\u00048\"\u0012\r\u0011\"\u0001\u0004*\"A1\u0011\u0018\u0015!\u0002\u0013\u0019Y\u000bC\u0005\u0004<\"\u0012\r\u0011\"\u0001\u0004*\"A1Q\u0018\u0015!\u0002\u0013\u0019Y\u000b\u0003\u0005\u0004@\"\u0012\r\u0011\"\u0001m\u0011\u001d\u0019\t\r\u000bQ\u0001\n5D\u0011ba1)\u0005\u0004%Ia!2\t\u0011\r]\u0007\u0006)A\u0005\u0007\u000fD\u0011b!7)\u0005\u0004%Iaa7\t\u0011\r}\u0007\u0006)A\u0005\u0007;D\u0011b!9)\u0005\u0004%Iaa7\t\u0011\r\r\b\u0006)A\u0005\u0007;D!b!:)\u0011\u000b\u0007I\u0011BBn\u0011\u001d\u00199\u000f\u000bC\u0005\u0007SD1b!=)\u0011\u000b\u0007I\u0011A(\u0004F\"A11\u001f\u0015\u0005\u0002=\u001b)\u0010\u0003\u0005\u0004|\"\"\taTB\u007f\u0011\u001d!\t\u0001\u000bC\u0005\t\u0007Aq\u0001b\u0003)\t\u0013!i\u0001C\u0004\u0005\u0016!\"\t\u0002b\u0006\t\u0011\u0011\u001d\u0002\u0006\"\u0001P\tSA!\u0002\"\u000f)#\u0003%\ta\u0014C\u001e\u0011!\u00119\t\u000bC\u0001\u001f\u0012}\u0002\u0002\u0003C$Q\u0011\u0005q\n\"\u0013\t\u0013\u0011U\u0003F1A\u0005\u0006\r\u0015\u0007\u0002\u0003C,Q\u0001\u0006iaa2\t\u0013\u0011e\u0003F1A\u0005\u0006\r\u0015\u0007\u0002\u0003C.Q\u0001\u0006iaa2\t\u0011\u0011u\u0003\u0006\"\u0001P\t?B\u0011\u0002\"\u001d)\u0005\u0004%I\u0001b\u001d\t\u0011\u0011U\u0004\u0006)A\u0005\u0005OAq\u0001b\u001e)\t\u0013!IHA\u0007HSR\u0014V\r]8tSR|'/\u001f\u0006\u0003\u001d>\u000b!B]3q_NLGo\u001c:z\u0015\t\u0001\u0016+A\u0002hSRT\u0011AU\u0001\u0007G>$\u0017mY=\u0004\u0001M!\u0001!V.f!\t1\u0016,D\u0001X\u0015\u0005A\u0016!B:dC2\f\u0017B\u0001.X\u0005\u0019\te.\u001f*fMB\u0011AlY\u0007\u0002;*\u0011alX\u0001\bG>tG/\u001a=u\u0015\t\u0001\u0017-A\u0004m_\u001e<\u0017N\\4\u000b\u0005\t\f\u0016A\u00034pk:$\u0017\r^5p]&\u0011A-\u0018\u0002\u000f\u0007>tG/\u001a=u\u0019><w-\u001b8h!\t1\u0017.D\u0001h\u0015\tA\u0017+A\u0003vi&d7/\u0003\u0002kO\nya)\u001b7f'f\u001cH/Z7M_\u000e\\7/\u0001\fsKB|7/\u001b;pef\\U-_:M_\u000e\fG/[8o+\u0005i\u0007C\u00018v\u001d\ty7\u000f\u0005\u0002q/6\t\u0011O\u0003\u0002s'\u00061AH]8pizJ!\u0001^,\u0002\rA\u0013X\rZ3g\u0013\t1xO\u0001\u0004TiJLgn\u001a\u0006\u0003i^\u000bqC]3q_NLGo\u001c:z\u0017\u0016L8\u000fT8dCRLwN\u001c\u0011\u0002%I,\u0007o\\:ji>\u0014\u0018\u0010T8dCRLwN\\\u0001\u0014e\u0016\u0004xn]5u_JLHj\\2bi&|g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tu|\u0018\u0011\u0001\t\u0003}\u0002i\u0011!\u0014\u0005\u0006W\u0016\u0001\r!\u001c\u0005\u0006s\u0016\u0001\r!\\\u0001\rG2|g.Z(qi&|gn\u001d\u000b\u0005\u0003\u000f\tI\u0002E\u0003\u0002\n\u0005MQN\u0004\u0003\u0002\f\u0005=ab\u00019\u0002\u000e%\t\u0001,C\u0002\u0002\u0012]\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0005]!aA*fc*\u0019\u0011\u0011C,\t\u000f\u0005ma\u00011\u0001\u0002\u001e\u0005I!/Z2veNLg/\u001a\t\u0004-\u0006}\u0011bAA\u0011/\n9!i\\8mK\u0006t\u0017A\u00039bi\"\u0004&/\u001a4jq\u0006qq/\u001b;i%\u0016\u0004xn]5u_JLX\u0003BA\u0015\u0003g!b!a\u000b\u0002j\u0005MD\u0003BA\u0017\u0003\u001f\"B!a\f\u0002FA!\u0011\u0011GA\u001a\u0019\u0001!q!!\u000e\t\u0005\u0004\t9DA\u0001U#\u0011\tI$a\u0010\u0011\u0007Y\u000bY$C\u0002\u0002>]\u0013qAT8uQ&tw\rE\u0002W\u0003\u0003J1!a\u0011X\u0005\r\te.\u001f\u0005\b\u0003\u000fB\u00019AA%\u0003)awnZ\"p]R,\u0007\u0010\u001e\t\u00049\u0006-\u0013bAA';\n\t\u0002K]8kK\u000e$Hj\\4D_:$X\r\u001f;\t\u000f\u0005E\u0003\u00021\u0001\u0002T\u0005)!\r\\8dWB9a+!\u0016\u0002Z\u0005=\u0012bAA,/\nIa)\u001e8di&|g.\r\t\u0005\u00037\n)'\u0004\u0002\u0002^)!\u0011qLA1\u0003\tIwN\u0003\u0002\u0002d\u0005!!.\u0019<b\u0013\u0011\t9'!\u0018\u0003\t\u0019KG.\u001a\u0005\b\u0003WB\u0001\u0019AA7\u0003\u001d\u0001(o\u001c6fGR\u00042A`A8\u0013\r\t\t(\u0014\u0002\u000f!J|'.Z2u%\u0016\fX/Z:u\u0011%\t)\b\u0003I\u0001\u0002\u0004\ti\"A\u0006g_J\u001cW-\u00169eCR,\u0017\u0001G<ji\"\u0014V\r]8tSR|'/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU!\u00111PAI+\t\tiH\u000b\u0003\u0002\u001e\u0005}4FAAA!\u0011\t\u0019)!$\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0013\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-u+\u0001\u0006b]:|G/\u0019;j_:LA!a$\u0002\u0006\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\u0005U\u0012B1\u0001\u00028\u0005\u0001R\u000f\u001d3bi\u0016\u0014V\r]8tSR|'/\u001f\u000b\u0005\u0003/\u000b\t\u000b\u0006\u0003\u0002\u001a\u0006}\u0005c\u0001,\u0002\u001c&\u0019\u0011QT,\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u000fR\u00019AA%\u0011\u001d\t\u0019K\u0003a\u0001\u0003[\na\u0002\u001d:pU\u0016\u001cGOU3rk\u0016\u001cH/\u0001\nqk2d7\t[1oO\u0016\u001cxJ]\"m_:,G\u0003CAU\u0003\u007f\u000b\u0019-a2\u0015\r\u0005e\u00151VA_\u0011\u001d\tik\u0003a\u0002\u0003_\u000b\u0011\u0001\u001c\t\u0005\u0003c\u000b9LD\u0002g\u0003gK1!!.h\u0003=1\u0015\u000e\\3TsN$X-\u001c'pG.\u001c\u0018\u0002BA]\u0003w\u0013A\u0001T8dW*\u0019\u0011QW4\t\u000f\u0005\u001d3\u0002q\u0001\u0002J!9\u0011\u0011Y\u0006A\u0002\u00055\u0014A\u00039s_*,7\r\u001e*fc\"9\u0011QY\u0006A\u0002\u0005e\u0013A\u00039s_*,7\r\u001e#je\"9\u0011\u0011Z\u0006A\u0002\u0005u\u0011aD2m_:,7+\u001e2n_\u0012,H.Z:\u0015\u0015\u00055\u00171[Ak\u0003/\fI\u000e\u0006\u0004\u0002Z\u0005=\u0017\u0011\u001b\u0005\b\u0003[c\u00019AAX\u0011\u001d\t9\u0005\u0004a\u0002\u0003\u0013Bq!a\u001b\r\u0001\u0004\ti\u0007C\u0004\u0002F2\u0001\r!!\u0017\t\u000f\u0005UD\u00021\u0001\u0002\u001e!9\u0011\u0011\u001a\u0007A\u0002\u0005u\u0011!D2mK\u0006t\u0017I\u001c3DY>tW\r\u0006\u0005\u0002`\u0006\u0015\u0018q]Au)\u0019\tI*!9\u0002d\"9\u0011QV\u0007A\u0004\u0005=\u0006bBA$\u001b\u0001\u000f\u0011\u0011\n\u0005\b\u0003\u0003l\u0001\u0019AA7\u0011\u001d\t)-\u0004a\u0001\u00033Bq!!3\u000e\u0001\u0004\ti\"A\u0007hKR\fE\u000e\\\"p[6LGo\u001d\u000b\u0005\u0003_\fy\u0010\u0006\u0003\u0002r\u0006u\bCBA\u0005\u0003g\f90\u0003\u0003\u0002v\u0006]!\u0001\u0002'jgR\u00042A`A}\u0013\r\tY0\u0014\u0002\u0013\u000f&$8i\\7nSR<\u0016\u000e\u001e5J]\u0012,\u0007\u0010C\u0004\u0002H9\u0001\u001d!!\u0013\t\u000f\u0005-d\u00021\u0001\u0002n\u0005\u0001r-\u001a;Ce\u0006t7\r[\"p[6LGo\u001d\u000b\t\u0005\u000b\u0011\tBa\u0005\u0003\u001eQ!!q\u0001B\b!\u0019\tI!a=\u0003\nA\u0019aPa\u0003\n\u0007\t5QJA\u0005HSR\u001cu.\\7ji\"9\u0011qI\bA\u0004\u0005%\u0003bBA6\u001f\u0001\u0007\u0011Q\u000e\u0005\b\u0005+y\u0001\u0019\u0001B\f\u0003\u0019\u0011'/\u00198dQB\u0019aP!\u0007\n\u0007\tmQJA\u0007Ce\u0006t7\r\u001b*fcV,7\u000f\u001e\u0005\n\u0005?y\u0001\u0013!a\u0001\u0005C\tQ\u0001\\5nSR\u0004RA\u0016B\u0012\u0005OI1A!\nX\u0005\u0019y\u0005\u000f^5p]B\u0019aK!\u000b\n\u0007\t-rKA\u0002J]R\f!dZ3u\u0005J\fgn\u00195D_6l\u0017\u000e^:%I\u00164\u0017-\u001e7uIM*\"A!\r+\t\t\u0005\u0012q\u0010\u000b\t\u0005k\u0011\tEa\u0011\u0003FQ!!q\u0007B !\u0019\tI!a=\u0003:A\u0019aPa\u000f\n\u0007\tuRJA\u0007D_6l\u0017\u000e\u001e*fcV,7\u000f\u001e\u0005\b\u0003\u000f\n\u00029AA%\u0011\u001d\tY'\u0005a\u0001\u0003[BqA!\u0006\u0012\u0001\u0004\u00119\u0002C\u0004\u0003 E\u0001\rA!\u000f\u0015\r\t%#Q\nB()\u0011\u00119Aa\u0013\t\u000f\u0005\u001d#\u0003q\u0001\u0002J!9\u00111\u000e\nA\u0002\u00055\u0004b\u0002B)%\u0001\u0007!1K\u0001\tEJ\fgn\u00195fgB1\u0011\u0011BA\n\u0005/\t!CZ5oI\u000e{W.\\8o\u0003:\u001cWm\u001d;peRA!\u0011\fB0\u0005C\u0012)\u0007\u0006\u0003\u0003\\\tu\u0003#\u0002,\u0003$\te\u0002bBA$'\u0001\u000f\u0011\u0011\n\u0005\b\u0003W\u001a\u0002\u0019AA7\u0011\u001d\u0011\u0019g\u0005a\u0001\u0005/\taa]8ve\u000e,\u0007b\u0002B4'\u0001\u0007!qC\u0001\fI\u0016\u001cH/\u001b8bi&|g.A\bdY\u0016\fg\u000e\u0015:pU\u0016\u001cG\u000fR5s)\u0011\u0011iG!\u001d\u0015\t\u0005e%q\u000e\u0005\b\u0003\u000f\"\u00029AA%\u0011\u0019\u0011\u0019\b\u0006a\u0001[\u0006Q\u0001O]8kK\u000e$XK\u001d7\u0002%I,7M]3bi\u0016\u0004&o\u001c6fGR$\u0015N\u001d\u000b\u0005\u0005s\u0012i\b\u0006\u0003\u0002\u001a\nm\u0004bBA$+\u0001\u000f\u0011\u0011\n\u0005\b\u0003\u000b,\u0002\u0019AA-\u000399W\r\u001e)s_*,7\r\u001e)bi\"$B!!\u0017\u0003\u0004\"1!Q\u0011\fA\u00025\fA![;sY\u0006\u0019r-\u001a8fe\u0006$X\r\u0015:pU\u0016\u001cG\u000fR1uCR!!1\u0012BK)\u0011\u0011iIa%\u0011\u0007y\u0014y)C\u0002\u0003\u00126\u0013aBU3q_NLGo\u001c:z\t\u0006$\u0018\rC\u0004\u0002H]\u0001\u001d!!\u0013\t\u000f\t]u\u00031\u0001\u0003\u001a\u00061a/\u00197vKN\u0004RA\u001cBN[6L1A!(x\u0005\ri\u0015\r]\u0001\u001doJ\f\u0007oQ8n[\u0006tGmV5uQ\u0006+H\u000f[8sSj\fG/[8o)\u0019\u0011\u0019Ka*\u0003,R!\u0011q\u0001BS\u0011\u001d\t9\u0005\u0007a\u0002\u0003\u0013BqA!+\u0019\u0001\u0004\ti'A\u0004sKF,Xm\u001d;\t\u000f\t5\u0006\u00041\u0001\u0002\b\u0005Qq-\u001b;D_6l\u0017M\u001c3\u0002\u0017A,H\u000e\\\"iC:<Wm\u001d\u000b\u0007\u0005g\u00139La/\u0015\t\u0005e%Q\u0017\u0005\b\u0003\u000fJ\u00029AA%\u0011\u001d\u0011I,\u0007a\u0001\u00033\n1\u0001Z5s\u0011\u001d\u0011I+\u0007a\u0001\u0003[\nQa\u00197p]\u0016$\u0002B!1\u0003H\n%'1\u001a\u000b\u0007\u00033\u0013\u0019M!2\t\u000f\u00055&\u0004q\u0001\u00020\"9\u0011q\t\u000eA\u0004\u0005%\u0003b\u0002B]5\u0001\u0007\u0011\u0011\f\u0005\b\u0003WR\u0002\u0019AA7\u0011\u001d\tYB\u0007a\u0001\u0003;\t\u0011\u0002\\5ti\u001aKG.Z:\u0015\u0011\tE'1\u001cBo\u0005C$BAa5\u0003ZB\u0019aP!6\n\u0007\t]WJA\u0007HSRd\u0015n\u001d;SKN,H\u000e\u001e\u0005\b\u0003\u000fZ\u00029AA%\u0011\u001d\u0011Il\u0007a\u0001\u00033BaAa8\u001c\u0001\u0004i\u0017AB2p[6LG\u000fC\u0005\u0003dn\u0001\n\u00111\u0001\u0003\"\u0005\u0019R.\u0019=GS2,7+\u001b>f\u0005f$Xm](qi\u0006\u0019B.[:u\r&dWm\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005a1\r[1oO\u0016$g)\u001b7fgR1!1\u001eB}\u0005w$BA!<\u0003xB)!q\u001eB{[6\u0011!\u0011\u001f\u0006\u0004\u0005g<\u0016AC2pY2,7\r^5p]&!\u0011Q\u0003By\u0011\u001d\t9%\ba\u0002\u0003\u0013BqA!/\u001e\u0001\u0004\tI\u0006\u0003\u0004\u0003~v\u0001\r!\\\u0001\u000eGV\u0014(/\u001a8u\u0007>lW.\u001b;\u0002\u001b\u001d,GoQ8n[&$H)\u001b4g))\u0019\u0019aa\u0005\u0004\u0016\re1Q\u0004\u000b\u0005\u0007\u000b\u0019\t\u0002\u0005\u0003\u0004\b\r5QBAB\u0005\u0015\r\u0019YaT\u0001\u0005I&4g-\u0003\u0003\u0004\u0010\r%!AC\"p[6LG\u000fR5gM\"9\u0011q\t\u0010A\u0004\u0005%\u0003b\u0002B]=\u0001\u0007\u0011\u0011\f\u0005\b\u0007/q\u0002\u0019\u0001B\u001d\u00031\u0019x.\u001e:dK\u000e{W.\\5u\u0011\u001d\u0019YB\ba\u0001\u0003\u000f\t!\u0003Z3ti&t\u0017\r^5p]\u000e{W.\\5ug\"91q\u0004\u0010A\u0002\r\u0005\u0012aA:mMB!ana\tn\u0013\r\u0019)c\u001e\u0002\u0004'\u0016$\u0018AE4fiB+H\u000e\u001c*fcV,7\u000f\u001e#jM\u001a$\"ba\u000b\u00040\rE21GB\u001b)\u0011\u0019)a!\f\t\u000f\u0005\u001ds\u0004q\u0001\u0002J!9!\u0011X\u0010A\u0002\u0005e\u0003b\u0002B2?\u0001\u0007!\u0011\b\u0005\u0007\u0005Oz\u0002\u0019A7\t\u000f\r}q\u00041\u0001\u0004\"\u0005yq-\u001a;GS2,7i\u001c8uK:$8\u000f\u0006\u0005\u0004<\r\u00153qIB%)\u0011\u0019ida\u0011\u0011\u0007y\u001cy$C\u0002\u0004B5\u0013qbR5u\r&dWmQ8oi\u0016tGo\u001d\u0005\b\u0003\u000f\u0002\u00039AA%\u0011\u001d\u0011I\f\ta\u0001\u00033BqAa8!\u0001\u0004\u0011I\u0004\u0003\u0004\u0004L\u0001\u0002\r!\\\u0001\tM&dWM\\1nK\u0006qA.[:u\u00032d7i\\7nSR\u001cH\u0003BB)\u0007+\"B!!=\u0004T!9\u0011qI\u0011A\u0004\u0005%\u0003b\u0002B]C\u0001\u0007\u0011\u0011L\u0001\u0012Y&\u001cHO\u0011:b]\u000eD7i\\7nSR\u001cHCCB.\u0007?\u001a\tga\u0019\u0004fQ!!qAB/\u0011\u001d\t9E\ta\u0002\u0003\u0013BqA!/#\u0001\u0004\tI\u0006C\u0004\u0002l\t\u0002\r!!\u001c\t\u000f\tU!\u00051\u0001\u0003\u0018!9!q\u0004\u0012A\u0002\t\u0005\u0012a\u00057jgR\u0014%/\u00198dQ\u0016\u001c8i\\7nSR\u001cH\u0003CB6\u0007_\u001a\tha\u001d\u0015\t\t\u001d1Q\u000e\u0005\b\u0003\u000f\u001a\u00039AA%\u0011\u001d\u0011Il\ta\u0001\u00033Bq!a\u001b$\u0001\u0004\ti\u0007C\u0004\u0003R\r\u0002\rAa\u0015\u0015\u0015\r]41PB?\u0007\u007f\u001a\t\t\u0006\u0003\u00038\re\u0004bBA$I\u0001\u000f\u0011\u0011\n\u0005\b\u0005s#\u0003\u0019AA-\u0011\u001d\tY\u0007\na\u0001\u0003[BqA!\u0006%\u0001\u0004\u00119\u0002C\u0004\u0004\u0004\u0012\u0002\rA!\u000f\u0002\u00171LW.\u001b;D_6l\u0017\u000e^\u0001\u0013a\u0006\u00148/\u001a\"sC:\u001c\u0007nQ8n[&$8\u000f\u0006\u0004\u0004\n\u000e55\u0011\u0013\u000b\u0005\u0005\u000f\u0019Y\tC\u0004\u0002H\u0015\u0002\u001d!!\u0013\t\u000f\r=U\u00051\u0001\u0002\b\u00051An\\4D[\u0012DqA!/&\u0001\u0004\tI\u0006\u0006\u0005\u0004\u0016\u000ee51TBO)\u0011\u0011Yfa&\t\u000f\u0005\u001dc\u0005q\u0001\u0002J!9!\u0011\u0018\u0014A\u0002\u0005e\u0003b\u0002B2M\u0001\u0007!q\u0003\u0005\b\u0005O2\u0003\u0019\u0001B\f\u000359\u0015\u000e\u001e*fa>\u001c\u0018\u000e^8ssB\u0011a\u0010K\n\u0004QU[FCABQ\u0003!\u0001(\u000f\u0015:fM&DXCABV!\u0011\u0019ika-\u000e\u0005\r=&\u0002BBY\u0003C\nA\u0001\\1oO&\u0019aoa,\u0002\u0013A\u0014\bK]3gSb\u0004\u0013aA:fa\u0006!1/\u001a9!\u0003\r)w\u000e\\\u0001\u0005K>d\u0007%\u0001\u0007d_6l\u0017\u000e\u001e$pe6\fG/A\u0007d_6l\u0017\u000e\u001e$pe6\fG\u000fI\u0001\f\u0007>lW.\u001b;NCR\u001c\u0007.\u0006\u0002\u0004HB!1\u0011ZBj\u001b\t\u0019YM\u0003\u0003\u0004N\u000e=\u0017\u0001C7bi\u000eD\u0017N\\4\u000b\u0007\rEw+\u0001\u0003vi&d\u0017\u0002BBk\u0007\u0017\u0014QAU3hKb\fAbQ8n[&$X*\u0019;dQ\u0002\n\u0011\u0002Z5gM\u001ac\u0017mZ:\u0016\u0005\ru\u0007C\u0002Bx\u0005k\u001cY+\u0001\u0006eS\u001a4g\t\\1hg\u0002\n\u0011\u0003Z5gM\u000e{W.\\1oIB\u0013XMZ5y\u0003I!\u0017N\u001a4D_6l\u0017M\u001c3Qe\u00164\u0017\u000e\u001f\u0011\u0002\u0015\u0011LgM\u001a)sK\u001aL\u00070\u0001\u0006eS\u001a47+\u001e4gSb$Baa;\u0004nB)\u0011\u0011BAz[\"91q^\u001dA\u0002\r\u0005\u0012!\u00024jY\u0016\u001c\u0018aD$ji\u001aKG.\u001a*fgB|gn]3\u0002\u001d%\u001c8+_7c_2L7\rT5oWR!\u0011QDB|\u0011\u0019\u0019Ip\u000fa\u0001[\u0006\t1/\u0001\u0005jg\u000e{W.\\5u)\u0011\tiba@\t\r\reH\b1\u0001n\u0003}\tG\rZ(sS\u001eLgNU3gKJ,gnY3D_:4\u0017nZ;sCRLwN\u001c\u000b\u0005\t\u000b!I\u0001\u0006\u0003\u0002\u001a\u0012\u001d\u0001bBA${\u0001\u000f\u0011\u0011\n\u0005\b\u0005sk\u0004\u0019AA-\u0003\u0005\nG\rZ$ji\"+(\rU;mYJ+\u0017/^3ti\u000e{gNZ5hkJ\fG/[8o)\u0011!y\u0001b\u0005\u0015\t\u0005eE\u0011\u0003\u0005\b\u0003\u000fr\u00049AA%\u0011\u001d\u0011IL\u0010a\u0001\u00033\nA\"\u00193e\u000f&$8i\u001c8gS\u001e$\u0002\u0002\"\u0007\u0005\u001e\u0011}A1\u0005\u000b\u0005\u00033#Y\u0002C\u0004\u0002H}\u0002\u001d!!\u0013\t\u000f\tev\b1\u0001\u0002Z!1A\u0011E A\u00025\fAA\\1nK\"1AQE A\u00025\fQA^1mk\u0016\f1\"[:WC2LGMU3q_R1A1\u0006C\u0019\tg!B\u0001\"\f\u00050A)aKa\t\u0002\u001e!9\u0011q\t!A\u0004\u0005%\u0003b\u0002B]\u0001\u0002\u0007\u0011\u0011\f\u0005\n\tk\u0001\u0005\u0013!a\u0001\to\t!bY8n[&$X+^5e!\u00111&1E7\u0002+%\u001ch+\u00197jIJ+\u0007o\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011AQ\b\u0016\u0005\to\ty\b\u0006\u0003\u0005B\u0011\u0015C\u0003\u0002BG\t\u0007Bq!a\u0012C\u0001\b\tI\u0005C\u0004\u0003\u0018\n\u0003\rA!'\u0002\u001dA\f'o]3D_6l\u0017\u000e\u001e'pOR!A1\nC))\u0011!i\u0005b\u0014\u0011\u000bY\u0013\u0019C!\u0003\t\u000f\u0005\u001d3\tq\u0001\u0002J!1A1K\"A\u00025\f\u0011bY8n[&$Hj\\4\u0002\u0015\tc\u0017-\\3NCR\u001c\u0007.A\u0006CY\u0006lW-T1uG\"\u0004\u0013!\u0003$jY\u0016l\u0015\r^2i\u0003)1\u0015\u000e\\3NCR\u001c\u0007\u000eI\u0001\u000ba\u0006\u00148/\u001a\"mC6,GC\u0002C1\tS\"i\u0007E\u0003W\u0005G!\u0019\u0007E\u0002\u007f\tKJ1\u0001b\u001aN\u0005\u0015\u0011E.Y7f\u0011\u0019!Y\u0007\u0013a\u0001[\u0006Q!\r\\1nK2Kg.Z\u0019\t\r\u0011=\u0004\n1\u0001n\u0003)\u0011G.Y7f\u0019&tWMM\u0001\u000e\t&4g\rT5oK2KW.\u001b;\u0016\u0005\t\u001d\u0012A\u0004#jM\u001ad\u0015N\\3MS6LG\u000fI\u0001\u0014Kb,7-\u001e;f\u0003:$\u0007+\u0019:tK\u0012KgM\u001a\u000b\u0007\tw\"y\bb!\u0015\t\r\u0015AQ\u0010\u0005\b\u0003\u000fZ\u00059AA%\u0011\u001d!\ti\u0013a\u0001\u0003\u000f\t1\u0002Z5gM\u000e{W.\\1oI\"9!\u0011X&A\u0002\u0005e\u0003")
public abstract class GitRepository
implements FileSystemLocks {
    private final String repositoryKeysLocation;
    private final String repositoryLocation;
    private transient ContextAwareLogger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Regex FileMatch() {
        return GitRepository$.MODULE$.FileMatch();
    }

    public static Regex BlameMatch() {
        return GitRepository$.MODULE$.BlameMatch();
    }

    public static String commitFormat() {
        return GitRepository$.MODULE$.commitFormat();
    }

    public static String eol() {
        return GitRepository$.MODULE$.eol();
    }

    public static String sep() {
        return GitRepository$.MODULE$.sep();
    }

    public static String prPrefix() {
        return GitRepository$.MODULE$.prPrefix();
    }

    @Override
    public <A> A lock(File file, long maxTime, Function1<FileSystemLocks.Lock, A> method) {
        return (A)FileSystemLocks.lock$(this, file, maxTime, method);
    }

    @Override
    public <A> long lock$default$2() {
        return FileSystemLocks.lock$default$2$(this);
    }

    private ContextAwareLogger logger$lzycompute() {
        GitRepository gitRepository = this;
        synchronized (gitRepository) {
            if (!this.bitmap$trans$0) {
                this.logger = ContextLogging.logger$((ContextLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public ContextAwareLogger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String repositoryKeysLocation() {
        return this.repositoryKeysLocation;
    }

    public String repositoryLocation() {
        return this.repositoryLocation;
    }

    public Seq<String> cloneOptions(boolean recursive) {
        if (recursive) {
            return (Seq)new .colon.colon((Object)"--recursive", (List)Nil$.MODULE$);
        }
        return (Seq)Nil$.MODULE$;
    }

    public String pathPrefix() {
        return "p_";
    }

    public abstract <T> T withRepository(ProjectRequest var1, boolean var2, Function1<File, T> var3, ProjectLogContext var4);

    public <T> boolean withRepository$default$2() {
        return false;
    }

    public abstract void updateRepository(ProjectRequest var1, ProjectLogContext var2);

    public void pullChangesOrClone(ProjectRequest projectReq, File projectDir, boolean cloneSubmodules, FileSystemLocks.Lock l, ProjectLogContext logContext) {
        this.logger().info(new StringBuilder(52).append("Updating repository. (project: ").append(projectReq.url()).append(" ; cloneSubmodules: ").append(cloneSubmodules).append(")").toString(), (LogContext)logContext);
        Option<Object> isValidHeadRsp = GitRepository$.MODULE$.isValidRepo(projectDir, GitRepository$.MODULE$.isValidRepo$default$2(), logContext);
        boolean isValidHead = BoxesRunTime.unboxToBoolean((Object)isValidHeadRsp.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        if (isValidHead) {
            this.pullChanges(projectDir, projectReq, logContext);
            return;
        }
        this.cleanAndClone(projectReq, projectDir, cloneSubmodules, l, logContext);
    }

    public File pullChangesOrClone(ProjectRequest project, File projectDir, boolean forceUpdate, boolean cloneSubmodules, FileSystemLocks.Lock l, ProjectLogContext logContext) {
        block1: {
            Option<Object> isValidHeadRsp = GitRepository$.MODULE$.isValidRepo(projectDir, GitRepository$.MODULE$.isValidRepo$default$2(), logContext);
            boolean isValidHead = BoxesRunTime.unboxToBoolean((Object)isValidHeadRsp.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
            if (!isValidHead) {
                this.logger().debug(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(93).append("Forcing removal of HEAD ").append(projectDir.getAbsolutePath()).append(" under conditions:\n              |isValidRepo.value.get:").append(isValidHead).append("\n            ").toString())).stripMargin(), (LogContext)logContext);
                this.cleanAndClone(project, projectDir, cloneSubmodules, l, logContext);
                return projectDir;
            }
            if (!forceUpdate) break block1;
            this.pullChanges(projectDir, project, logContext);
        }
        return projectDir;
    }

    private void cleanAndClone(ProjectRequest projectReq, File projectDir, boolean cloneSubmodules, FileSystemLocks.Lock l, ProjectLogContext logContext) {
        this.recreateProjectDir(projectDir, logContext);
        try {
            this.clone(projectDir, projectReq, cloneSubmodules, l, logContext);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable err = (Throwable)option.get();
                this.recreateProjectDir(projectDir, logContext);
                throw err;
            }
            throw throwable;
        }
    }

    public List<GitCommitWithIndex> getAllCommits(ProjectRequest project, ProjectLogContext logContext) {
        return (List)this.logger().time(new StringBuilder(32).append("Getting all commits for project ").append(project.url()).toString(), this.logger().time$default$2(), this.logger().time$default$3(), (Function0 & Serializable & scala.Serializable)() -> (List)this.withRepository(project, this.withRepository$default$2(), (Function1 & Serializable & scala.Serializable)directory -> this.listAllCommits((File)directory, logContext), logContext), (LogContext)logContext);
    }

    public List<GitCommit> getBranchCommits(ProjectRequest project, BranchRequest branch, Option<Object> limit, ProjectLogContext logContext) {
        return (List)this.logger().time(new StringBuilder(38).append("Getting branch commits for project ").append(project.url()).append(" - ").append(branch.name()).toString(), this.logger().time$default$2(), this.logger().time$default$3(), (Function0 & Serializable & scala.Serializable)() -> (List)this.withRepository(project, this.withRepository$default$2(), (Function1 & Serializable & scala.Serializable)directory -> this.listBranchCommits((File)directory, project, branch, limit, logContext), logContext), (LogContext)logContext);
    }

    public List<CommitRequest> getBranchCommits(ProjectRequest project, BranchRequest branch, CommitRequest limit, ProjectLogContext logContext) {
        return (List)this.logger().time(new StringBuilder(38).append("Getting branch commits for project ").append(project.url()).append(" - ").append(branch.name()).toString(), this.logger().time$default$2(), this.logger().time$default$3(), (Function0 & Serializable & scala.Serializable)() -> (List)this.withRepository(project, this.withRepository$default$2(), (Function1 & Serializable & scala.Serializable)directory -> this.listBranchCommits((File)directory, project, branch, limit, logContext), logContext), (LogContext)logContext);
    }

    public List<GitCommit> getBranchCommits(ProjectRequest project, Seq<BranchRequest> branches, ProjectLogContext logContext) {
        return (List)this.logger().time(new StringBuilder(50).append("Getting commits for selected branches for project ").append(project.url()).toString(), this.logger().time$default$2(), this.logger().time$default$3(), (Function0 & Serializable & scala.Serializable)() -> (List)this.withRepository(project, this.withRepository$default$2(), (Function1 & Serializable & scala.Serializable)directory -> this.listBranchesCommits((File)directory, project, branches, logContext), logContext), (LogContext)logContext);
    }

    public Option<Object> getBranchCommits$default$3() {
        return None$.MODULE$;
    }

    public Option<CommitRequest> findCommonAncestor(ProjectRequest project, BranchRequest source, BranchRequest destination, ProjectLogContext logContext) {
        return (Option)this.logger().time(new StringBuilder(48).append("Getting common ancestor commit for branches ").append(project.url()).append(" - ").append(source.name()).append(":").append(destination.name()).toString(), this.logger().time$default$2(), this.logger().time$default$3(), (Function0 & Serializable & scala.Serializable)() -> (Option)this.withRepository(project, this.withRepository$default$2(), (Function1 & Serializable & scala.Serializable)directory -> this.findCommonAncestor((File)directory, source, destination, logContext), logContext), (LogContext)logContext);
    }

    public void cleanProjectDir(String projectUrl, ProjectLogContext logContext) {
        File projectDir = this.getProjectPath(projectUrl);
        this.lock(projectDir, this.lock$default$2(), (Function1 & Serializable & scala.Serializable)l -> {
            this.recreateProjectDir(projectDir, logContext);
            return BoxedUnit.UNIT;
        });
    }

    private void recreateProjectDir(File projectDir, ProjectLogContext logContext) {
        FileOperations$.MODULE$.deleteDirectory(projectDir, logContext);
        FileOperations$.MODULE$.createDirectory(projectDir, logContext);
    }

    public File getProjectPath(String iurl) {
        return Paths.get(this.repositoryLocation(), new String[0]).resolve(new StringBuilder(0).append(this.pathPrefix()).append(new StringOps(Predef$.MODULE$.augmentString(CryptoTools$.MODULE$.sha256Alphanumeric(iurl).toLowerCase())).take(16)).toString()).toFile();
    }

    public RepositoryData generateProjectData(Map<String, String> values, ProjectLogContext logContext) {
        return GitRepository$.MODULE$.generateProjectData(values, logContext);
    }

    private Seq<String> wrapCommandWithAuthorization(ProjectRequest request, Seq<String> gitCommand, ProjectLogContext logContext) {
        String singleStringCommand = gitCommand.mkString("\"", "\" \"", "\"");
        RepositoryData repositoryData = request.data();
        if (repositoryData instanceof SshRepositoryData) {
            return SSHAuthenticationWrapper$.MODULE$.wrap(request, singleStringCommand, this.repositoryKeysLocation(), logContext);
        }
        if (repositoryData instanceof AccessTokenRepositoryData) {
            return TokenAuthenticationWrapper$.MODULE$.wrap(request, singleStringCommand, logContext);
        }
        if (EmptyRepositoryData$.MODULE$.equals(repositoryData)) {
            return (Seq)new .colon.colon((Object)"bash", (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)new StringBuilder(2).append("(").append(singleStringCommand).append(")").toString(), (List)Nil$.MODULE$)));
        }
        throw new MatchError((Object)repositoryData);
    }

    public void pullChanges(File dir, ProjectRequest request, ProjectLogContext logContext) {
        Seq command = (Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"fetch", (List)new .colon.colon((Object)"--all", (List)new .colon.colon((Object)"--prune", (List)new .colon.colon((Object)"--force", (List)Nil$.MODULE$)))));
        Seq<String> commandWithAuth = this.wrapCommandWithAuthorization(request, (Seq<String>)command, logContext);
        GitCommandRunner$.MODULE$.execNoOutput(commandWithAuth, (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.execNoOutput$default$3(), logContext);
    }

    private void clone(File dir, ProjectRequest project, boolean recursive, FileSystemLocks.Lock l, ProjectLogContext logContext) {
        RepositoryData projectData;
        String sanitizedUrl = InputValidation$.MODULE$.sanitizeCommandParam(project.url());
        RepositoryData repositoryData = project.data();
        String url = repositoryData instanceof AccessTokenRepositoryData ? RepositoryUrlHelper$.MODULE$.toHttpsWithToken(sanitizedUrl, project.data().value(), RepositoryUrlHelper$.MODULE$.toHttpsWithToken$default$3(), logContext) : sanitizedUrl;
        Seq cmd = (Seq)((TraversableLike)((TraversableLike)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"clone", (List)Nil$.MODULE$))).$plus$plus(this.cloneOptions(recursive), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)url.toString(), (List)new .colon.colon((Object)dir.getAbsolutePath(), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom());
        RepositoryData repositoryData2 = project.data();
        RepositoryData x$1 = projectData = repositoryData2 instanceof AccessTokenRepositoryData ? EmptyRepositoryData$.MODULE$ : repositoryData2;
        String x$2 = project.copy$default$1();
        Seq<String> cloneCommand = this.wrapCommandWithAuthorization(project.copy(x$2, x$1), (Seq<String>)cmd, logContext);
        GitCommandRunner$.MODULE$.execNoOutput(cloneCommand, (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.execNoOutput$default$3(), logContext);
        BoxedUnit cloneCmdResponse = BoxedUnit.UNIT;
        GitRepository$.MODULE$.codacy$git$repository$GitRepository$$addOriginReferenceConfiguration(dir, logContext);
        GitRepository$.MODULE$.codacy$git$repository$GitRepository$$addGitHubPullRequestConfiguration(dir, logContext);
        this.pullChanges(dir, project, logContext);
    }

    public GitListResult listFiles(File dir, String commit, Option<Object> maxFileSizeBytesOpt, ProjectLogContext logContext) {
        this.logger().debug(new StringBuilder(17).append("Listing files in ").append(dir.getAbsolutePath()).toString(), (LogContext)logContext);
        List files = ((ListBuffer)((SeqLike)GitCommandRunner$.MODULE$.exec((Seq<String>)((Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"ls-tree", (List)new .colon.colon((Object)"-l", (List)new .colon.colon((Object)"-r", (List)new .colon.colon((Object)commit, (List)Nil$.MODULE$)))))), (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(prev, line) -> {
            String string = line;
            Option option = GitRepository$.MODULE$.GitFileResponse().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(5) == 0) {
                String mode = (String)((LinearSeqOptimized)option.get()).apply(0);
                String t = (String)((LinearSeqOptimized)option.get()).apply(1);
                String hash = (String)((LinearSeqOptimized)option.get()).apply(2);
                String size = (String)((LinearSeqOptimized)option.get()).apply(3);
                String filename = (String)((LinearSeqOptimized)option.get()).apply(4);
                if (!GitRepository$.MODULE$.isSymbolicLink(mode) && !GitRepository$.MODULE$.isCommit(t)) {
                    return prev.$plus$eq((Object)new GitFile(filename, hash, new StringOps(Predef$.MODULE$.augmentString(size)).toInt()));
                }
            }
            return prev;
        }, logContext)).distinct()).toList();
        Option<Object> option = maxFileSizeBytesOpt;
        if (None$.MODULE$.equals(option)) {
            return new GitListResult((List<GitFile>)files, (List<GitFile>)Nil$.MODULE$);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            int maxFileSize = BoxesRunTime.unboxToInt((Object)some.value());
            return (GitListResult)GitListResult$.MODULE$.tupled().apply((Object)files.partition((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GitRepository.$anonfun$listFiles$2(maxFileSize, x$1))));
        }
        throw new MatchError(option);
    }

    public Option<Object> listFiles$default$3() {
        return Option$.MODULE$.empty();
    }

    public Seq<String> changedFiles(File dir, String currentCommit, ProjectLogContext logContext) {
        this.logger().debug(new StringBuilder(28).append("Retrieving changed files in ").append(dir.getAbsolutePath()).toString(), (LogContext)logContext);
        return (Seq)GitCommandRunner$.MODULE$.exec((Seq<String>)((Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"show", (List)new .colon.colon((Object)"--first-parent", (List)new .colon.colon((Object)"--pretty=format:", (List)new .colon.colon((Object)"--name-only", (List)new .colon.colon((Object)currentCommit, (List)Nil$.MODULE$))))))), (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(prev, line) -> {
            String trimmed = line.trim();
            if (new StringOps(Predef$.MODULE$.augmentString(trimmed)).nonEmpty()) {
                return prev.$plus$eq((Object)line.trim());
            }
            return prev;
        }, logContext);
    }

    public CommitDiff getCommitDiff(File dir, CommitRequest sourceCommit, Seq<String> destinationCommits, Set<String> slf, ProjectLogContext logContext) {
        Seq seq = (Seq)destinationCommits.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GitRepository.$anonfun$getCommitDiff$1(x$2)));
        Seq diffCommand = seq.length() > 1 ? (Seq)((TraversableLike)GitRepository$.MODULE$.codacy$git$repository$GitRepository$$diffCommandPrefix().$plus$plus((GenTraversableOnce)new .colon.colon((Object)sourceCommit.uuid(), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus(destinationCommits, Seq$.MODULE$.canBuildFrom()) : (Seq)seq.lastOption().fold((Function0 & Serializable & scala.Serializable)() -> (Seq)((TraversableLike)((TraversableLike)((TraversableLike)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"show", (List)new .colon.colon((Object)"--format=", (List)Nil$.MODULE$)))).$plus$plus(GitRepository$.MODULE$.codacy$git$repository$GitRepository$$diffPrefix(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)sourceCommit.uuid(), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus(GitRepository$.MODULE$.codacy$git$repository$GitRepository$$diffSuffix(slf), Seq$.MODULE$.canBuildFrom()), (Function1 & Serializable & scala.Serializable)lastCommit -> (Seq)((TraversableLike)GitRepository$.MODULE$.codacy$git$repository$GitRepository$$diffCommandPrefix().$plus$plus((GenTraversableOnce)new .colon.colon(lastCommit, (List)new .colon.colon((Object)sourceCommit.uuid(), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())).$plus$plus(GitRepository$.MODULE$.codacy$git$repository$GitRepository$$diffSuffix(slf), Seq$.MODULE$.canBuildFrom()));
        return GitRepository$.MODULE$.codacy$git$repository$GitRepository$$executeAndParseDiff((Seq<String>)diffCommand, dir, logContext);
    }

    public CommitDiff getPullRequestDiff(File dir, CommitRequest source, String destination, Set<String> slf, ProjectLogContext logContext) {
        Seq command = (Seq)((TraversableLike)GitRepository$.MODULE$.codacy$git$repository$GitRepository$$diffCommandPrefix().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new StringBuilder(3).append(destination).append("...").append(source.uuid()).toString(), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus(GitRepository$.MODULE$.codacy$git$repository$GitRepository$$diffSuffix(slf), Seq$.MODULE$.canBuildFrom());
        this.logger().info(new StringBuilder(31).append("Getting pull request diff. cmd:").append(command.mkString(" ")).toString(), (LogContext)logContext);
        return GitRepository$.MODULE$.codacy$git$repository$GitRepository$$executeAndParseDiff((Seq<String>)command, dir, logContext);
    }

    public GitFileContents getFileContents(File dir, CommitRequest commit, String filename, ProjectLogContext logContext) {
        Seq command = (Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"show", (List)new .colon.colon((Object)new StringBuilder(1).append(commit.uuid()).append(":").append(filename).toString(), (List)Nil$.MODULE$)));
        return new GitFileContents(filename, (List<String>)((ListBuffer)GitCommandRunner$.MODULE$.exec((Seq<String>)command, (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(acc, line) -> acc.$plus$eq(line), logContext)).toList(), GitFileContents$.MODULE$.apply$default$3());
    }

    public List<GitCommitWithIndex> listAllCommits(File dir, ProjectLogContext logContext) {
        Seq logCmd = (Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"log", (List)new .colon.colon((Object)"--all", (List)new .colon.colon((Object)"--encoding=UTF-8", (List)new .colon.colon((Object)"--date=local", (List)new .colon.colon((Object)new StringBuilder(16).append("--pretty=format:").append(GitRepository$.MODULE$.commitFormat()).toString(), (List)Nil$.MODULE$))))));
        return ((ListBuffer)((TraversableLike)((IterableLike)GitCommandRunner$.MODULE$.exec((Seq<String>)logCmd, (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(prev, line) -> {
            Option<GitCommit> option = GitRepository$.MODULE$.parseCommitLog((String)line, logContext);
            if (option instanceof Some) {
                GitCommit commit;
                Some some = (Some)option;
                GitCommit gitCommit = commit = (GitCommit)some.value();
                return prev.$plus$eq$colon((Object)gitCommit);
            }
            if (None$.MODULE$.equals(option)) {
                return prev;
            }
            throw new MatchError(option);
        }, logContext)).zipWithIndex(ListBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                GitCommit e = (GitCommit)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (e != null) {
                    GitCommit gitCommit = e;
                    int n = i;
                    return new GitCommitWithIndex(gitCommit, n);
                }
            }
            throw new MatchError((Object)tuple2);
        }, ListBuffer$.MODULE$.canBuildFrom())).toList();
    }

    private List<GitCommit> listBranchCommits(File dir, ProjectRequest project, BranchRequest branch, Option<Object> limit, ProjectLogContext logContext) {
        Seq limitArgs = (Seq)limit.map((Function1 & Serializable & scala.Serializable)l -> GitRepository.$anonfun$listBranchCommits$1(BoxesRunTime.unboxToInt((Object)l))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        Seq<String> logCmd = this.wrapCommandWithAuthorization(project, (Seq<String>)((Seq)((TraversableLike)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"log", (List)new .colon.colon((Object)"--encoding=UTF-8", (List)new .colon.colon((Object)"--date=local", (List)new .colon.colon((Object)new StringBuilder(16).append("--pretty=format:").append(GitRepository$.MODULE$.commitFormat()).toString(), (List)new .colon.colon((Object)new StringBuilder(15).append("remotes/origin/").append(branch.name()).toString(), (List)Nil$.MODULE$))))))).$plus$plus((GenTraversableOnce)limitArgs, Seq$.MODULE$.canBuildFrom())), logContext);
        return this.parseBranchCommits(logCmd, dir, logContext);
    }

    private List<GitCommit> listBranchesCommits(File dir, ProjectRequest project, Seq<BranchRequest> branches, ProjectLogContext logContext) {
        Seq branchNames = (Seq)branches.map((Function1 & Serializable & scala.Serializable)branch -> new StringBuilder(15).append("remotes/origin/").append(branch.name()).toString(), Seq$.MODULE$.canBuildFrom());
        Seq logCmd = (Seq)((TraversableLike)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"log", (List)new .colon.colon((Object)"--encoding=UTF-8", (List)new .colon.colon((Object)"--date=local", (List)new .colon.colon((Object)new StringBuilder(16).append("--pretty=format:").append(GitRepository$.MODULE$.commitFormat()).toString(), (List)Nil$.MODULE$)))))).$plus$plus((GenTraversableOnce)branchNames, Seq$.MODULE$.canBuildFrom());
        return this.parseBranchCommits((Seq<String>)logCmd, dir, logContext);
    }

    private List<CommitRequest> listBranchCommits(File dir, ProjectRequest project, BranchRequest branch, CommitRequest limitCommit, ProjectLogContext logContext) {
        Seq<String> cmd = this.wrapCommandWithAuthorization(project, (Seq<String>)((Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"rev-list", (List)new .colon.colon((Object)new StringBuilder(17).append(limitCommit.uuid()).append("..remotes/origin/").append(branch.name()).toString(), (List)Nil$.MODULE$)))), logContext);
        return ((ListBuffer)GitCommandRunner$.MODULE$.exec(cmd, (Option<File>)Option$.MODULE$.apply((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(prev, line) -> prev.$plus$eq((Object)new CommitRequest((String)line)), logContext)).toList();
    }

    private List<GitCommit> parseBranchCommits(Seq<String> logCmd, File dir, ProjectLogContext logContext) {
        return ((ListBuffer)GitCommandRunner$.MODULE$.exec(logCmd, (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(prev, line) -> {
            Option<GitCommit> option = GitRepository$.MODULE$.parseCommitLog((String)line, logContext);
            if (option instanceof Some) {
                Some some = (Some)option;
                GitCommit commit = (GitCommit)some.value();
                return prev.$plus$eq((Object)commit);
            }
            if (None$.MODULE$.equals(option)) {
                return prev;
            }
            throw new MatchError(option);
        }, logContext)).toList();
    }

    private Option<CommitRequest> findCommonAncestor(File dir, BranchRequest source, BranchRequest destination, ProjectLogContext logContext) {
        Seq cmd = (Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"merge-base", (List)new .colon.colon((Object)new StringBuilder(15).append("remotes/origin/").append(source.name()).toString(), (List)new .colon.colon((Object)new StringBuilder(15).append("remotes/origin/").append(destination.name()).toString(), (List)Nil$.MODULE$))));
        return (Option)GitCommandRunner$.MODULE$.exec((Seq<String>)cmd, (Option<File>)Option$.MODULE$.apply((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), None$.MODULE$, (Function2 & Serializable & scala.Serializable)(prev, line) -> {
            Option option = prev;
            if (None$.MODULE$.equals(option)) {
                return new Some((Object)new CommitRequest((String)line));
            }
            return prev;
        }, logContext);
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$2(int maxFileSize$1, GitFile x$1) {
        return x$1.bytes() < maxFileSize$1;
    }

    public static final /* synthetic */ boolean $anonfun$getCommitDiff$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.trim())).nonEmpty();
    }

    public static final /* synthetic */ Seq $anonfun$listBranchCommits$1(int l) {
        return (Seq)new .colon.colon((Object)"-n", (List)new .colon.colon((Object)Integer.toString(l), (List)Nil$.MODULE$));
    }

    public GitRepository(String repositoryKeysLocation, String repositoryLocation) {
        this.repositoryKeysLocation = repositoryKeysLocation;
        this.repositoryLocation = repositoryLocation;
        ContextLogging.$init$((ContextLogging)this);
        FileSystemLocks.$init$(this);
    }
}

