/*
 * Decompiled with CFR 0.152.
 */
package codacy.git.repository;

import codacy.foundation.logging.Logger;
import codacy.git.repository.GitBranch;
import codacy.git.repository.GitBranch$;
import codacy.git.repository.GitPullRequest;
import codacy.git.repository.ReadOnlyGitRepository;
import com.typesafe.scalalogging.LazyLogging;
import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

public final class ReadOnlyGitRepository$
implements Logger {
    public static ReadOnlyGitRepository$ MODULE$;
    private final String prPrefix;
    private final String MainPattern;
    private final String DefaultRefsPattern;
    private final String codacy$git$repository$ReadOnlyGitRepository$$GitHubPullRequestRefsPattern;
    private final Regex MainBranchName;
    private final Regex MainBranchUUID;
    private final Regex Branch;
    private final Regex GitHubPullRequest;
    private final Regex InvalidBranch;
    private transient com.typesafe.scalalogging.Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ReadOnlyGitRepository$();
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        ReadOnlyGitRepository$ readOnlyGitRepository$ = this;
        synchronized (readOnlyGitRepository$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String prPrefix() {
        return this.prPrefix;
    }

    public String MainPattern() {
        return this.MainPattern;
    }

    public String DefaultRefsPattern() {
        return this.DefaultRefsPattern;
    }

    public String codacy$git$repository$ReadOnlyGitRepository$$GitHubPullRequestRefsPattern() {
        return this.codacy$git$repository$ReadOnlyGitRepository$$GitHubPullRequestRefsPattern;
    }

    private Regex MainBranchName() {
        return this.MainBranchName;
    }

    private Regex MainBranchUUID() {
        return this.MainBranchUUID;
    }

    private Regex Branch() {
        return this.Branch;
    }

    private Regex GitHubPullRequest() {
        return this.GitHubPullRequest;
    }

    private Regex InvalidBranch() {
        return this.InvalidBranch;
    }

    public String codacy$git$repository$ReadOnlyGitRepository$$toBranchRef(String branchName) {
        return new StringBuilder(11).append("refs/heads/").append(branchName).toString();
    }

    public String codacy$git$repository$ReadOnlyGitRepository$$toGitHubPullRequestRef(long prNumber) {
        return new StringBuilder(15).append("refs/pull/").append(prNumber).append("/head").toString();
    }

    public ReadOnlyGitRepository.ParsedRefState parseRef(ReadOnlyGitRepository.ParsedRefState state, String line) {
        String string = line;
        Option option = this.InvalidBranch().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            BoxedUnit boxedUnit;
            String latestCommitUUID = (String)((LinearSeqOptimized)option.get()).apply(0);
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(56).append("Failed to insert branch with commit UUID ").append(latestCommitUUID).append(".").append("Invalid line: ").append(line).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return state;
        }
        Option option2 = this.Branch().unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
            String latestCommitUUID = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String name = (String)((LinearSeqOptimized)option2.get()).apply(1);
            state.branchesMapBuilder().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)new GitBranch(name, latestCommitUUID, GitBranch$.MODULE$.apply$default$3())));
            return state;
        }
        Option option3 = this.GitHubPullRequest().unapplySeq((CharSequence)string);
        if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
            String latestCommitUUID = (String)((LinearSeqOptimized)option3.get()).apply(0);
            String number = (String)((LinearSeqOptimized)option3.get()).apply(1);
            String name = new StringBuilder(4).append(this.prPrefix()).append("/pr/").append(number).toString();
            state.pullRequestsMapBuilder().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)new GitPullRequest(name, new StringOps(Predef$.MODULE$.augmentString(number)).toInt(), latestCommitUUID)));
            return state;
        }
        Option option4 = this.MainBranchUUID().unapplySeq((CharSequence)string);
        if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(1) == 0) {
            String latestCommitUUID = (String)((LinearSeqOptimized)option4.get()).apply(0);
            return state.copy((Option<String>)Option$.MODULE$.apply((Object)latestCommitUUID), state.copy$default$2(), state.copy$default$3(), state.copy$default$4());
        }
        Option option5 = this.MainBranchName().unapplySeq((CharSequence)string);
        if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(1) == 0) {
            String name = (String)((LinearSeqOptimized)option5.get()).apply(0);
            Option x$1 = Option$.MODULE$.apply((Object)name);
            Option<String> x$2 = state.copy$default$1();
            Builder<Tuple2<String, GitBranch>, Map<String, GitBranch>> x$3 = state.copy$default$3();
            Builder<Tuple2<String, GitPullRequest>, Map<String, GitPullRequest>> x$4 = state.copy$default$4();
            return state.copy(x$2, (Option<String>)x$1, x$3, x$4);
        }
        return state;
    }

    public Seq<GitBranch> codacy$git$repository$ReadOnlyGitRepository$$toSeqWithMain(Map<String, GitBranch> allBranches, String mainBranchUUID, String mainBranchName) {
        GitBranch mainBranch = new GitBranch(mainBranchName, mainBranchUUID, true);
        return (Seq)allBranches.foldRight((Object)new .colon.colon((Object)mainBranch, (List)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Seq acc = (Seq)tuple2._2();
                if (tuple22 != null) {
                    String name = (String)tuple22._1();
                    GitBranch branch = (GitBranch)tuple22._2();
                    String string = name;
                    String string2 = mainBranchName;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        GitBranch gitBranch = branch;
                        return (Seq)acc.$plus$colon((Object)gitBranch, Seq$.MODULE$.canBuildFrom());
                    }
                    return acc;
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private ReadOnlyGitRepository$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.prPrefix = "codacy-amN6znLRueK4Yky";
        this.MainPattern = "HEAD";
        this.DefaultRefsPattern = "refs/heads/*";
        this.codacy$git$repository$ReadOnlyGitRepository$$GitHubPullRequestRefsPattern = "refs/pull/*/head";
        this.MainBranchName = new StringOps(Predef$.MODULE$.augmentString("^ref: refs/heads/(.*)[\\t]+HEAD$")).r();
        this.MainBranchUUID = new StringOps(Predef$.MODULE$.augmentString("^([a-z0-9]+)[ \\t]+HEAD$")).r();
        this.Branch = new StringOps(Predef$.MODULE$.augmentString("^([a-z0-9]+)[ \\t]+refs/heads/(.*)$")).r();
        this.GitHubPullRequest = new StringOps(Predef$.MODULE$.augmentString("^([a-z0-9]+)[ \\t]+refs/pull/([0-9]+)/head$")).r();
        this.InvalidBranch = new StringOps(Predef$.MODULE$.augmentString("^([a-z0-9]+)[ \\t]+refs/heads/(?:HEAD|refs/heads/.*)$")).r();
    }
}

