package codacy.git.authentication

import codacy.foundation.logging.context.ProjectLogContext
import codacy.git.repository.{ProjectRequest, RepositoryUrlHelper}

object TokenAuthenticationWrapper {

  /**
    * Updates origin's url with the new URL with token before running the command.
    * This is needed because access tokens are valid for 1h.
    */
  def wrap(projectRequest: ProjectRequest, command: String)(implicit logContext: ProjectLogContext): Seq[String] = {
    val uri = RepositoryUrlHelper.toHttpsWithToken(projectRequest.url, projectRequest.data.value)

    Seq("bash", "-c", s"(git remote set-url origin $uri; $command)")
  }

}
