package codacy.git.repository

import codacy.foundation.logging.context.ProjectLogContext
import codacy.utils.FileSystemLocks

import scala.concurrent.ExecutionContext

class BareGitRepository(repositoryKeysLocation: String, repositoryLocation: String)(
    implicit executionContext: ExecutionContext
) extends WriteGitRepository(repositoryKeysLocation, repositoryLocation) {

  override def cloneOptions(recursive: Boolean): Seq[String] = Seq("--bare")

  override def pathPrefix: String = "b_"

  override protected[git] def withRepository[T](project: ProjectRequest, forceUpdate: Boolean = false)(
      block: java.io.File => T
  )(implicit logContext: ProjectLogContext): T = {
    val projectDir = getProjectPath(project.url)

    lock(projectDir) { implicit l: FileSystemLocks.Lock =>
      val repositoryDir =
        pullChangesOrClone(
          project = project,
          projectDir = projectDir,
          forceUpdate = forceUpdate,
          cloneSubmodules = false,
        )
      block(repositoryDir)
    }
  }

  def updateRepository(project: ProjectRequest)(implicit logContext: ProjectLogContext): Unit = {
    val projectDir = getProjectPath(project.url)

    lock(projectDir) { implicit l: FileSystemLocks.Lock =>
      pullChangesOrClone(project, projectDir, cloneSubmodules = false)
    }
  }
}
