/*
 * Decompiled with CFR 0.152.
 */
package codacy.git.repository;

import codacy.foundation.logging.context.ContextAwareLogger;
import codacy.foundation.logging.context.ContextLogging;
import codacy.foundation.logging.context.LogContext;
import codacy.foundation.logging.context.ProjectLogContext;
import codacy.git.repository.Protocol$;
import java.net.URI;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class RepositoryUrlHelper$
implements ContextLogging {
    public static RepositoryUrlHelper$ MODULE$;
    private final String xAccessToken;
    private final Regex gitRepoRegex;
    private final Regex gitSshRegex;
    private transient ContextAwareLogger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new RepositoryUrlHelper$();
    }

    private ContextAwareLogger logger$lzycompute() {
        RepositoryUrlHelper$ repositoryUrlHelper$ = this;
        synchronized (repositoryUrlHelper$) {
            if (!this.bitmap$trans$0) {
                this.logger = ContextLogging.logger$((ContextLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public ContextAwareLogger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String xAccessToken() {
        return this.xAccessToken;
    }

    public Regex gitRepoRegex() {
        return this.gitRepoRegex;
    }

    public Regex gitSshRegex() {
        return this.gitSshRegex;
    }

    public Enumeration.Value getProtocol(String url) {
        return (Enumeration.Value)this.gitRepoRegex().findAllMatchIn((CharSequence)url).toSeq().headOption().map((Function1 & java.io.Serializable & Serializable)matched -> {
            String protocol = matched.group(1);
            String string = protocol;
            if ("https".equals(string)) {
                return Protocol$.MODULE$.https();
            }
            if (string.startsWith("git")) {
                return Protocol$.MODULE$.ssh();
            }
            return Protocol$.MODULE$.invalid();
        }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> Protocol$.MODULE$.invalid());
    }

    public URI toHttpsWithToken(String url, String token, String userPart, ProjectLogContext logContext) {
        Enumeration.Value value = this.getProtocol(url);
        Enumeration.Value value2 = Protocol$.MODULE$.ssh();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return this.changeSshUrlToHttpsWithToken(url, token, userPart);
        }
        Enumeration.Value value4 = Protocol$.MODULE$.https();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return this.addToken(url, token, userPart);
        }
        Enumeration.Value value6 = Protocol$.MODULE$.invalid();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            String message = new StringBuilder(25).append("Invalid protocol in url: ").append(url).toString();
            this.logger().error(message, (LogContext)logContext);
            throw new IllegalArgumentException(message);
        }
        throw new MatchError((Object)value);
    }

    public String toHttpsWithToken$default$3() {
        return this.xAccessToken();
    }

    private URI changeSshUrlToHttpsWithToken(String url, String token, String userPart) {
        String urlString = this.gitSshRegex().replaceAllIn((CharSequence)url, (Function1 & java.io.Serializable & Serializable)matched -> {
            String domainPart = matched.group(2);
            String repoPath = matched.group(4);
            return new StringBuilder(15).append("https://").append(userPart).append(":").append(token).append("@").append(domainPart).append("/").append(repoPath).append(".git").toString();
        });
        return URI.create(urlString);
    }

    private String changeSshUrlToHttpsWithToken$default$3() {
        return this.xAccessToken();
    }

    private URI addToken(String url, String token, String userPart) {
        URI uri = URI.create(url);
        return URI.create(new StringBuilder(10).append("https://").append(userPart).append(":").append(token).append("@").append(uri.getHost()).append(uri.getPath()).toString());
    }

    private String addToken$default$3() {
        return this.xAccessToken();
    }

    private RepositoryUrlHelper$() {
        MODULE$ = this;
        ContextLogging.$init$((ContextLogging)this);
        this.xAccessToken = "x-access-token";
        this.gitRepoRegex = new StringOps(Predef$.MODULE$.augmentString("(git|ssh|https?|git@[-\\w.]+):(\\/\\/)?(.*?)(\\.git)?(\\/?|\\#[-\\w._]+?)$")).r();
        this.gitSshRegex = new StringOps(Predef$.MODULE$.augmentString("(git|ssh|https)@?([-\\w.]+):(\\/\\/)?(.*?)(\\.git)?(\\/?|\\#[-\\w._]+?)$")).r();
    }
}

