/*
 * Decompiled with CFR 0.152.
 */
package codacy.git.repository;

import codacy.foundation.crypto.SSHKeyGenerator$;
import codacy.foundation.logging.context.ContextAwareLogger;
import codacy.foundation.logging.context.ContextLogging;
import codacy.foundation.logging.context.LogContext;
import codacy.foundation.logging.context.ProjectLogContext;
import codacy.git.GitCommandRunner$;
import codacy.git.diff.CommitDiff;
import codacy.git.diff.Diff;
import codacy.git.diff.GitDiffParser$;
import codacy.git.repository.Blame;
import codacy.git.repository.GitCommit;
import codacy.git.repository.GitRepositoryDefinition;
import codacy.git.repository.GitRepositoryDefinition$;
import codacy.git.repository.RepositoryData;
import codacy.git.repository.SshRepositoryData;
import java.io.File;
import java.io.Serializable;
import org.joda.time.DateTime;
import play.api.libs.json.Json$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class WriteGitRepository$
implements ContextLogging {
    public static WriteGitRepository$ MODULE$;
    private Seq<String> codacy$git$repository$WriteGitRepository$$diffPrefix;
    private Regex GitFileResponse;
    private final String prPrefix;
    private final String sep;
    private final String eol;
    private final String commitFormat;
    private final Regex CommitMatch;
    private final Seq<String> diffFlags;
    private final Seq<String> codacy$git$repository$WriteGitRepository$$diffCommandPrefix;
    private final Regex BlameMatch;
    private final Regex FileMatch;
    private final int DiffLineLimit;
    private transient ContextAwareLogger logger;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    static {
        new WriteGitRepository$();
    }

    private ContextAwareLogger logger$lzycompute() {
        WriteGitRepository$ writeGitRepository$ = this;
        synchronized (writeGitRepository$) {
            if (!this.bitmap$trans$0) {
                this.logger = ContextLogging.logger$((ContextLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public ContextAwareLogger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String prPrefix() {
        return this.prPrefix;
    }

    public String sep() {
        return this.sep;
    }

    public String eol() {
        return this.eol;
    }

    public String commitFormat() {
        return this.commitFormat;
    }

    private Regex CommitMatch() {
        return this.CommitMatch;
    }

    private Seq<String> diffFlags() {
        return this.diffFlags;
    }

    public Seq<String> codacy$git$repository$WriteGitRepository$$diffCommandPrefix() {
        return this.codacy$git$repository$WriteGitRepository$$diffCommandPrefix;
    }

    private Seq<String> diffPrefix$lzycompute() {
        WriteGitRepository$ writeGitRepository$ = this;
        synchronized (writeGitRepository$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.codacy$git$repository$WriteGitRepository$$diffPrefix = (Seq)new .colon.colon((Object)"--src-prefix=\t", (List)new .colon.colon((Object)"--dst-prefix=\t", (List)Nil$.MODULE$));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.codacy$git$repository$WriteGitRepository$$diffPrefix;
    }

    public Seq<String> codacy$git$repository$WriteGitRepository$$diffPrefix() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.diffPrefix$lzycompute();
        }
        return this.codacy$git$repository$WriteGitRepository$$diffPrefix;
    }

    public List<String> codacy$git$repository$WriteGitRepository$$diffSuffix(Set<String> files) {
        return (List)new .colon.colon((Object)"--", (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)files.map((Function1 & Serializable & scala.Serializable)e -> new java.lang.StringBuilder(1).append("*").append((String)e).toString(), Set$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
    }

    private Regex GitFileResponse$lzycompute() {
        WriteGitRepository$ writeGitRepository$ = this;
        synchronized (writeGitRepository$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.GitFileResponse = new StringOps(Predef$.MODULE$.augmentString("(\\w+)\\s*(\\w+)\\s*(\\w+)\\s*([0-9-]+)\\t(.+)")).r();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.GitFileResponse;
    }

    public Regex GitFileResponse() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.GitFileResponse$lzycompute();
        }
        return this.GitFileResponse;
    }

    public boolean isSymbolicLink(String s) {
        String string = s;
        String string2 = "120000";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean isCommit(String s) {
        String string = s;
        String string2 = "commit";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public void codacy$git$repository$WriteGitRepository$$addOriginReferenceConfiguration(File dir, ProjectLogContext logContext) {
        this.addGitConfig(dir, "remote.origin.fetch", "+refs/heads/*:refs/remotes/origin/*", logContext);
    }

    public void codacy$git$repository$WriteGitRepository$$addGitHubPullRequestConfiguration(File dir, ProjectLogContext logContext) {
        this.addGitConfig(dir, "remote.origin.fetch", new java.lang.StringBuilder(43).append("+refs/pull/*/head:refs/remotes/origin/").append(this.prPrefix()).append("/pr/*").toString(), logContext);
    }

    public void addGitConfig(File dir, String name, String value, ProjectLogContext logContext) {
        GitCommandRunner$.MODULE$.execNoOutput((Seq<String>)((Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"config", (List)new .colon.colon((Object)"--add", (List)new .colon.colon((Object)name, (List)new .colon.colon((Object)value, (List)Nil$.MODULE$)))))), (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.execNoOutput$default$3(), logContext);
    }

    public Option<Object> isValidRepo(File dir, Option<String> commitUuid, ProjectLogContext logContext) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String result = GitCommandRunner$.MODULE$.exec((Seq<String>)((Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"rev-parse", (List)new .colon.colon((Object)"--verify", (List)new .colon.colon((Object)"HEAD", (List)Nil$.MODULE$))))), (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), "", (Function2 & Serializable & scala.Serializable)(res, line) -> new java.lang.StringBuilder(0).append((String)res).append((String)line).toString(), logContext);
            return commitUuid.isEmpty() || commitUuid.contains((Object)result.trim());
        }).toOption();
    }

    public Option<String> isValidRepo$default$2() {
        return None$.MODULE$;
    }

    public RepositoryData generateProjectData(Map<String, String> values, ProjectLogContext logContext) {
        Tuple2 tuple2 = this.liftedTree1$1(logContext);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String generatedPublicKey = (String)tuple2._1();
        String generatedPrivateKey = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)generatedPublicKey, (Object)generatedPrivateKey);
        String generatedPublicKey2 = (String)tuple22._1();
        String generatedPrivateKey2 = (String)tuple22._2();
        String publicKey = (String)values.getOrElse((Object)"publicKey", (Function0 & Serializable & scala.Serializable)() -> generatedPublicKey2);
        String privateKey = (String)values.getOrElse((Object)"privateKey", (Function0 & Serializable & scala.Serializable)() -> generatedPrivateKey2);
        String json = Json$.MODULE$.toJson((Object)new GitRepositoryDefinition(publicKey, privateKey), GitRepositoryDefinition$.MODULE$.gitRepositoryDefinitionFmt()).toString();
        return new SshRepositoryData(json);
    }

    public Option<GitCommit> parseCommitLog(String commitLog, ProjectLogContext logContext) {
        String string = commitLog;
        Option option = this.CommitMatch().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(7) == 0) {
            String hash = (String)((LinearSeqOptimized)option.get()).apply(0);
            String parents = (String)((LinearSeqOptimized)option.get()).apply(1);
            String authorDate = (String)((LinearSeqOptimized)option.get()).apply(2);
            String commitDate = (String)((LinearSeqOptimized)option.get()).apply(3);
            String authorName = (String)((LinearSeqOptimized)option.get()).apply(4);
            String authorEmail = (String)((LinearSeqOptimized)option.get()).apply(5);
            String subject = (String)((LinearSeqOptimized)option.get()).apply(6);
            this.logger().debug(new java.lang.StringBuilder(38).append("RepositoryGit::parseCommitDateUser::s ").append(string).toString(), (LogContext)logContext);
            GitCommit commit = new GitCommit(hash, parents.trim(), new DateTime(new StringOps(Predef$.MODULE$.augmentString(authorDate)).toLong() * 1000L), new DateTime(new StringOps(Predef$.MODULE$.augmentString(commitDate)).toLong() * 1000L), authorName, authorEmail, subject);
            return Option$.MODULE$.apply((Object)commit);
        }
        this.logger().error(new java.lang.StringBuilder(40).append("RepositoryGit::failed to parse commit [").append(string).append("]").toString(), (LogContext)logContext);
        return Option$.MODULE$.empty();
    }

    public final Regex BlameMatch() {
        return this.BlameMatch;
    }

    public final Regex FileMatch() {
        return this.FileMatch;
    }

    public Option<Blame> parseBlame(String blameLine1, String blameLine2) {
        Tuple2 tuple2 = new Tuple2((Object)blameLine1, (Object)blameLine2);
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String string2 = (String)tuple2._2();
            Option option = this.BlameMatch().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
                String commit = (String)((LinearSeqOptimized)option.get()).apply(0);
                String originalLineNr = (String)((LinearSeqOptimized)option.get()).apply(1);
                String finalLineNr = (String)((LinearSeqOptimized)option.get()).apply(2);
                Option option2 = this.FileMatch().unapplySeq((CharSequence)string2);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                    String filePath = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    return new Some((Object)new Blame(commit, new StringOps(Predef$.MODULE$.augmentString(originalLineNr)).toInt(), new StringOps(Predef$.MODULE$.augmentString(finalLineNr)).toInt(), filePath));
                }
            }
        }
        return None$.MODULE$;
    }

    private int DiffLineLimit() {
        return this.DiffLineLimit;
    }

    public CommitDiff codacy$git$repository$WriteGitRepository$$executeAndParseDiff(Seq<String> diffCommand, File dir, ProjectLogContext logContext) {
        IntRef lineCount = IntRef.create((int)0);
        StringBuilder builder2 = GitCommandRunner$.MODULE$.exec(diffCommand, (Option<File>)new Some((Object)dir), (Option<Duration>)Option$.MODULE$.apply((Object)new package.DurationInt(package$.MODULE$.DurationInt(5)).minutes()), new StringBuilder(), (Function2 & Serializable & scala.Serializable)(builder, line) -> {
            builder.append(line.replace("\r", ""));
            builder.append('\n');
            if (lineCount$1.elem > MODULE$.DiffLineLimit()) {
                throw new Exception(new java.lang.StringBuilder(35).append("Exceeded diff lines limit of ").append(MODULE$.DiffLineLimit()).append(" lines").toString());
            }
            ++lineCount$1.elem;
            return builder;
        }, logContext);
        String data = builder2.result();
        if (data.startsWith("diff")) {
            Try<Seq<Diff>> diffs = GitDiffParser$.MODULE$.parse(data);
            return new CommitDiff(data, diffs);
        }
        return new CommitDiff("", (Try<Seq<Diff>>)new Success((Object)Nil$.MODULE$));
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(ProjectLogContext logContext$10) {
        Tuple2 tuple2;
        try {
            tuple2 = SSHKeyGenerator$.MODULE$.generateKey(SSHKeyGenerator$.MODULE$.generateKey$default$1(), SSHKeyGenerator$.MODULE$.generateKey$default$2());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logger().error("Error generating ssh key", e, (LogContext)logContext$10);
                tuple2 = new Tuple2((Object)"", (Object)"");
            }
            throw throwable;
        }
        return tuple2;
    }

    private WriteGitRepository$() {
        MODULE$ = this;
        ContextLogging.$init$((ContextLogging)this);
        this.prPrefix = "codacy-amN6znLRueK4Yky";
        this.sep = "<codacy:sep>";
        this.eol = "<codacy:eol>";
        this.commitFormat = new java.lang.StringBuilder(18).append("%H").append(this.sep()).append("%P").append(this.sep()).append("%at").append(this.sep()).append("%ct").append(this.sep()).append("%an").append(this.sep()).append("%ae").append(this.sep()).append("%s").append(this.eol()).toString();
        this.CommitMatch = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(64).append("^([a-z0-9]+)").append(this.sep()).append("([a-z0-9 ]*)").append(this.sep()).append("([0-9]+)").append(this.sep()).append("([0-9]+)").append(this.sep()).append("((?s).*)").append(this.sep()).append("((?s).*)").append(this.sep()).append("((?s).*)").append(this.eol()).toString())).r();
        this.diffFlags = (Seq)new .colon.colon((Object)"-M", (List)Nil$.MODULE$);
        this.codacy$git$repository$WriteGitRepository$$diffCommandPrefix = (Seq)((TraversableLike)((TraversableLike)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"diff", (List)Nil$.MODULE$))).$plus$plus(this.codacy$git$repository$WriteGitRepository$$diffPrefix(), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.diffFlags(), Seq$.MODULE$.canBuildFrom());
        this.BlameMatch = new StringOps(Predef$.MODULE$.augmentString("^([0-9a-f]{40})\\s([0-9]+)\\s([0-9]+)\\s*[0-9]*")).r();
        this.FileMatch = new StringOps(Predef$.MODULE$.augmentString("^filename (.*)")).r();
        this.DiffLineLimit = Integer.MAX_VALUE;
    }
}

