/*
 * Decompiled with CFR 0.152.
 */
package codacy.git.repository;

import codacy.foundation.crypto.CryptoTools$;
import codacy.foundation.logging.context.LogContext;
import codacy.foundation.logging.context.ProjectLogContext;
import codacy.git.GitCommandRunner$;
import codacy.git.diff.CommitDiff;
import codacy.git.repository.AccessTokenRepositoryData;
import codacy.git.repository.BranchRequest;
import codacy.git.repository.CommitRequest;
import codacy.git.repository.EmptyRepositoryData$;
import codacy.git.repository.GitCommit;
import codacy.git.repository.GitCommitWithIndex;
import codacy.git.repository.GitFile;
import codacy.git.repository.GitFileContents;
import codacy.git.repository.GitFileContents$;
import codacy.git.repository.GitListResult;
import codacy.git.repository.GitListResult$;
import codacy.git.repository.GitRepository;
import codacy.git.repository.ProjectRequest;
import codacy.git.repository.RepositoryData;
import codacy.git.repository.WriteGitRepository$;
import codacy.utils.FileOperations$;
import codacy.utils.FileSystemLocks;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u00115e!\u0002'N\u0003\u0003!\u0006\u0002C0\u0001\u0005\u000b\u0007I\u0011\u00011\t\u00119\u0004!\u0011!Q\u0001\n\u0005D\u0001b\u001c\u0001\u0003\u0006\u0004%\t\u0001\u0019\u0005\ta\u0002\u0011\t\u0011)A\u0005C\"A\u0011\u000f\u0001B\u0001B\u0003-!\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0004\u0000\u0001\u0011EQ*!\u0001\t\u000f\u0005\u0005\u0002\u0001\"\u0005NA\"A\u00111\u0005\u0001\u0007\u0012=\u000b)\u0003\u0003\u0006\u0002\u0004\u0002\t\n\u0011\"\u0005P\u0003\u000bCq!a(\u0001\r\u0003\t\t\u000bC\u0004\u00022\u0002!\t\"a-\t\u000f\u0005E\u0006\u0001\"\u0005\u0002X\"9\u0011q\u001d\u0001\u0005\n\u0005%\bbBA|\u0001\u0011\u0005\u0011\u0011 \u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0011%\u0011I\u0004AI\u0001\n\u0003\u0011Y\u0004C\u0004\u0003\u000e\u0001!\tAa\u0010\t\u000f\t5\u0001\u0001\"\u0001\u0003T!9!\u0011\r\u0001\u0005\u0002\t\r\u0004b\u0002B;\u0001\u0011\u0005!q\u000f\u0005\b\u0005\u0003\u0003A\u0011\u0002BB\u0011!\u0011Y\t\u0001C\u0001\u001f\n5\u0005b\u0002BJ\u0001\u0011\u0005!Q\u0013\u0005\b\u0005W\u0003A\u0011\u0003BW\u0011\u001d\u0011Y\f\u0001C\u0005\u0005{CqAa3\u0001\t\u0003\u0011i\rC\u0005\u0003d\u0002\t\n\u0011\"\u0001\u0003<!9!Q\u001d\u0001\u0005\u0002\t\u001d\bb\u0002B\u007f\u0001\u0011\u0005!q \u0005\b\u0007K\u0001A\u0011AB\u0014\u0011\u001d\u0019)\u0004\u0001C\u0001\u0007oAqaa\u0013\u0001\t\u0003\u0019i\u0005C\u0004\u0004V\u0001!Iaa\u0016\t\u000f\r\u0015\u0004\u0001\"\u0003\u0004h!91Q\u000b\u0001\u0005\n\rE\u0004bBBA\u0001\u0011%11\u0011\u0005\b\u0005C\u0002A\u0011BBH\u000f\u001d\u0019Y*\u0014E\u0001\u0007;3a\u0001T'\t\u0002\r}\u0005B\u0002=)\t\u0003\u0019i\u000bC\u0005\u00040\"\u0012\r\u0011\"\u0001\u00042\"A1Q\u0018\u0015!\u0002\u0013\u0019\u0019\fC\u0005\u0004@\"\u0012\r\u0011\"\u0001\u00042\"A1\u0011\u0019\u0015!\u0002\u0013\u0019\u0019\fC\u0005\u0004D\"\u0012\r\u0011\"\u0001\u00042\"A1Q\u0019\u0015!\u0002\u0013\u0019\u0019\f\u0003\u0005\u0004H\"\u0012\r\u0011\"\u0001a\u0011\u001d\u0019I\r\u000bQ\u0001\n\u0005D\u0011ba3)\u0005\u0004%Ia!4\t\u0011\r}\u0007\u0006)A\u0005\u0007\u001fD\u0011b!9)\u0005\u0004%Iaa9\t\u0011\r\u001d\b\u0006)A\u0005\u0007KD\u0011b!;)\u0005\u0004%Iaa9\t\u0011\r-\b\u0006)A\u0005\u0007KD!b!<)\u0011\u000b\u0007I\u0011BBr\u0011\u001d\u0019y\u000f\u000bC\u0005\u0007cD1b!?)\u0011\u000b\u0007I\u0011A(\u0004N\"A11 \u0015\u0005\u0002=\u001bi\u0010\u0003\u0005\u0005\u0004!\"\ta\u0014C\u0003\u0011\u001d!I\u0001\u000bC\u0005\t\u0017Aq\u0001b\u0005)\t\u0013!)\u0002C\u0004\u0005\u001e!\"\t\u0002b\b\t\u0011\u0011=\u0002\u0006\"\u0001P\tcA!\u0002\"\u0011)#\u0003%\ta\u0014C\"\u0011!\u0011\u0019\n\u000bC\u0001\u001f\u0012\u001d\u0003\u0002\u0003C(Q\u0011\u0005q\n\"\u0015\t\u0013\u0011u\u0003F1A\u0005\u0006\r5\u0007\u0002\u0003C0Q\u0001\u0006iaa4\t\u0013\u0011\u0005\u0004F1A\u0005\u0006\r5\u0007\u0002\u0003C2Q\u0001\u0006iaa4\t\u0011\u0011\u0015\u0004\u0006\"\u0001P\tOB\u0011\u0002\"\u001f)\u0005\u0004%I\u0001b\u001f\t\u0011\u0011u\u0004\u0006)A\u0005\u0005gAq\u0001b )\t\u0013!\tI\u0001\nXe&$XmR5u%\u0016\u0004xn]5u_JL(B\u0001(P\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003!F\u000b1aZ5u\u0015\u0005\u0011\u0016AB2pI\u0006\u001c\u0017p\u0001\u0001\u0014\u0007\u0001)\u0016\f\u0005\u0002W/6\tQ*\u0003\u0002Y\u001b\niq)\u001b;SKB|7/\u001b;pef\u0004\"AW/\u000e\u0003mS!\u0001X)\u0002\u000bU$\u0018\u000e\\:\n\u0005y[&a\u0004$jY\u0016\u001c\u0016p\u001d;f[2{7m[:\u0002-I,\u0007o\\:ji>\u0014\u0018pS3zg2{7-\u0019;j_:,\u0012!\u0019\t\u0003E.t!aY5\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019\u001c\u0016A\u0002\u001fs_>$hHC\u0001i\u0003\u0015\u00198-\u00197b\u0013\tQw-\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u00016h\u0003]\u0011X\r]8tSR|'/_&fsNdunY1uS>t\u0007%\u0001\nsKB|7/\u001b;pefdunY1uS>t\u0017a\u0005:fa>\u001c\u0018\u000e^8ss2{7-\u0019;j_:\u0004\u0013\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u!\t\u0019h/D\u0001u\u0015\t)x-\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u001e;\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0002{{z$\"a\u001f?\u0011\u0005Y\u0003\u0001\"B9\u0007\u0001\b\u0011\b\"B0\u0007\u0001\u0004\t\u0007\"B8\u0007\u0001\u0004\t\u0017\u0001D2m_:,w\n\u001d;j_:\u001cH\u0003BA\u0002\u0003+\u0001R!!\u0002\u0002\u0010\u0005tA!a\u0002\u0002\f9\u0019A-!\u0003\n\u0003!L1!!\u0004h\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0005\u0002\u0014\t\u00191+Z9\u000b\u0007\u00055q\rC\u0004\u0002\u0018\u001d\u0001\r!!\u0007\u0002\u0013I,7-\u001e:tSZ,\u0007\u0003BA\u000e\u0003;i\u0011aZ\u0005\u0004\u0003?9'a\u0002\"p_2,\u0017M\\\u0001\u000ba\u0006$\b\u000e\u0015:fM&D\u0018AD<ji\"\u0014V\r]8tSR|'/_\u000b\u0005\u0003O\t\t\u0004\u0006\u0004\u0002*\u0005U\u0014q\u0010\u000b\u0005\u0003W\tY\u0006\u0006\u0003\u0002.\u0005\r\u0003\u0003BA\u0018\u0003ca\u0001\u0001B\u0004\u00024%\u0011\r!!\u000e\u0003\u0003Q\u000bB!a\u000e\u0002>A!\u00111DA\u001d\u0013\r\tYd\u001a\u0002\b\u001d>$\b.\u001b8h!\u0011\tY\"a\u0010\n\u0007\u0005\u0005sMA\u0002B]fDq!!\u0012\n\u0001\b\t9%\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u0004B!!\u0013\u0002X5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%A\u0004d_:$X\r\u001f;\u000b\t\u0005E\u00131K\u0001\bY><w-\u001b8h\u0015\r\t)&U\u0001\u000bM>,h\u000eZ1uS>t\u0017\u0002BA-\u0003\u0017\u0012\u0011\u0003\u0015:pU\u0016\u001cG\u000fT8h\u0007>tG/\u001a=u\u0011\u001d\ti&\u0003a\u0001\u0003?\nQA\u00197pG.\u0004\u0002\"a\u0007\u0002b\u0005\u0015\u0014QF\u0005\u0004\u0003G:'!\u0003$v]\u000e$\u0018n\u001c82!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\n!![8\u000b\u0005\u0005=\u0014\u0001\u00026bm\u0006LA!a\u001d\u0002j\t!a)\u001b7f\u0011\u001d\t9(\u0003a\u0001\u0003s\nq\u0001\u001d:pU\u0016\u001cG\u000fE\u0002W\u0003wJ1!! N\u00059\u0001&o\u001c6fGR\u0014V-];fgRD\u0011\"!!\n!\u0003\u0005\r!!\u0007\u0002\u0017\u0019|'oY3Va\u0012\fG/Z\u0001\u0019o&$\bNU3q_NLGo\u001c:zI\u0011,g-Y;mi\u0012\u0012T\u0003BAD\u0003;+\"!!#+\t\u0005e\u00111R\u0016\u0003\u0003\u001b\u0003B!a$\u0002\u001a6\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b)*A\u0005v]\u000eDWmY6fI*\u0019\u0011qS4\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001c\u0006E%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00129\u00111\u0007\u0006C\u0002\u0005U\u0012\u0001E;qI\u0006$XMU3q_NLGo\u001c:z)\u0011\t\u0019+!,\u0015\t\u0005\u0015\u00161\u0016\t\u0005\u00037\t9+C\u0002\u0002*\u001e\u0014A!\u00168ji\"9\u0011QI\u0006A\u0004\u0005\u001d\u0003bBAX\u0017\u0001\u0007\u0011\u0011P\u0001\u000faJ|'.Z2u%\u0016\fX/Z:u\u0003I\u0001X\u000f\u001c7DQ\u0006tw-Z:Pe\u000ecwN\\3\u0015\u0011\u0005U\u00161ZAh\u0003'$b!!*\u00028\u0006%\u0007bBA]\u0019\u0001\u000f\u00111X\u0001\u0002YB!\u0011QXAb\u001d\rQ\u0016qX\u0005\u0004\u0003\u0003\\\u0016a\u0004$jY\u0016\u001c\u0016p\u001d;f[2{7m[:\n\t\u0005\u0015\u0017q\u0019\u0002\u0005\u0019>\u001c7NC\u0002\u0002BnCq!!\u0012\r\u0001\b\t9\u0005C\u0004\u0002N2\u0001\r!!\u001f\u0002\u0015A\u0014xN[3diJ+\u0017\u000fC\u0004\u0002R2\u0001\r!!\u001a\u0002\u0015A\u0014xN[3di\u0012K'\u000fC\u0004\u0002V2\u0001\r!!\u0007\u0002\u001f\rdwN\\3Tk\nlw\u000eZ;mKN$\"\"!7\u0002`\u0006\u0005\u00181]As)\u0019\t)'a7\u0002^\"9\u0011\u0011X\u0007A\u0004\u0005m\u0006bBA#\u001b\u0001\u000f\u0011q\t\u0005\b\u0003oj\u0001\u0019AA=\u0011\u001d\t\t.\u0004a\u0001\u0003KBq!!!\u000e\u0001\u0004\tI\u0002C\u0004\u0002V6\u0001\r!!\u0007\u0002\u001b\rdW-\u00198B]\u0012\u001cEn\u001c8f)!\tY/!=\u0002t\u0006UHCBAS\u0003[\fy\u000fC\u0004\u0002::\u0001\u001d!a/\t\u000f\u0005\u0015c\u0002q\u0001\u0002H!9\u0011Q\u001a\bA\u0002\u0005e\u0004bBAi\u001d\u0001\u0007\u0011Q\r\u0005\b\u0003+t\u0001\u0019AA\r\u000359W\r^!mY\u000e{W.\\5ugR!\u00111 B\u0006)\u0011\tiP!\u0003\u0011\r\u0005\u0015\u0011q B\u0002\u0013\u0011\u0011\t!a\u0005\u0003\t1K7\u000f\u001e\t\u0004-\n\u0015\u0011b\u0001B\u0004\u001b\n\u0011r)\u001b;D_6l\u0017\u000e^,ji\"Le\u000eZ3y\u0011\u001d\t)e\u0004a\u0002\u0003\u000fBq!a\u001e\u0010\u0001\u0004\tI(\u0001\thKR\u0014%/\u00198dQ\u000e{W.\\5ugRA!\u0011\u0003B\u000f\u0005?\u0011I\u0003\u0006\u0003\u0003\u0014\tm\u0001CBA\u0003\u0003\u007f\u0014)\u0002E\u0002W\u0005/I1A!\u0007N\u0005%9\u0015\u000e^\"p[6LG\u000fC\u0004\u0002FA\u0001\u001d!a\u0012\t\u000f\u0005]\u0004\u00031\u0001\u0002z!9!\u0011\u0005\tA\u0002\t\r\u0012A\u00022sC:\u001c\u0007\u000eE\u0002W\u0005KI1Aa\nN\u00055\u0011%/\u00198dQJ+\u0017/^3ti\"I!1\u0006\t\u0011\u0002\u0003\u0007!QF\u0001\u0006Y&l\u0017\u000e\u001e\t\u0007\u00037\u0011yCa\r\n\u0007\tErM\u0001\u0004PaRLwN\u001c\t\u0005\u00037\u0011)$C\u0002\u00038\u001d\u00141!\u00138u\u0003i9W\r\u001e\"sC:\u001c\u0007nQ8n[&$8\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011iD\u000b\u0003\u0003.\u0005-E\u0003\u0003B!\u0005\u001b\u0012yE!\u0015\u0015\t\t\r#1\n\t\u0007\u0003\u000b\tyP!\u0012\u0011\u0007Y\u00139%C\u0002\u0003J5\u0013QbQ8n[&$(+Z9vKN$\bbBA#%\u0001\u000f\u0011q\t\u0005\b\u0003o\u0012\u0002\u0019AA=\u0011\u001d\u0011\tC\u0005a\u0001\u0005GAqAa\u000b\u0013\u0001\u0004\u0011)\u0005\u0006\u0004\u0003V\te#1\f\u000b\u0005\u0005'\u00119\u0006C\u0004\u0002FM\u0001\u001d!a\u0012\t\u000f\u0005]4\u00031\u0001\u0002z!9!QL\nA\u0002\t}\u0013\u0001\u00032sC:\u001c\u0007.Z:\u0011\r\u0005\u0015\u0011q\u0002B\u0012\u0003I1\u0017N\u001c3D_6lwN\\!oG\u0016\u001cHo\u001c:\u0015\u0011\t\u0015$1\u000eB7\u0005c\"BAa\u001a\u0003jA1\u00111\u0004B\u0018\u0005\u000bBq!!\u0012\u0015\u0001\b\t9\u0005C\u0004\u0002xQ\u0001\r!!\u001f\t\u000f\t=D\u00031\u0001\u0003$\u000511o\\;sG\u0016DqAa\u001d\u0015\u0001\u0004\u0011\u0019#A\u0006eKN$\u0018N\\1uS>t\u0017aD2mK\u0006t\u0007K]8kK\u000e$H)\u001b:\u0015\t\te$Q\u0010\u000b\u0005\u0003K\u0013Y\bC\u0004\u0002FU\u0001\u001d!a\u0012\t\r\t}T\u00031\u0001b\u0003)\u0001(o\u001c6fGR,&\u000f\\\u0001\u0013e\u0016\u001c'/Z1uKB\u0013xN[3di\u0012K'\u000f\u0006\u0003\u0003\u0006\n%E\u0003BAS\u0005\u000fCq!!\u0012\u0017\u0001\b\t9\u0005C\u0004\u0002RZ\u0001\r!!\u001a\u0002\u001d\u001d,G\u000f\u0015:pU\u0016\u001cG\u000fU1uQR!\u0011Q\rBH\u0011\u0019\u0011\tj\u0006a\u0001C\u0006!\u0011.\u001e:m\u0003M9WM\\3sCR,\u0007K]8kK\u000e$H)\u0019;b)\u0011\u00119J!)\u0015\t\te%q\u0014\t\u0004-\nm\u0015b\u0001BO\u001b\nq!+\u001a9pg&$xN]=ECR\f\u0007bBA#1\u0001\u000f\u0011q\t\u0005\b\u0005GC\u0002\u0019\u0001BS\u0003\u00191\u0018\r\\;fgB)!Ma*bC&\u0019!\u0011V7\u0003\u00075\u000b\u0007/A\u0006qk2d7\t[1oO\u0016\u001cHC\u0002BX\u0005g\u00139\f\u0006\u0003\u0002&\nE\u0006bBA#3\u0001\u000f\u0011q\t\u0005\b\u0005kK\u0002\u0019AA3\u0003\r!\u0017N\u001d\u0005\b\u0005sK\u0002\u0019AA=\u0003\u001d\u0011X-];fgR\fQa\u00197p]\u0016$\u0002Ba0\u0003F\n\u001d'\u0011\u001a\u000b\u0007\u0003K\u0013\tMa1\t\u000f\u0005e&\u0004q\u0001\u0002<\"9\u0011Q\t\u000eA\u0004\u0005\u001d\u0003b\u0002B[5\u0001\u0007\u0011Q\r\u0005\b\u0003oR\u0002\u0019AA=\u0011\u001d\t9B\u0007a\u0001\u00033\t\u0011\u0002\\5ti\u001aKG.Z:\u0015\u0011\t='\u0011\u001cBn\u0005?$BA!5\u0003XB\u0019aKa5\n\u0007\tUWJA\u0007HSRd\u0015n\u001d;SKN,H\u000e\u001e\u0005\b\u0003\u000bZ\u00029AA$\u0011\u001d\u0011)l\u0007a\u0001\u0003KBaA!8\u001c\u0001\u0004\t\u0017AB2p[6LG\u000fC\u0005\u0003bn\u0001\n\u00111\u0001\u0003.\u0005\u0019R.\u0019=GS2,7+\u001b>f\u0005f$Xm](qi\u0006\u0019B.[:u\r&dWm\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005a1\r[1oO\u0016$g)\u001b7fgR1!\u0011\u001eB|\u0005s$BAa;\u0003vB)!Q\u001eBzC6\u0011!q\u001e\u0006\u0004\u0005c<\u0017AC2pY2,7\r^5p]&!\u0011\u0011\u0003Bx\u0011\u001d\t)%\ba\u0002\u0003\u000fBqA!.\u001e\u0001\u0004\t)\u0007\u0003\u0004\u0003|v\u0001\r!Y\u0001\u000eGV\u0014(/\u001a8u\u0007>lW.\u001b;\u0002\u001b\u001d,GoQ8n[&$H)\u001b4g))\u0019\ta!\u0005\u0004\u0014\r]11\u0004\u000b\u0005\u0007\u0007\u0019y\u0001\u0005\u0003\u0004\u0006\r-QBAB\u0004\u0015\r\u0019IaT\u0001\u0005I&4g-\u0003\u0003\u0004\u000e\r\u001d!AC\"p[6LG\u000fR5gM\"9\u0011Q\t\u0010A\u0004\u0005\u001d\u0003b\u0002B[=\u0001\u0007\u0011Q\r\u0005\b\u0007+q\u0002\u0019\u0001B#\u00031\u0019x.\u001e:dK\u000e{W.\\5u\u0011\u001d\u0019IB\ba\u0001\u0003\u0007\t!\u0003Z3ti&t\u0017\r^5p]\u000e{W.\\5ug\"91Q\u0004\u0010A\u0002\r}\u0011aA:mMB!!m!\tb\u0013\r\u0019\u0019#\u001c\u0002\u0004'\u0016$\u0018AE4fiB+H\u000e\u001c*fcV,7\u000f\u001e#jM\u001a$\"b!\u000b\u0004.\r=2\u0011GB\u001a)\u0011\u0019\u0019aa\u000b\t\u000f\u0005\u0015s\u0004q\u0001\u0002H!9!QW\u0010A\u0002\u0005\u0015\u0004b\u0002B8?\u0001\u0007!Q\t\u0005\u0007\u0005gz\u0002\u0019A1\t\u000f\ruq\u00041\u0001\u0004 \u0005yq-\u001a;GS2,7i\u001c8uK:$8\u000f\u0006\u0005\u0004:\r\r3QIB$)\u0011\u0019Yd!\u0011\u0011\u0007Y\u001bi$C\u0002\u0004@5\u0013qbR5u\r&dWmQ8oi\u0016tGo\u001d\u0005\b\u0003\u000b\u0002\u00039AA$\u0011\u001d\u0011)\f\ta\u0001\u0003KBqA!8!\u0001\u0004\u0011)\u0005\u0003\u0004\u0004J\u0001\u0002\r!Y\u0001\tM&dWM\\1nK\u0006qA.[:u\u00032d7i\\7nSR\u001cH\u0003BB(\u0007'\"B!!@\u0004R!9\u0011QI\u0011A\u0004\u0005\u001d\u0003b\u0002B[C\u0001\u0007\u0011QM\u0001\u0012Y&\u001cHO\u0011:b]\u000eD7i\\7nSR\u001cHCCB-\u0007;\u001ayf!\u0019\u0004dQ!!1CB.\u0011\u001d\t)E\ta\u0002\u0003\u000fBqA!.#\u0001\u0004\t)\u0007C\u0004\u0002x\t\u0002\r!!\u001f\t\u000f\t\u0005\"\u00051\u0001\u0003$!9!1\u0006\u0012A\u0002\t5\u0012a\u00057jgR\u0014%/\u00198dQ\u0016\u001c8i\\7nSR\u001cHCBB5\u0007[\u001ay\u0007\u0006\u0003\u0003\u0014\r-\u0004bBA#G\u0001\u000f\u0011q\t\u0005\b\u0005k\u001b\u0003\u0019AA3\u0011\u001d\u0011if\ta\u0001\u0005?\"\"ba\u001d\u0004x\re41PB?)\u0011\u0011\u0019e!\u001e\t\u000f\u0005\u0015C\u0005q\u0001\u0002H!9!Q\u0017\u0013A\u0002\u0005\u0015\u0004bBA<I\u0001\u0007\u0011\u0011\u0010\u0005\b\u0005C!\u0003\u0019\u0001B\u0012\u0011\u001d\u0019y\b\na\u0001\u0005\u000b\n1\u0002\\5nSR\u001cu.\\7ji\u0006\u0011\u0002/\u0019:tK\n\u0013\u0018M\\2i\u0007>lW.\u001b;t)\u0019\u0019)i!#\u0004\u000eR!!1CBD\u0011\u001d\t)%\na\u0002\u0003\u000fBqaa#&\u0001\u0004\t\u0019!\u0001\u0004m_\u001e\u001cU\u000e\u001a\u0005\b\u0005k+\u0003\u0019AA3)!\u0019\tj!&\u0004\u0018\u000eeE\u0003\u0002B4\u0007'Cq!!\u0012'\u0001\b\t9\u0005C\u0004\u00036\u001a\u0002\r!!\u001a\t\u000f\t=d\u00051\u0001\u0003$!9!1\u000f\u0014A\u0002\t\r\u0012AE,sSR,w)\u001b;SKB|7/\u001b;pef\u0004\"A\u0016\u0015\u0014\u000b!\u001a\tka*\u0011\t\u0005m11U\u0005\u0004\u0007K;'AB!osJ+g\r\u0005\u0003\u0002J\r%\u0016\u0002BBV\u0003\u0017\u0012abQ8oi\u0016DH\u000fT8hO&tw\r\u0006\u0002\u0004\u001e\u0006A\u0001O\u001d)sK\u001aL\u00070\u0006\u0002\u00044B!1QWB^\u001b\t\u00199L\u0003\u0003\u0004:\u00065\u0014\u0001\u00027b]\u001eL1\u0001\\B\\\u0003%\u0001(\u000f\u0015:fM&D\b%A\u0002tKB\fAa]3qA\u0005\u0019Qm\u001c7\u0002\t\u0015|G\u000eI\u0001\rG>lW.\u001b;G_Jl\u0017\r^\u0001\u000eG>lW.\u001b;G_Jl\u0017\r\u001e\u0011\u0002\u0017\r{W.\\5u\u001b\u0006$8\r[\u000b\u0003\u0007\u001f\u0004Ba!5\u0004\\6\u001111\u001b\u0006\u0005\u0007+\u001c9.\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\r\u0019InZ\u0001\u0005kRLG.\u0003\u0003\u0004^\u000eM'!\u0002*fO\u0016D\u0018\u0001D\"p[6LG/T1uG\"\u0004\u0013!\u00033jM\u001a4E.Y4t+\t\u0019)\u000f\u0005\u0004\u0003n\nM81W\u0001\u000bI&4gM\u00127bON\u0004\u0013!\u00053jM\u001a\u001cu.\\7b]\u0012\u0004&/\u001a4jq\u0006\u0011B-\u001b4g\u0007>lW.\u00198e!J,g-\u001b=!\u0003)!\u0017N\u001a4Qe\u00164\u0017\u000e_\u0001\u000bI&4gmU;gM&DH\u0003BBz\u0007k\u0004R!!\u0002\u0002\u0000\u0006Dqaa>:\u0001\u0004\u0019y\"A\u0003gS2,7/A\bHSR4\u0015\u000e\\3SKN\u0004xN\\:f\u00039I7oU=nE>d\u0017n\u0019'j].$B!!\u0007\u0004\u0000\"1A\u0011A\u001eA\u0002\u0005\f\u0011a]\u0001\tSN\u001cu.\\7jiR!\u0011\u0011\u0004C\u0004\u0011\u0019!\t\u0001\u0010a\u0001C\u0006y\u0012\r\u001a3Pe&<\u0017N\u001c*fM\u0016\u0014XM\\2f\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\t\u00115A\u0011\u0003\u000b\u0005\u0003K#y\u0001C\u0004\u0002Fu\u0002\u001d!a\u0012\t\u000f\tUV\b1\u0001\u0002f\u0005\t\u0013\r\u001a3HSRDUO\u0019)vY2\u0014V-];fgR\u001cuN\u001c4jOV\u0014\u0018\r^5p]R!Aq\u0003C\u000e)\u0011\t)\u000b\"\u0007\t\u000f\u0005\u0015c\bq\u0001\u0002H!9!Q\u0017 A\u0002\u0005\u0015\u0014\u0001D1eI\u001eKGoQ8oM&<G\u0003\u0003C\u0011\tK!9\u0003b\u000b\u0015\t\u0005\u0015F1\u0005\u0005\b\u0003\u000bz\u00049AA$\u0011\u001d\u0011)l\u0010a\u0001\u0003KBa\u0001\"\u000b@\u0001\u0004\t\u0017\u0001\u00028b[\u0016Da\u0001\"\f@\u0001\u0004\t\u0017!\u0002<bYV,\u0017aC5t-\u0006d\u0017\u000e\u001a*fa>$b\u0001b\r\u0005:\u0011mB\u0003\u0002C\u001b\to\u0001b!a\u0007\u00030\u0005e\u0001bBA#\u0001\u0002\u000f\u0011q\t\u0005\b\u0005k\u0003\u0005\u0019AA3\u0011%!i\u0004\u0011I\u0001\u0002\u0004!y$\u0001\u0006d_6l\u0017\u000e^+vS\u0012\u0004R!a\u0007\u00030\u0005\fQ#[:WC2LGMU3q_\u0012\"WMZ1vYR$#'\u0006\u0002\u0005F)\"AqHAF)\u0011!I\u0005\"\u0014\u0015\t\teE1\n\u0005\b\u0003\u000b\u0012\u00059AA$\u0011\u001d\u0011\u0019K\u0011a\u0001\u0005K\u000ba\u0002]1sg\u0016\u001cu.\\7ji2{w\r\u0006\u0003\u0005T\u0011eC\u0003\u0002C+\t/\u0002b!a\u0007\u00030\tU\u0001bBA#\u0007\u0002\u000f\u0011q\t\u0005\u0007\t7\u001a\u0005\u0019A1\u0002\u0013\r|W.\\5u\u0019><\u0017A\u0003\"mC6,W*\u0019;dQ\u0006Y!\t\\1nK6\u000bGo\u00195!\u0003%1\u0015\u000e\\3NCR\u001c\u0007.\u0001\u0006GS2,W*\u0019;dQ\u0002\n!\u0002]1sg\u0016\u0014E.Y7f)\u0019!I\u0007\"\u001d\u0005vA1\u00111\u0004B\u0018\tW\u00022A\u0016C7\u0013\r!y'\u0014\u0002\u0006\u00052\fW.\u001a\u0005\u0007\tgB\u0005\u0019A1\u0002\u0015\td\u0017-\\3MS:,\u0017\u0007\u0003\u0004\u0005x!\u0003\r!Y\u0001\u000bE2\fW.\u001a'j]\u0016\u0014\u0014!\u0004#jM\u001ad\u0015N\\3MS6LG/\u0006\u0002\u00034\u0005qA)\u001b4g\u0019&tW\rT5nSR\u0004\u0013aE3yK\u000e,H/Z!oIB\u000b'o]3ES\u001a4GC\u0002CB\t\u000f#Y\t\u0006\u0003\u0004\u0004\u0011\u0015\u0005bBA#\u0017\u0002\u000f\u0011q\t\u0005\b\t\u0013[\u0005\u0019AA\u0002\u0003-!\u0017N\u001a4D_6l\u0017M\u001c3\t\u000f\tU6\n1\u0001\u0002f\u0001")
public abstract class WriteGitRepository
extends GitRepository
implements FileSystemLocks {
    private final String repositoryKeysLocation;
    private final String repositoryLocation;

    public static Regex FileMatch() {
        return WriteGitRepository$.MODULE$.FileMatch();
    }

    public static Regex BlameMatch() {
        return WriteGitRepository$.MODULE$.BlameMatch();
    }

    public static String commitFormat() {
        return WriteGitRepository$.MODULE$.commitFormat();
    }

    public static String eol() {
        return WriteGitRepository$.MODULE$.eol();
    }

    public static String sep() {
        return WriteGitRepository$.MODULE$.sep();
    }

    public static String prPrefix() {
        return WriteGitRepository$.MODULE$.prPrefix();
    }

    @Override
    public <A> A lock(File file, long maxTime, Function1<FileSystemLocks.Lock, A> method) {
        return (A)FileSystemLocks.lock$(this, file, maxTime, method);
    }

    @Override
    public <A> long lock$default$2() {
        return FileSystemLocks.lock$default$2$(this);
    }

    public String repositoryKeysLocation() {
        return this.repositoryKeysLocation;
    }

    public String repositoryLocation() {
        return this.repositoryLocation;
    }

    public Seq<String> cloneOptions(boolean recursive) {
        if (recursive) {
            return (Seq)new .colon.colon((Object)"--recursive", (List)Nil$.MODULE$);
        }
        return (Seq)Nil$.MODULE$;
    }

    public String pathPrefix() {
        return "p_";
    }

    public abstract <T> T withRepository(ProjectRequest var1, boolean var2, Function1<File, T> var3, ProjectLogContext var4);

    public <T> boolean withRepository$default$2() {
        return false;
    }

    public abstract void updateRepository(ProjectRequest var1, ProjectLogContext var2);

    public void pullChangesOrClone(ProjectRequest projectReq, File projectDir, boolean cloneSubmodules, FileSystemLocks.Lock l, ProjectLogContext logContext) {
        this.logger().info(new StringBuilder(43).append("Updating repository with cloneSubmodules = ").append(cloneSubmodules).toString(), (LogContext)logContext);
        Option<Object> isValidHeadRsp = WriteGitRepository$.MODULE$.isValidRepo(projectDir, WriteGitRepository$.MODULE$.isValidRepo$default$2(), logContext);
        boolean isValidHead = BoxesRunTime.unboxToBoolean((Object)isValidHeadRsp.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        if (isValidHead) {
            this.pullChanges(projectDir, projectReq, logContext);
            return;
        }
        this.cleanAndClone(projectReq, projectDir, cloneSubmodules, l, logContext);
    }

    public File pullChangesOrClone(ProjectRequest project, File projectDir, boolean forceUpdate, boolean cloneSubmodules, FileSystemLocks.Lock l, ProjectLogContext logContext) {
        block1: {
            Option<Object> isValidHeadRsp = WriteGitRepository$.MODULE$.isValidRepo(projectDir, WriteGitRepository$.MODULE$.isValidRepo$default$2(), logContext);
            boolean isValidHead = BoxesRunTime.unboxToBoolean((Object)isValidHeadRsp.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
            if (!isValidHead) {
                this.logger().warn(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(68).append("Forcing removal of HEAD ").append(projectDir.getAbsolutePath()).append(" under conditions:\n           |isValidHead: ").append(isValidHead).toString())).stripMargin(), (LogContext)logContext);
                this.cleanAndClone(project, projectDir, cloneSubmodules, l, logContext);
                return projectDir;
            }
            if (!forceUpdate) break block1;
            this.pullChanges(projectDir, project, logContext);
        }
        return projectDir;
    }

    private void cleanAndClone(ProjectRequest projectReq, File projectDir, boolean cloneSubmodules, FileSystemLocks.Lock l, ProjectLogContext logContext) {
        this.recreateProjectDir(projectDir, logContext);
        try {
            this.clone(projectDir, projectReq, cloneSubmodules, l, logContext);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable err = (Throwable)option.get();
                this.recreateProjectDir(projectDir, logContext);
                throw err;
            }
            throw throwable;
        }
    }

    public List<GitCommitWithIndex> getAllCommits(ProjectRequest project, ProjectLogContext logContext) {
        return (List)this.logger().time("Getting all commits", this.logger().time$default$2(), this.logger().time$default$3(), (Function0 & Serializable & scala.Serializable)() -> (List)this.withRepository(project, this.withRepository$default$2(), (Function1 & Serializable & scala.Serializable)directory -> this.listAllCommits((File)directory, logContext), logContext), (LogContext)logContext);
    }

    public List<GitCommit> getBranchCommits(ProjectRequest project, BranchRequest branch, Option<Object> limit, ProjectLogContext logContext) {
        return (List)this.logger().time(new StringBuilder(34).append("Getting branch commits for branch ").append(branch.name()).toString(), this.logger().time$default$2(), this.logger().time$default$3(), (Function0 & Serializable & scala.Serializable)() -> (List)this.withRepository(project, this.withRepository$default$2(), (Function1 & Serializable & scala.Serializable)directory -> this.listBranchCommits((File)directory, project, branch, limit, logContext), logContext), (LogContext)logContext);
    }

    public List<CommitRequest> getBranchCommits(ProjectRequest project, BranchRequest branch, CommitRequest limit, ProjectLogContext logContext) {
        return (List)this.logger().time(new StringBuilder(34).append("Getting branch commits for branch ").append(branch.name()).toString(), this.logger().time$default$2(), this.logger().time$default$3(), (Function0 & Serializable & scala.Serializable)() -> (List)this.withRepository(project, this.withRepository$default$2(), (Function1 & Serializable & scala.Serializable)directory -> this.listBranchCommits((File)directory, project, branch, limit, logContext), logContext), (LogContext)logContext);
    }

    public List<GitCommit> getBranchCommits(ProjectRequest project, Seq<BranchRequest> branches, ProjectLogContext logContext) {
        return (List)this.logger().time("Getting commits for selected branches", this.logger().time$default$2(), this.logger().time$default$3(), (Function0 & Serializable & scala.Serializable)() -> (List)this.withRepository(project, this.withRepository$default$2(), (Function1 & Serializable & scala.Serializable)directory -> this.listBranchesCommits((File)directory, branches, logContext), logContext), (LogContext)logContext);
    }

    public Option<Object> getBranchCommits$default$3() {
        return None$.MODULE$;
    }

    public Option<CommitRequest> findCommonAncestor(ProjectRequest project, BranchRequest source, BranchRequest destination, ProjectLogContext logContext) {
        return (Option)this.logger().time(new StringBuilder(45).append("Getting common ancestor commit for branches ").append(source.name()).append(":").append(destination.name()).toString(), this.logger().time$default$2(), this.logger().time$default$3(), (Function0 & Serializable & scala.Serializable)() -> (Option)this.withRepository(project, this.withRepository$default$2(), (Function1 & Serializable & scala.Serializable)directory -> this.findCommonAncestor((File)directory, source, destination, logContext), logContext), (LogContext)logContext);
    }

    public void cleanProjectDir(String projectUrl, ProjectLogContext logContext) {
        File projectDir = this.getProjectPath(projectUrl);
        this.lock(projectDir, this.lock$default$2(), (Function1 & Serializable & scala.Serializable)l -> {
            this.recreateProjectDir(projectDir, logContext);
            return BoxedUnit.UNIT;
        });
    }

    private void recreateProjectDir(File projectDir, ProjectLogContext logContext) {
        FileOperations$.MODULE$.deleteDirectory(projectDir, logContext);
        FileOperations$.MODULE$.createDirectory(projectDir, logContext);
    }

    public File getProjectPath(String iurl) {
        return Paths.get(this.repositoryLocation(), new String[0]).resolve(new StringBuilder(0).append(this.pathPrefix()).append(new StringOps(Predef$.MODULE$.augmentString(CryptoTools$.MODULE$.sha256Alphanumeric(iurl).toLowerCase())).take(16)).toString()).toFile();
    }

    public RepositoryData generateProjectData(Map<String, String> values, ProjectLogContext logContext) {
        return WriteGitRepository$.MODULE$.generateProjectData(values, logContext);
    }

    public void pullChanges(File dir, ProjectRequest request, ProjectLogContext logContext) {
        Seq command = (Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"fetch", (List)new .colon.colon((Object)"--all", (List)new .colon.colon((Object)"--prune", (List)new .colon.colon((Object)"--force", (List)Nil$.MODULE$)))));
        Seq<String> commandWithAuth = this.wrapCommandWithAuthorization(request, (Seq<String>)command, logContext);
        GitCommandRunner$.MODULE$.execNoOutput(commandWithAuth, (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.execNoOutput$default$3(), logContext);
    }

    private void clone(File dir, ProjectRequest project, boolean recursive, FileSystemLocks.Lock l, ProjectLogContext logContext) {
        RepositoryData projectData;
        String url = this.processProjectUrl(project, logContext);
        Seq cmd = (Seq)((TraversableLike)((TraversableLike)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"clone", (List)Nil$.MODULE$))).$plus$plus(this.cloneOptions(recursive), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)url, (List)new .colon.colon((Object)dir.getAbsolutePath(), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom());
        RepositoryData repositoryData = project.data();
        RepositoryData x$1 = projectData = repositoryData instanceof AccessTokenRepositoryData ? EmptyRepositoryData$.MODULE$ : repositoryData;
        String x$2 = project.copy$default$1();
        Seq<String> cloneCommand = this.wrapCommandWithAuthorization(project.copy(x$2, x$1), (Seq<String>)cmd, logContext);
        GitCommandRunner$.MODULE$.execNoOutput(cloneCommand, (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.execNoOutput$default$3(), logContext);
        BoxedUnit cloneCmdResponse = BoxedUnit.UNIT;
        WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$addOriginReferenceConfiguration(dir, logContext);
        WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$addGitHubPullRequestConfiguration(dir, logContext);
        this.pullChanges(dir, project, logContext);
    }

    public GitListResult listFiles(File dir, String commit, Option<Object> maxFileSizeBytesOpt, ProjectLogContext logContext) {
        this.logger().debug(new StringBuilder(17).append("Listing files in ").append(dir.getAbsolutePath()).toString(), (LogContext)logContext);
        List files = ((ListBuffer)((SeqLike)GitCommandRunner$.MODULE$.exec((Seq<String>)((Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"ls-tree", (List)new .colon.colon((Object)"-l", (List)new .colon.colon((Object)"-r", (List)new .colon.colon((Object)commit, (List)Nil$.MODULE$)))))), (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(prev, line) -> {
            String string = line;
            Option option = WriteGitRepository$.MODULE$.GitFileResponse().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(5) == 0) {
                String mode = (String)((LinearSeqOptimized)option.get()).apply(0);
                String t = (String)((LinearSeqOptimized)option.get()).apply(1);
                String hash = (String)((LinearSeqOptimized)option.get()).apply(2);
                String size = (String)((LinearSeqOptimized)option.get()).apply(3);
                String filename = (String)((LinearSeqOptimized)option.get()).apply(4);
                if (!WriteGitRepository$.MODULE$.isSymbolicLink(mode) && !WriteGitRepository$.MODULE$.isCommit(t)) {
                    return prev.$plus$eq((Object)new GitFile(filename, hash, new StringOps(Predef$.MODULE$.augmentString(size)).toInt()));
                }
            }
            return prev;
        }, logContext)).distinct()).toList();
        Option<Object> option = maxFileSizeBytesOpt;
        if (None$.MODULE$.equals(option)) {
            return new GitListResult((List<GitFile>)files, (List<GitFile>)Nil$.MODULE$);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            int maxFileSize = BoxesRunTime.unboxToInt((Object)some.value());
            return (GitListResult)GitListResult$.MODULE$.tupled().apply((Object)files.partition((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WriteGitRepository.$anonfun$listFiles$2(maxFileSize, x$1))));
        }
        throw new MatchError(option);
    }

    public Option<Object> listFiles$default$3() {
        return Option$.MODULE$.empty();
    }

    public Seq<String> changedFiles(File dir, String currentCommit, ProjectLogContext logContext) {
        this.logger().debug(new StringBuilder(28).append("Retrieving changed files in ").append(dir.getAbsolutePath()).toString(), (LogContext)logContext);
        return (Seq)GitCommandRunner$.MODULE$.exec((Seq<String>)((Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"show", (List)new .colon.colon((Object)"--first-parent", (List)new .colon.colon((Object)"--pretty=format:", (List)new .colon.colon((Object)"--name-only", (List)new .colon.colon((Object)currentCommit, (List)Nil$.MODULE$))))))), (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(prev, line) -> {
            String trimmed = line.trim();
            if (new StringOps(Predef$.MODULE$.augmentString(trimmed)).nonEmpty()) {
                return prev.$plus$eq((Object)line.trim());
            }
            return prev;
        }, logContext);
    }

    public CommitDiff getCommitDiff(File dir, CommitRequest sourceCommit, Seq<String> destinationCommits, Set<String> slf, ProjectLogContext logContext) {
        Seq seq = (Seq)destinationCommits.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)WriteGitRepository.$anonfun$getCommitDiff$1(x$2)));
        Seq diffCommand = seq.length() > 1 ? (Seq)((TraversableLike)WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$diffCommandPrefix().$plus$plus((GenTraversableOnce)new .colon.colon((Object)sourceCommit.uuid(), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus(destinationCommits, Seq$.MODULE$.canBuildFrom()) : (Seq)seq.lastOption().fold((Function0 & Serializable & scala.Serializable)() -> (Seq)((TraversableLike)((TraversableLike)((TraversableLike)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"show", (List)new .colon.colon((Object)"--format=", (List)Nil$.MODULE$)))).$plus$plus(WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$diffPrefix(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)sourceCommit.uuid(), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus(WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$diffSuffix(slf), Seq$.MODULE$.canBuildFrom()), (Function1 & Serializable & scala.Serializable)lastCommit -> (Seq)((TraversableLike)WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$diffCommandPrefix().$plus$plus((GenTraversableOnce)new .colon.colon(lastCommit, (List)new .colon.colon((Object)sourceCommit.uuid(), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())).$plus$plus(WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$diffSuffix(slf), Seq$.MODULE$.canBuildFrom()));
        return WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$executeAndParseDiff((Seq<String>)diffCommand, dir, logContext);
    }

    public CommitDiff getPullRequestDiff(File dir, CommitRequest source, String destination, Set<String> slf, ProjectLogContext logContext) {
        Seq command = (Seq)((TraversableLike)WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$diffCommandPrefix().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new StringBuilder(3).append(destination).append("...").append(source.uuid()).toString(), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus(WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$diffSuffix(slf), Seq$.MODULE$.canBuildFrom());
        this.logger().info(new StringBuilder(31).append("Getting pull request diff. cmd:").append(command.mkString(" ")).toString(), (LogContext)logContext);
        return WriteGitRepository$.MODULE$.codacy$git$repository$WriteGitRepository$$executeAndParseDiff((Seq<String>)command, dir, logContext);
    }

    public GitFileContents getFileContents(File dir, CommitRequest commit, String filename, ProjectLogContext logContext) {
        Seq command = (Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"show", (List)new .colon.colon((Object)new StringBuilder(1).append(commit.uuid()).append(":").append(filename).toString(), (List)Nil$.MODULE$)));
        return new GitFileContents(filename, (List<String>)((ListBuffer)GitCommandRunner$.MODULE$.exec((Seq<String>)command, (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(acc, line) -> acc.$plus$eq(line), logContext)).toList(), GitFileContents$.MODULE$.apply$default$3());
    }

    public List<GitCommitWithIndex> listAllCommits(File dir, ProjectLogContext logContext) {
        Seq logCmd = (Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"log", (List)new .colon.colon((Object)"--all", (List)new .colon.colon((Object)"--encoding=UTF-8", (List)new .colon.colon((Object)"--date=local", (List)new .colon.colon((Object)new StringBuilder(16).append("--pretty=format:").append(WriteGitRepository$.MODULE$.commitFormat()).toString(), (List)Nil$.MODULE$))))));
        return ((ListBuffer)((TraversableLike)((IterableLike)GitCommandRunner$.MODULE$.exec((Seq<String>)logCmd, (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(prev, line) -> {
            Option<GitCommit> option = WriteGitRepository$.MODULE$.parseCommitLog((String)line, logContext);
            if (option instanceof Some) {
                GitCommit commit;
                Some some = (Some)option;
                GitCommit gitCommit = commit = (GitCommit)some.value();
                return prev.$plus$eq$colon((Object)gitCommit);
            }
            if (None$.MODULE$.equals(option)) {
                return prev;
            }
            throw new MatchError(option);
        }, logContext)).zipWithIndex(ListBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                GitCommit e = (GitCommit)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (e != null) {
                    GitCommit gitCommit = e;
                    int n = i;
                    return new GitCommitWithIndex(gitCommit, n);
                }
            }
            throw new MatchError((Object)tuple2);
        }, ListBuffer$.MODULE$.canBuildFrom())).toList();
    }

    private List<GitCommit> listBranchCommits(File dir, ProjectRequest project, BranchRequest branch, Option<Object> limit, ProjectLogContext logContext) {
        Seq limitArgs = (Seq)limit.map((Function1 & Serializable & scala.Serializable)l -> WriteGitRepository.$anonfun$listBranchCommits$1(BoxesRunTime.unboxToInt((Object)l))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        Seq<String> logCmd = this.wrapCommandWithAuthorization(project, (Seq<String>)((Seq)((TraversableLike)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"log", (List)new .colon.colon((Object)"--encoding=UTF-8", (List)new .colon.colon((Object)"--date=local", (List)new .colon.colon((Object)new StringBuilder(16).append("--pretty=format:").append(WriteGitRepository$.MODULE$.commitFormat()).toString(), (List)new .colon.colon((Object)new StringBuilder(15).append("remotes/origin/").append(branch.name()).toString(), (List)Nil$.MODULE$))))))).$plus$plus((GenTraversableOnce)limitArgs, Seq$.MODULE$.canBuildFrom())), logContext);
        return this.parseBranchCommits(logCmd, dir, logContext);
    }

    private List<GitCommit> listBranchesCommits(File dir, Seq<BranchRequest> branches, ProjectLogContext logContext) {
        Seq branchNames = (Seq)branches.map((Function1 & Serializable & scala.Serializable)branch -> new StringBuilder(15).append("remotes/origin/").append(branch.name()).toString(), Seq$.MODULE$.canBuildFrom());
        Seq logCmd = (Seq)((TraversableLike)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"log", (List)new .colon.colon((Object)"--encoding=UTF-8", (List)new .colon.colon((Object)"--date=local", (List)new .colon.colon((Object)new StringBuilder(16).append("--pretty=format:").append(WriteGitRepository$.MODULE$.commitFormat()).toString(), (List)Nil$.MODULE$)))))).$plus$plus((GenTraversableOnce)branchNames, Seq$.MODULE$.canBuildFrom());
        return this.parseBranchCommits((Seq<String>)logCmd, dir, logContext);
    }

    private List<CommitRequest> listBranchCommits(File dir, ProjectRequest project, BranchRequest branch, CommitRequest limitCommit, ProjectLogContext logContext) {
        Seq<String> cmd = this.wrapCommandWithAuthorization(project, (Seq<String>)((Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"rev-list", (List)new .colon.colon((Object)new StringBuilder(17).append(limitCommit.uuid()).append("..remotes/origin/").append(branch.name()).toString(), (List)Nil$.MODULE$)))), logContext);
        return ((ListBuffer)GitCommandRunner$.MODULE$.exec(cmd, (Option<File>)Option$.MODULE$.apply((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(prev, line) -> prev.$plus$eq((Object)new CommitRequest((String)line)), logContext)).toList();
    }

    private List<GitCommit> parseBranchCommits(Seq<String> logCmd, File dir, ProjectLogContext logContext) {
        return ((ListBuffer)GitCommandRunner$.MODULE$.exec(logCmd, (Option<File>)new Some((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(prev, line) -> {
            Option<GitCommit> option = WriteGitRepository$.MODULE$.parseCommitLog((String)line, logContext);
            if (option instanceof Some) {
                Some some = (Some)option;
                GitCommit commit = (GitCommit)some.value();
                return prev.$plus$eq((Object)commit);
            }
            if (None$.MODULE$.equals(option)) {
                return prev;
            }
            throw new MatchError(option);
        }, logContext)).toList();
    }

    private Option<CommitRequest> findCommonAncestor(File dir, BranchRequest source, BranchRequest destination, ProjectLogContext logContext) {
        Seq cmd = (Seq)new .colon.colon((Object)"git", (List)new .colon.colon((Object)"merge-base", (List)new .colon.colon((Object)new StringBuilder(15).append("remotes/origin/").append(source.name()).toString(), (List)new .colon.colon((Object)new StringBuilder(15).append("remotes/origin/").append(destination.name()).toString(), (List)Nil$.MODULE$))));
        return (Option)GitCommandRunner$.MODULE$.exec((Seq<String>)cmd, (Option<File>)Option$.MODULE$.apply((Object)dir), GitCommandRunner$.MODULE$.exec$default$3(), None$.MODULE$, (Function2 & Serializable & scala.Serializable)(prev, line) -> {
            Option option = prev;
            if (None$.MODULE$.equals(option)) {
                return new Some((Object)new CommitRequest((String)line));
            }
            return prev;
        }, logContext);
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$2(int maxFileSize$1, GitFile x$1) {
        return x$1.bytes() < maxFileSize$1;
    }

    public static final /* synthetic */ boolean $anonfun$getCommitDiff$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.trim())).nonEmpty();
    }

    public static final /* synthetic */ Seq $anonfun$listBranchCommits$1(int l) {
        return (Seq)new .colon.colon((Object)"-n", (List)new .colon.colon((Object)Integer.toString(l), (List)Nil$.MODULE$));
    }

    public WriteGitRepository(String repositoryKeysLocation, String repositoryLocation, ExecutionContext executionContext) {
        this.repositoryKeysLocation = repositoryKeysLocation;
        this.repositoryLocation = repositoryLocation;
        super(repositoryKeysLocation, executionContext);
        FileSystemLocks.$init$(this);
    }
}

