/*
 * Decompiled with CFR 0.152.
 */
package codacy.git.runners;

import codacy.foundation.logging.Logger;
import codacy.foundation.logging.context.LogContext;
import codacy.git.runners.CommandExecutionContext$;
import codacy.git.runners.ProcessResult;
import com.typesafe.scalalogging.LazyLogging;
import java.io.InputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.io.BufferedSource;
import scala.io.Source;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.sys.process.Process;
import scala.sys.process.ProcessIO;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u000e\u001d\u0001\rB\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\t\u000f\u0002\u0011\t\u0011)A\u0006\u0011\")a\n\u0001C\u0001\u001f\"9Q\u000b\u0001b\u0001\n\u00131\u0006BB0\u0001A\u0003%q\u000bC\u0004a\u0001\t\u0007I\u0011\u0002,\t\r\u0005\u0004\u0001\u0015!\u0003X\u0011\u001d\u0011\u0007A1A\u0005\n\rDa\u0001\u001c\u0001!\u0002\u0013!\u0007bB4\u0001\u0005\u0004%I!\u001c\u0005\u0007c\u0002\u0001\u000b\u0011\u00028\t\u000bI\u0004A\u0011A:\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!9\u0011q\u0002\u0001\u0005\n\u0005EqaBA\u00169!\u0005\u0011Q\u0006\u0004\u00077qA\t!a\f\t\r9\u0003B\u0011AA\u0019\u0011%\t\u0019\u0004\u0005b\u0001\n\u0013\t)\u0004\u0003\u0005\u0002BA\u0001\u000b\u0011BA\u001c\r\u0019\t\u0019\u0005\u0005\u0003\u0002F!Q\u0011Q\u0003\u000b\u0003\u0002\u0003\u0006I!a\u0006\t\r9#B\u0011AA'\r\u0019\t)\u0006\u0006\u0003\u0002X!1aj\u0006C\u0001\u0003KBq!!\u001b\u0018\t\u0003\nY\u0007C\u0004\u0002~Q!\t%a \u0003/\r{W.\\1oI\u0016CXmY;uS>t7i\u001c8uKb$(BA\u000f\u001f\u0003\u001d\u0011XO\u001c8feNT!a\b\u0011\u0002\u0007\u001dLGOC\u0001\"\u0003\u0019\u0019w\u000eZ1ds\u000e\u00011c\u0001\u0001%UA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\u0004\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\u000f1|wmZ5oO*\u0011q\u0006I\u0001\u000bM>,h\u000eZ1uS>t\u0017BA\u0019-\u0005\u0019aunZ4fe\u000691m\\7nC:$\u0007c\u0001\u001b=\u007f9\u0011QG\u000f\b\u0003mej\u0011a\u000e\u0006\u0003q\t\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0005m2\u0013a\u00029bG.\fw-Z\u0005\u0003{y\u00121aU3r\u0015\tYd\u0005\u0005\u0002A\t:\u0011\u0011I\u0011\t\u0003m\u0019J!a\u0011\u0014\u0002\rA\u0013X\rZ3g\u0013\t)eI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0007\u001a\n!\u0002\\8h\u0007>tG/\u001a=u!\tIE*D\u0001K\u0015\tYE&A\u0004d_:$X\r\u001f;\n\u00055S%A\u0003'pO\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"\"\u0001\u0015+\u0015\u0005E\u001b\u0006C\u0001*\u0001\u001b\u0005a\u0002\"B$\u0004\u0001\bA\u0005\"\u0002\u001a\u0004\u0001\u0004\u0019\u0014\u0001D:uI>,HOQ;gM\u0016\u0014X#A,\u0011\u0007akv(D\u0001Z\u0015\tQ6,A\u0004nkR\f'\r\\3\u000b\u0005q3\u0013AC2pY2,7\r^5p]&\u0011a,\u0017\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'/A\u0007ti\u0012|W\u000f\u001e\"vM\u001a,'\u000fI\u0001\rgR$WM\u001d:Ck\u001a4WM]\u0001\u000egR$WM\u001d:Ck\u001a4WM\u001d\u0011\u0002\u0013A\u0014xnY3tg&{U#\u00013\u0011\u0005\u0015TW\"\u00014\u000b\u0005\u001dD\u0017a\u00029s_\u000e,7o\u001d\u0006\u0003S\u001a\n1a]=t\u0013\tYgMA\u0005Qe>\u001cWm]:J\u001f\u0006Q\u0001O]8dKN\u001c\u0018j\u0014\u0011\u0016\u00039\u0004\"!Z8\n\u0005A4'a\u0002)s_\u000e,7o]\u0001\taJ|7-Z:tA\u0005yQ\r_3dkRLwN\u001c$viV\u0014X\r\u0006\u0002u{B\u0019Q\u000f\u001f>\u000e\u0003YT!a\u001e\u0014\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002zm\n1a)\u001e;ve\u0016\u0004\"AU>\n\u0005qd\"!\u0004)s_\u000e,7o\u001d*fgVdG\u000fC\u0003\u007f\u0019\u0001\u000fq0\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiB\u0019Q/!\u0001\n\u0007\u0005\raO\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u000691\r\\3b]V\u0004HCAA\u0005!\r)\u00131B\u0005\u0004\u0003\u001b1#\u0001B+oSR\fQc\u001e:ji\u0016$vNQ;gM\u0016\u0014\u0018I\u001c3DY>\u001cX\r\u0006\u0004\u0002\n\u0005M\u0011q\u0005\u0005\b\u0003+q\u0001\u0019AA\f\u0003-Ig\u000e];u'R\u0014X-Y7\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u0005\u0011\u0011n\u001c\u0006\u0003\u0003C\tAA[1wC&!\u0011QEA\u000e\u0005-Ie\u000e];u'R\u0014X-Y7\t\r\u0005%b\u00021\u0001X\u0003\u0019\u0011WO\u001a4fe\u000692i\\7nC:$W\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\t\u0003%B\u0019\"\u0001\u0005\u0013\u0015\u0005\u00055\u0012!B2pI\u0016\u001cWCAA\u001c!\u0011\tI$!\u0010\u000e\u0005\u0005m\"bAA\u000fM%!\u0011qHA\u001e\u0005\u0015\u0019u\u000eZ3d\u0003\u0019\u0019w\u000eZ3dA\tIrJ\u001c7z\u001d\u0016<H*\u001b8f\u0005V4g-\u001a:fIN{WO]2f'\r!\u0012q\t\t\u0005\u0003s\tI%\u0003\u0003\u0002L\u0005m\"A\u0004\"vM\u001a,'/\u001a3T_V\u00148-\u001a\u000b\u0005\u0003\u001f\n\u0019\u0006E\u0002\u0002RQi\u0011\u0001\u0005\u0005\b\u0003+1\u0002\u0019AA\f\u0005Mye\u000e\\=OK^d\u0015N\\3Ji\u0016\u0014\u0018\r^8s'\r9\u0012\u0011\f\t\u0005\u00037\ni&D\u0001\u0015\u0013\u0011\ty&!\u0019\u0003\u00191Kg.Z%uKJ\fGo\u001c:\n\t\u0005\r\u00141\b\u0002\u0007'>,(oY3\u0015\u0005\u0005\u001d\u0004cAA./\u0005I\u0011n\u001d(fo2Lg.\u001a\u000b\u0005\u0003[\n\u0019\bE\u0002&\u0003_J1!!\u001d'\u0005\u001d\u0011un\u001c7fC:Dq!!\u001e\u001a\u0001\u0004\t9(\u0001\u0002dQB\u0019Q%!\u001f\n\u0007\u0005mdE\u0001\u0003DQ\u0006\u0014\u0018\u0001C4fi2Kg.Z:\u0015\u0005\u0005\u0005\u0005\u0003\u0002\u001b\u0002\u0004~J1!!\"?\u0005!IE/\u001a:bi>\u0014\b")
public class CommandExecutionContext
implements Logger {
    private final ArrayBuffer<String> stdoutBuffer;
    private final ArrayBuffer<String> stderrBuffer;
    private final ProcessIO processIO;
    private final Process process;
    private transient com.typesafe.scalalogging.Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        CommandExecutionContext commandExecutionContext = this;
        synchronized (commandExecutionContext) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ArrayBuffer<String> stdoutBuffer() {
        return this.stdoutBuffer;
    }

    private ArrayBuffer<String> stderrBuffer() {
        return this.stderrBuffer;
    }

    private ProcessIO processIO() {
        return this.processIO;
    }

    private Process process() {
        return this.process;
    }

    public Future<ProcessResult> executionFuture(ExecutionContext executionContext) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ProcessResult)package$.MODULE$.blocking((Function0 & Serializable & scala.Serializable)() -> {
            int result = this.process().exitValue();
            return new ProcessResult(result, (Seq<String>)this.stdoutBuffer(), (Seq<String>)this.stderrBuffer());
        }), executionContext);
    }

    public void cleanup() {
        BoxedUnit boxedUnit;
        if (this.stderrBuffer().nonEmpty()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Command error output: {}", new Object[]{this.stderrBuffer().mkString("\n")});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.process().destroy());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Error destroying the process", e);
                return;
            }
            return;
        }
    }

    private void writeToBufferAndClose(InputStream inputStream, ArrayBuffer<String> buffer) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            new OnlyNewLineBufferedSource(inputStream).getLines().foreach((Function1 & Serializable & scala.Serializable)x$1 -> buffer.$plus$eq(x$1));
            inputStream.close();
        });
        if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Error processing the input stream", e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            inputStream.close();
            return;
        }
    }

    public CommandExecutionContext(Seq<String> command, LogContext logContext) {
        LazyLogging.$init$((LazyLogging)this);
        this.stdoutBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.stderrBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.processIO = new ProcessIO((Function1 & Serializable & scala.Serializable)writeInput -> {
            writeInput.close();
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)stdout -> {
            this.writeToBufferAndClose(stdout, this.stdoutBuffer());
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)stderr -> {
            this.writeToBufferAndClose(stderr, this.stderrBuffer());
            return BoxedUnit.UNIT;
        });
        this.process = scala.sys.process.package$.MODULE$.stringSeqToProcess(command).run(this.processIO());
    }

    private static class OnlyNewLineBufferedSource
    extends BufferedSource {
        public Iterator<String> getLines() {
            return new OnlyNewLineIterator(this);
        }

        public OnlyNewLineBufferedSource(InputStream inputStream) {
            super(inputStream, CommandExecutionContext$.MODULE$.codacy$git$runners$CommandExecutionContext$$codec());
        }

        private class OnlyNewLineIterator
        extends Source.LineIterator {
            public boolean isNewline(char ch) {
                return ch == '\n';
            }

            public /* synthetic */ OnlyNewLineBufferedSource codacy$git$runners$CommandExecutionContext$OnlyNewLineBufferedSource$OnlyNewLineIterator$$$outer() {
                return (OnlyNewLineBufferedSource)this.$outer;
            }

            public OnlyNewLineIterator(OnlyNewLineBufferedSource $outer) {
                super((Source)$outer);
            }
        }
    }
}

