/*
 * Decompiled with CFR 0.152.
 */
package codacy.utils;

import codacy.foundation.logging.context.ContextLogging;
import codacy.utils.FileSystemLocks$;
import codacy.utils.FileSystemLocks$Lock$;
import java.io.File;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.TimeoutException;
import scala.Function1;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005w!B\r\u001b\u0011\u0003yb!B\u0011\u001b\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003bB\u0016\u0002\u0005\u0004%I\u0001\f\u0005\u0007\u0005\u0006\u0001\u000b\u0011B\u0017\u0007\u000f\r\u000b\u0001\u0013aI\u0011\t\u001e)10\u0001EG!\u001a)1)\u0001EG\r\")\u0011f\u0002C\u0001\u001f\"9\u0011kBA\u0001\n\u0003\u0012\u0006b\u0002-\b\u0003\u0003%\t!\u0017\u0005\b;\u001e\t\t\u0011\"\u0001_\u0011\u001d!w!!A\u0005B\u0015Dq\u0001\\\u0004\u0002\u0002\u0013\u0005Q\u000eC\u0004s\u000f\u0005\u0005I\u0011I:\t\u000fQ<\u0011\u0011!C!k\"9aoBA\u0001\n\u00139haB\u0011\u001b!\u0003\r\t\u0001 \u0005\b\u0003\u001f\tB\u0011AA\t\u0011\u001d\tI\"\u0005C\u0005\u00037Aq!!\u0010\u0012\t\u0013\ty\u0004C\u0004\u0002HE!\t!!\u0013\t\u0013\u0005M\u0014#%A\u0005\u0002\u0005U\u0004bBAH#\u0011%\u0011\u0011\u0013\u0005\b\u0003/\u000bB\u0011BAM\u0003=1\u0015\u000e\\3TsN$X-\u001c'pG.\u001c(BA\u000e\u001d\u0003\u0015)H/\u001b7t\u0015\u0005i\u0012AB2pI\u0006\u001c\u0017p\u0001\u0001\u0011\u0005\u0001\nQ\"\u0001\u000e\u0003\u001f\u0019KG.Z*zgR,W\u000eT8dWN\u001c\"!A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq$\u0001\u0002bYV\tQ\u0006E\u0002/k]j\u0011a\f\u0006\u0003aE\n!bY8oGV\u0014(/\u001a8u\u0015\t\u00114'\u0001\u0003vi&d'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003m=\u0012AcQ8qs>swK]5uK\u0006\u0013(/Y=MSN$\bC\u0001\u001d@\u001d\tIT\b\u0005\u0002;K5\t1H\u0003\u0002==\u00051AH]8pizJ!AP\u0013\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015I\u0001\u0004TiJLgn\u001a\u0006\u0003}\u0015\n1!\u00197!\u0005\u0011aunY6\u0014\u0005\u0015\u0019\u0013FA\u0003\b'\u001591eR%M!\tAU!D\u0001\u0002!\t!#*\u0003\u0002LK\t9\u0001K]8ek\u000e$\bC\u0001\u0013N\u0013\tqUE\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001Q!\tAu!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002'B\u0011AkV\u0007\u0002+*\u0011akM\u0001\u0005Y\u0006tw-\u0003\u0002A+\u0006a\u0001O]8ek\u000e$\u0018I]5usV\t!\f\u0005\u0002%7&\u0011A,\n\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0003?\n\u0004\"\u0001\n1\n\u0005\u0005,#aA!os\"91mCA\u0001\u0002\u0004Q\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/F\u0001g!\r9'nX\u0007\u0002Q*\u0011\u0011.J\u0001\u000bG>dG.Z2uS>t\u0017BA6i\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u00059\f\bC\u0001\u0013p\u0013\t\u0001XEA\u0004C_>dW-\u00198\t\u000f\rl\u0011\u0011!a\u0001?\u0006A\u0001.Y:i\u0007>$W\rF\u0001[\u0003!!xn\u0015;sS:<G#A*\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002qB\u0011A+_\u0005\u0003uV\u0013aa\u00142kK\u000e$\u0018\u0001\u0002'pG.\u001c2!E\u0012~!\rq\u00181B\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u001d\u0019wN\u001c;fqRTA!!\u0002\u0002\b\u00059An\\4hS:<'bAA\u00059\u0005Qam\\;oI\u0006$\u0018n\u001c8\n\u0007\u00055qP\u0001\bD_:$X\r\u001f;M_\u001e<\u0017N\\4\u0002\r\u0011Jg.\u001b;%)\t\t\u0019\u0002E\u0002%\u0003+I1!a\u0006&\u0005\u0011)f.\u001b;\u0002%\u0019LG.\u001a(b[\u0016$v\u000eT8dWB\u000bG\u000f\u001b\u000b\u0005\u0003;\ti\u0003\u0005\u0003\u0002 \u0005%RBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\t\u0019LG.\u001a\u0006\u0004\u0003O\u0019\u0014a\u00018j_&!\u00111FA\u0011\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\u0005=2\u00031\u0001\u00022\u0005\ta\r\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9dM\u0001\u0003S>LA!a\u000f\u00026\t!a)\u001b7f\u0003\rqwn\u001e\u000b\u0003\u0003\u0003\u00022\u0001JA\"\u0013\r\t)%\n\u0002\u0005\u0019>tw-\u0001\u0003m_\u000e\\W\u0003BA&\u0003'\"b!!\u0014\u0002n\u0005=D\u0003BA(\u0003?\u0002B!!\u0015\u0002T1\u0001AaBA++\t\u0007\u0011q\u000b\u0002\u0002\u0003F\u0019\u0011\u0011L0\u0011\u0007\u0011\nY&C\u0002\u0002^\u0015\u0012qAT8uQ&tw\rC\u0004\u0002bU\u0001\r!a\u0019\u0002\r5,G\u000f[8e!\u001d!\u0013QMA5\u0003\u001fJ1!a\u001a&\u0005%1UO\\2uS>t\u0017\u0007E\u0002\u0002l\u0015q!\u0001\t\u0001\t\u000f\u0005\rR\u00031\u0001\u00022!I\u0011\u0011O\u000b\u0011\u0002\u0003\u0007\u0011\u0011I\u0001\b[\u0006DH+[7f\u00039awnY6%I\u00164\u0017-\u001e7uII*B!a\u001e\u0002\u000eV\u0011\u0011\u0011\u0010\u0016\u0005\u0003\u0003\nYh\u000b\u0002\u0002~A!\u0011qPAE\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015!C;oG\",7m[3e\u0015\r\t9)J\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAF\u0003\u0003\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u001d\t)F\u0006b\u0001\u0003/\nQ!Y<bSR$B!a\u0005\u0002\u0014\"9\u0011QS\fA\u0002\u0005\u0005\u0013AA7t\u0003\u0019!w\u000eT8dWV!\u00111TAR)\u0019\ti*!,\u0002>R!\u0011qTAU)\u0011\t\t+!*\u0011\t\u0005E\u00131\u0015\u0003\b\u0003+B\"\u0019AA,\u0011\u001d\t9\u000b\u0007a\u0001\u0003\u0003\nq!\u001a8e)&lW\rC\u0004\u0002ba\u0001\r!a+\u0011\u000f\u0011\n)'!\u001b\u0002\"\"9\u0011q\u0016\rA\u0002\u0005E\u0016A\u00014d!\u0011\t\u0019,!/\u000e\u0005\u0005U&\u0002BA\\\u0003K\t\u0001b\u00195b]:,Gn]\u0005\u0005\u0003w\u000b)LA\u0006GS2,7\t[1o]\u0016d\u0007BBA`1\u0001\u0007q'\u0001\u0004gG:\u000bW.\u001a")
public interface FileSystemLocks
extends ContextLogging {
    private Path fileNameToLockPath(File f) {
        File parentName = f.getParentFile();
        return Paths.get(parentName.getAbsolutePath(), new StringBuilder(5).append(f.getName()).append(".lock").toString());
    }

    private long now() {
        return System.currentTimeMillis();
    }

    public static /* synthetic */ Object lock$(FileSystemLocks $this, File file, long maxTime, Function1 method) {
        return $this.lock(file, maxTime, method);
    }

    default public <A> A lock(File file, long maxTime, Function1<Lock, A> method) {
        A a;
        long startTime = this.now();
        Path lockPath = this.fileNameToLockPath(file);
        file.getParentFile().mkdirs();
        FileChannel fileChannel = FileChannel.open(lockPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.SYNC, StandardOpenOption.DELETE_ON_CLOSE);
        String fcName = ((Object)lockPath.toAbsolutePath()).toString();
        try {
            a = this.doLock(fileChannel, fcName, method, startTime + maxTime);
        }
        finally {
            FileSystemLocks$.MODULE$.codacy$utils$FileSystemLocks$$al().remove(fcName);
            fileChannel.close();
        }
        return a;
    }

    public static /* synthetic */ long lock$default$2$(FileSystemLocks $this) {
        return $this.lock$default$2();
    }

    default public <A> long lock$default$2() {
        return 3600000L;
    }

    private void await(long ms) {
        Thread.sleep(ms);
    }

    private <A> A doLock(FileChannel fc, String fcName, Function1<Lock, A> method, long endTime) {
        Object result = null;
        while (result == null && this.now() < endTime) {
            try {
                if (FileSystemLocks$.MODULE$.codacy$utils$FileSystemLocks$$al().addIfAbsent(fcName)) {
                    FileLock lock = fc.lock(0L, Long.MAX_VALUE, false);
                    if (lock.isValid()) {
                        Channel channel = lock.acquiredBy();
                        FileChannel fileChannel = fc;
                        if (!(channel != null ? !channel.equals(fileChannel) : fileChannel != null)) {
                            Object object;
                            try {
                                object = method.apply((Object)FileSystemLocks$Lock$.MODULE$);
                            }
                            finally {
                                lock.release();
                            }
                            result = object;
                            continue;
                        }
                    }
                    this.await(100L);
                    continue;
                }
                this.await(100L);
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                this.await(100L);
            }
        }
        if (this.now() >= endTime) {
            throw new TimeoutException("Timeout expired while trying to lock");
        }
        return (A)result;
    }

    public static void $init$(FileSystemLocks $this) {
    }

    public static interface Lock {
    }
}

