/*
 * Decompiled with CFR 0.152.
 */
package codacy.git.repository;

import codacy.foundation.logging.context.ContextAwareLogger;
import codacy.foundation.logging.context.ContextLogging;
import codacy.foundation.logging.context.ProjectLogContext;
import codacy.foundation.utils.InputValidation$;
import codacy.git.authentication.SSHAuthenticationWrapper$;
import codacy.git.authentication.TokenAuthenticationWrapper$;
import codacy.git.repository.AccessTokenRepositoryData;
import codacy.git.repository.EmptyRepositoryData$;
import codacy.git.repository.ProjectRequest;
import codacy.git.repository.RepositoryData;
import codacy.git.repository.RepositoryUrlHelper$;
import codacy.git.repository.SshRepositoryData;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005q3QAB\u0004\u0002\u00029A\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tW\u0001\u0011\t\u0011)A\u0006Y!)!\u0007\u0001C\u0001g!)\u0011\b\u0001C\tu!)a\u000b\u0001C\t/\niq)\u001b;SKB|7/\u001b;pefT!\u0001C\u0005\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u000b\u0017\u0005\u0019q-\u001b;\u000b\u00031\taaY8eC\u000eL8\u0001A\n\u0004\u0001=)\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0017;5\tqC\u0003\u0002\u00193\u000591m\u001c8uKb$(B\u0001\u000e\u001c\u0003\u001dawnZ4j]\u001eT!\u0001H\u0006\u0002\u0015\u0019|WO\u001c3bi&|g.\u0003\u0002\u001f/\tq1i\u001c8uKb$Hj\\4hS:<\u0017A\u0006:fa>\u001c\u0018\u000e^8ss.+\u0017p\u001d'pG\u0006$\u0018n\u001c8\u0011\u0005\u0005BcB\u0001\u0012'!\t\u0019\u0013#D\u0001%\u0015\t)S\"\u0001\u0004=e>|GOP\u0005\u0003OE\ta\u0001\u0015:fI\u00164\u0017BA\u0015+\u0005\u0019\u0019FO]5oO*\u0011q%E\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\"!\f\u0019\u000e\u00039R!aL\t\u0002\u0015\r|gnY;se\u0016tG/\u0003\u00022]\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005QBDCA\u001b8!\t1\u0004!D\u0001\b\u0011\u0015Y3\u0001q\u0001-\u0011\u0015y2\u00011\u0001!\u0003q9(/\u00199D_6l\u0017M\u001c3XSRD\u0017)\u001e;i_JL'0\u0019;j_:$2a\u000f&P)\taT\tE\u0002>\u0005\u0002r!A\u0010!\u000f\u0005\rz\u0014\"\u0001\n\n\u0005\u0005\u000b\u0012a\u00029bG.\fw-Z\u0005\u0003\u0007\u0012\u00131aU3r\u0015\t\t\u0015\u0003C\u0003G\t\u0001\u000fq)\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u0004\"A\u0006%\n\u0005%;\"!\u0005)s_*,7\r\u001e'pO\u000e{g\u000e^3yi\")1\n\u0002a\u0001\u0019\u00069!/Z9vKN$\bC\u0001\u001cN\u0013\tquA\u0001\bQe>TWm\u0019;SKF,Xm\u001d;\t\u000bA#\u0001\u0019A)\u0002\u0015\u001dLGoQ8n[\u0006tG\rE\u0002S+\u0002j\u0011a\u0015\u0006\u0003)F\t!bY8mY\u0016\u001cG/[8o\u0013\t\u00195+A\tqe>\u001cWm]:Qe>TWm\u0019;Ve2$\"\u0001\u0017.\u0015\u0005\u0001J\u0006\"\u0002$\u0006\u0001\b9\u0005\"B.\u0006\u0001\u0004a\u0015a\u00029s_*,7\r\u001e")
public abstract class GitRepository
implements ContextLogging {
    private final String repositoryKeysLocation;
    private transient ContextAwareLogger logger;
    private volatile transient boolean bitmap$trans$0;

    private ContextAwareLogger logger$lzycompute() {
        GitRepository gitRepository = this;
        synchronized (gitRepository) {
            if (!this.bitmap$trans$0) {
                this.logger = ContextLogging.logger$((ContextLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public ContextAwareLogger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public scala.collection.immutable.Seq<String> wrapCommandWithAuthorization(ProjectRequest request, Seq<String> gitCommand, ProjectLogContext logContext) {
        String singleStringCommand = gitCommand.mkString("\"", "\" \"", "\"");
        RepositoryData repositoryData = request.data();
        if (repositoryData instanceof SshRepositoryData) {
            return SSHAuthenticationWrapper$.MODULE$.wrap(request, singleStringCommand, this.repositoryKeysLocation, logContext);
        }
        if (repositoryData instanceof AccessTokenRepositoryData) {
            return TokenAuthenticationWrapper$.MODULE$.wrap(request, singleStringCommand, logContext);
        }
        if (EmptyRepositoryData$.MODULE$.equals(repositoryData)) {
            return new .colon.colon((Object)"bash", (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)new StringBuilder(2).append("(").append(singleStringCommand).append(")").toString(), (List)Nil$.MODULE$)));
        }
        throw new MatchError((Object)repositoryData);
    }

    public String processProjectUrl(ProjectRequest project, ProjectLogContext logContext) {
        String sanitizedUrl = InputValidation$.MODULE$.sanitizeCommandParam(project.url());
        RepositoryData repositoryData = project.data();
        if (repositoryData instanceof AccessTokenRepositoryData) {
            return RepositoryUrlHelper$.MODULE$.toHttpsWithToken(sanitizedUrl, project.data().value(), RepositoryUrlHelper$.MODULE$.toHttpsWithToken$default$3(), logContext).toString();
        }
        return sanitizedUrl;
    }

    public GitRepository(String repositoryKeysLocation, ExecutionContext executionContext) {
        this.repositoryKeysLocation = repositoryKeysLocation;
        ContextLogging.$init$((ContextLogging)this);
    }
}

