/*
 * Decompiled with CFR 0.152.
 */
package codacy.git.repository;

import codacy.foundation.logging.context.ContextAwareLogger;
import codacy.foundation.logging.context.ContextLogging;
import codacy.foundation.logging.context.LogContext;
import codacy.foundation.logging.context.ProjectLogContext;
import codacy.git.repository.Protocol$;
import java.io.Serializable;
import java.net.URI;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.util.matching.Regex;

public final class RepositoryUrlHelper$
implements ContextLogging {
    public static final RepositoryUrlHelper$ MODULE$ = new RepositoryUrlHelper$();
    private static final String xAccessToken;
    private static final Regex gitRepoRegex;
    private static final Regex gitSshRegex;
    private static transient ContextAwareLogger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        ContextLogging.$init$((ContextLogging)MODULE$);
        xAccessToken = "x-access-token";
        gitRepoRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(git|ssh|https?|git@[-\\w.]+):(\\/\\/)?(.*?)(\\.git)?(\\/?|\\#[-\\w._]+?)$"));
        gitSshRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(git|ssh|https)@?([-\\w.]+):(\\/\\/)?(.*?)(\\.git)?(\\/?|\\#[-\\w._]+?)$"));
    }

    private ContextAwareLogger logger$lzycompute() {
        RepositoryUrlHelper$ repositoryUrlHelper$ = this;
        synchronized (repositoryUrlHelper$) {
            if (!bitmap$trans$0) {
                logger = ContextLogging.logger$((ContextLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public ContextAwareLogger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String xAccessToken() {
        return xAccessToken;
    }

    public Regex gitRepoRegex() {
        return gitRepoRegex;
    }

    public Regex gitSshRegex() {
        return gitSshRegex;
    }

    public Enumeration.Value getProtocol(String url) {
        return (Enumeration.Value)this.gitRepoRegex().findAllMatchIn((CharSequence)url).toSeq().headOption().map((Function1 & Serializable)matched -> {
            String protocol = matched.group(1);
            String string = protocol;
            switch (string == null ? 0 : string.hashCode()) {
                case 99617003: {
                    if (!"https".equals(string)) break;
                    return Protocol$.MODULE$.https();
                }
            }
            if (string.startsWith("git")) {
                return Protocol$.MODULE$.ssh();
            }
            return Protocol$.MODULE$.invalid();
        }).getOrElse((Function0 & Serializable)() -> Protocol$.MODULE$.invalid());
    }

    public URI toHttpsWithToken(String url, String token, String userPart, ProjectLogContext logContext) {
        Enumeration.Value value = this.getProtocol(url);
        Enumeration.Value value2 = Protocol$.MODULE$.ssh();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return this.changeSshUrlToHttpsWithToken(url, token, userPart);
        }
        Enumeration.Value value4 = Protocol$.MODULE$.https();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return this.addToken(url, token, userPart);
        }
        Enumeration.Value value6 = Protocol$.MODULE$.invalid();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            String message = new StringBuilder(25).append("Invalid protocol in url: ").append(url).toString();
            this.logger().error(message, (LogContext)logContext);
            throw new IllegalArgumentException(message);
        }
        throw new MatchError((Object)value);
    }

    public String toHttpsWithToken$default$3() {
        return this.xAccessToken();
    }

    private URI changeSshUrlToHttpsWithToken(String url, String token, String userPart) {
        String urlString = this.gitSshRegex().replaceAllIn((CharSequence)url, (Function1 & Serializable)matched -> {
            String domainPart = matched.group(2);
            String repoPath = matched.group(4);
            return new StringBuilder(15).append("https://").append(userPart).append(":").append(token).append("@").append(domainPart).append("/").append(repoPath).append(".git").toString();
        });
        return URI.create(urlString);
    }

    private String changeSshUrlToHttpsWithToken$default$3() {
        return this.xAccessToken();
    }

    private URI addToken(String url, String token, String userPart) {
        URI uri = URI.create(url);
        return URI.create(new StringBuilder(10).append("https://").append(userPart).append(":").append(token).append("@").append(uri.getHost()).append(uri.getPath()).toString());
    }

    private String addToken$default$3() {
        return this.xAccessToken();
    }

    private RepositoryUrlHelper$() {
    }
}

